/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.cdh513;

import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.plugins.DatabasePluginType;
import org.pentaho.di.core.plugins.Plugin;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.HadoopConfigurationFileSystemManager;
import org.pentaho.hadoop.shim.common.HadoopShimImpl;

public class HadoopShim
extends HadoopShimImpl {
    @Override
    public void onLoad(HadoopConfiguration config, HadoopConfigurationFileSystemManager fsm) throws Exception {
        this.registerExtraDatabaseTypes(config.getConfigProperties());
        super.onLoad(config, fsm);
    }

    protected void registerExtraDatabaseTypes(Properties configuration) throws KettlePluginException {
        String impalaSimbaDriverName = configuration.getProperty("impala.simba.driver", "com.cloudera.impala.jdbc41.Driver");
        JDBC_POSSIBLE_DRIVER_MAP.put("ImpalaSimba", impalaSimbaDriverName);
    }

    protected void registerExtraDatabaseType(String id, String description, String mainClass) throws KettlePluginException {
        HashMap<Class<DatabaseInterface>, String> classMap = new HashMap<Class<DatabaseInterface>, String>();
        classMap.put(DatabaseInterface.class, mainClass);
        Plugin dbPlugin = new Plugin(new String[]{id}, DatabasePluginType.class, DatabaseInterface.class, "", description, description, null, false, false, classMap, new ArrayList(), null, null, null, null, null);
        PluginRegistry.getInstance().addClassLoader((URLClassLoader)Thread.currentThread().getContextClassLoader().getParent(), (PluginInterface)dbPlugin);
        PluginRegistry.getInstance().registerPlugin(DatabasePluginType.class, (PluginInterface)dbPlugin);
    }
}

