/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources.services;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.action.IAction;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ISecurityHelper;
import org.pentaho.platform.api.engine.ServiceException;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.UnifiedRepositoryException;
import org.pentaho.platform.api.scheduler2.IBackgroundExecutionStreamProvider;
import org.pentaho.platform.api.scheduler2.IBlockoutManager;
import org.pentaho.platform.api.scheduler2.IJobFilter;
import org.pentaho.platform.api.scheduler2.IJobTrigger;
import org.pentaho.platform.api.scheduler2.IScheduler;
import org.pentaho.platform.api.scheduler2.Job;
import org.pentaho.platform.api.scheduler2.SchedulerException;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileDto;
import org.pentaho.platform.scheduler2.blockout.BlockoutAction;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.web.http.api.resources.ComplexJobTriggerProxy;
import org.pentaho.platform.web.http.api.resources.JobRequest;
import org.pentaho.platform.web.http.api.resources.JobScheduleParam;
import org.pentaho.platform.web.http.api.resources.JobScheduleRequest;
import org.pentaho.platform.web.http.api.resources.RepositoryFileStreamProvider;
import org.pentaho.platform.web.http.api.resources.SchedulerOutputPathResolver;
import org.pentaho.platform.web.http.api.resources.SchedulerResourceUtil;
import org.pentaho.platform.web.http.api.resources.SessionResource;
import org.pentaho.platform.web.http.api.resources.proxies.BlockStatusProxy;
import org.pentaho.platform.web.http.api.resources.services.FileService;

public class SchedulerService {
    protected IScheduler scheduler = (IScheduler)PentahoSystem.get(IScheduler.class, (String)"IScheduler2", null);
    protected IAuthorizationPolicy policy;
    protected IUnifiedRepository repository;
    protected SessionResource sessionResource;
    protected FileService fileService;
    protected IBlockoutManager blockoutManager;
    private static final Log logger = LogFactory.getLog(FileService.class);

    public Job createJob(JobScheduleRequest scheduleRequest) throws IOException, SchedulerException, IllegalAccessException {
        boolean runInBackground;
        boolean bl = runInBackground = scheduleRequest.getSimpleJobTrigger() == null && scheduleRequest.getComplexJobTrigger() == null && scheduleRequest.getCronJobTrigger() == null;
        if (!runInBackground && !this.getPolicy().isAllowed("org.pentaho.scheduler.manage")) {
            throw new SecurityException();
        }
        boolean hasInputFile = !StringUtils.isEmpty((String)scheduleRequest.getInputFile());
        RepositoryFile file = null;
        if (hasInputFile) {
            try {
                file = this.getRepository().getFile(scheduleRequest.getInputFile());
            }
            catch (UnifiedRepositoryException ure) {
                hasInputFile = false;
                logger.warn((Object)ure.getMessage(), (Throwable)ure);
            }
        }
        if (hasInputFile && StringUtils.isEmpty((String)scheduleRequest.getJobName())) {
            scheduleRequest.setJobName(file.getName().substring(0, file.getName().lastIndexOf(".")));
        } else if (!StringUtils.isEmpty((String)scheduleRequest.getActionClass())) {
            String actionClass = scheduleRequest.getActionClass().substring(scheduleRequest.getActionClass().lastIndexOf(".") + 1);
            scheduleRequest.setJobName(actionClass);
        } else if (!hasInputFile && StringUtils.isEmpty((String)scheduleRequest.getJobName())) {
            scheduleRequest.setJobName("" + System.currentTimeMillis());
        }
        if (hasInputFile) {
            boolean schedulable;
            if (file == null) {
                logger.error((Object)("Cannot find input source file " + scheduleRequest.getInputFile() + " Aborting schedule..."));
                throw new SchedulerException((Throwable)new ServiceException("Cannot find input source file " + scheduleRequest.getInputFile()));
            }
            Map metadata = this.getRepository().getFileMetadata(file.getId());
            if (metadata.containsKey("_PERM_SCHEDULABLE") && !(schedulable = BooleanUtils.toBoolean((String)((String)metadata.get("_PERM_SCHEDULABLE"))))) {
                throw new IllegalAccessException();
            }
        }
        if (scheduleRequest.getTimeZone() != null) {
            this.updateStartDateForTimeZone(scheduleRequest);
        }
        Job job = null;
        IJobTrigger jobTrigger = SchedulerResourceUtil.convertScheduleRequestToJobTrigger(scheduleRequest, this.scheduler);
        HashMap<String, Serializable> parameterMap = new HashMap<String, Serializable>();
        for (JobScheduleParam param : scheduleRequest.getJobParameters()) {
            parameterMap.put(param.getName(), param.getValue());
        }
        if (this.isPdiFile(file)) {
            parameterMap = this.handlePDIScheduling(file, parameterMap, scheduleRequest.getPdiParameters());
        }
        parameterMap.put("user_locale", LocaleHelper.getLocale());
        if (scheduleRequest.getUseWorkerNodes() != null && !scheduleRequest.getUseWorkerNodes().trim().isEmpty()) {
            parameterMap.put("useWorkerNodes", (Serializable)((Object)scheduleRequest.getUseWorkerNodes().trim()));
        }
        if (hasInputFile) {
            SchedulerOutputPathResolver outputPathResolver = this.getSchedulerOutputPathResolver(scheduleRequest);
            String outputFile = outputPathResolver.resolveOutputFilePath();
            String actionId = SchedulerResourceUtil.resolveActionId(scheduleRequest.getInputFile());
            String inputFile = scheduleRequest.getInputFile();
            parameterMap.put("ActionAdapterQuartzJob-StreamProvider-InputFile", (Serializable)((Object)inputFile));
            job = this.getScheduler().createJob(scheduleRequest.getJobName(), actionId, parameterMap, jobTrigger, (IBackgroundExecutionStreamProvider)new RepositoryFileStreamProvider(inputFile, outputFile, this.getAutoCreateUniqueFilename(scheduleRequest), this.getAppendDateFormat(scheduleRequest)));
        } else {
            String actionClass = scheduleRequest.getActionClass();
            try {
                Class<IAction> iaction = this.getAction(actionClass);
                job = this.getScheduler().createJob(scheduleRequest.getJobName(), iaction, parameterMap, jobTrigger);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return job;
    }

    public Job updateJob(JobScheduleRequest scheduleRequest) throws IllegalAccessException, IOException, SchedulerException {
        Job job = this.getScheduler().getJob(scheduleRequest.getJobId());
        if (job != null) {
            scheduleRequest.getJobParameters().add(new JobScheduleParam("ActionAdapterQuartzJob-ActionUser", job.getUserName()));
        }
        Job newJob = this.createJob(scheduleRequest);
        this.removeJob(scheduleRequest.getJobId());
        return newJob;
    }

    public Job triggerNow(String jobId) throws SchedulerException {
        Job job = this.getScheduler().getJob(jobId);
        if (this.getPolicy().isAllowed("org.pentaho.scheduler.manage")) {
            this.getScheduler().triggerNow(jobId);
        } else if (this.getSession().getName().equals(job.getUserName())) {
            this.getScheduler().triggerNow(jobId);
        }
        job = this.getScheduler().getJob(jobId);
        return job;
    }

    public Job getContentCleanerJob() throws SchedulerException {
        IPentahoSession session = this.getSession();
        String principalName = session.getName();
        Boolean canAdminister = this.getPolicy().isAllowed("org.pentaho.security.administerSecurity");
        List jobs = this.getScheduler().getJobs(this.getJobFilter(canAdminister, principalName));
        if (jobs.size() > 0) {
            return (Job)jobs.get(0);
        }
        return null;
    }

    public List<RepositoryFileDto> doGetGeneratedContentForSchedule(String lineageId) throws FileNotFoundException {
        return this.getFileService().searchGeneratedContent(this.getSessionResource().doGetCurrentUserDir(), lineageId, "lineage-id");
    }

    public Job getJob(String jobId) throws SchedulerException {
        return this.getScheduler().getJob(jobId);
    }

    public boolean isScheduleAllowed() {
        return this.getPolicy().isAllowed("org.pentaho.scheduler.manage");
    }

    public boolean isScheduleAllowed(String id) {
        Map metadata;
        Boolean canSchedule = this.isScheduleAllowed();
        if (canSchedule.booleanValue() && (metadata = this.getRepository().getFileMetadata((Serializable)((Object)id))).containsKey("_PERM_SCHEDULABLE")) {
            canSchedule = BooleanUtils.toBoolean((String)((String)metadata.get("_PERM_SCHEDULABLE")));
        }
        return canSchedule;
    }

    public IJobFilter getJobFilter(boolean canAdminister, String principalName) {
        return new JobFilter(canAdminister, principalName);
    }

    public String doGetCanSchedule() {
        Boolean isAllowed = this.getPolicy().isAllowed("org.pentaho.scheduler.manage");
        return isAllowed != false ? "true" : "false";
    }

    public String getState() throws SchedulerException {
        return this.getScheduler().getStatus().name();
    }

    public String start() throws SchedulerException {
        if (this.getPolicy().isAllowed("org.pentaho.scheduler.manage")) {
            this.getScheduler().start();
        }
        return this.getScheduler().getStatus().name();
    }

    public String pause() throws SchedulerException {
        if (this.getPolicy().isAllowed("org.pentaho.scheduler.manage")) {
            this.getScheduler().pause();
        }
        return this.getScheduler().getStatus().name();
    }

    public String shutdown() throws SchedulerException {
        if (this.getPolicy().isAllowed("org.pentaho.scheduler.manage")) {
            this.getScheduler().shutdown();
        }
        return this.getScheduler().getStatus().name();
    }

    public Job.JobState pauseJob(String jobId) throws SchedulerException {
        Job job = this.getJob(jobId);
        if (this.isScheduleAllowed() || PentahoSessionHolder.getSession().getName().equals(job.getUserName())) {
            this.getScheduler().pauseJob(jobId);
        }
        job = this.getJob(jobId);
        return job.getState();
    }

    public Job.JobState resumeJob(String jobId) throws SchedulerException {
        Job job = this.getJob(jobId);
        if (this.isScheduleAllowed() || PentahoSessionHolder.getSession().getName().equals(job.getUserName())) {
            this.getScheduler().resumeJob(jobId);
        }
        job = this.getJob(jobId);
        return job.getState();
    }

    public boolean removeJob(String jobId) throws SchedulerException {
        Job job = this.getJob(jobId);
        if (this.isScheduleAllowed() || PentahoSessionHolder.getSession().getName().equals(job.getUserName())) {
            this.getScheduler().removeJob(jobId);
            return true;
        }
        return false;
    }

    public Job getJobInfo(String jobId) throws SchedulerException {
        Job job = this.getJob(jobId);
        if (job == null) {
            return null;
        }
        if (this.canAdminister().booleanValue() || this.getSession().getName().equals(job.getUserName())) {
            for (String key : job.getJobParams().keySet()) {
                Serializable value = (Serializable)job.getJobParams().get(key);
                if (value == null || value.getClass() == null || !value.getClass().isArray()) continue;
                String[] sa = (String[])new String[0].getClass().cast(value);
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < sa.length; ++i) {
                    list.add(sa[i]);
                }
                job.getJobParams().put(key, list);
            }
            return job;
        }
        throw new RuntimeException("Job not found or improper credentials for access");
    }

    public List<Job> getBlockOutJobs() {
        return this.getBlockoutManager().getBlockOutJobs();
    }

    public boolean hasBlockouts() {
        List jobs = this.getBlockoutManager().getBlockOutJobs();
        return jobs != null && jobs.size() > 0;
    }

    public boolean willFire(IJobTrigger trigger) {
        return this.getBlockoutManager().willFire(trigger);
    }

    public boolean shouldFireNow() {
        return this.getBlockoutManager().shouldFireNow();
    }

    public Job addBlockout(JobScheduleRequest jobScheduleRequest) throws IOException, IllegalAccessException, SchedulerException {
        if (this.canAdminister().booleanValue()) {
            jobScheduleRequest.setActionClass(BlockoutAction.class.getCanonicalName());
            jobScheduleRequest.getJobParameters().add(this.getJobScheduleParam("DURATION_PARAM", jobScheduleRequest.getDuration()));
            jobScheduleRequest.getJobParameters().add(this.getJobScheduleParam("TIME_ZONE_PARAM", jobScheduleRequest.getTimeZone()));
            return this.createJob(jobScheduleRequest);
        }
        throw new IllegalAccessException();
    }

    protected JobScheduleParam getJobScheduleParam(String name, String value) {
        return new JobScheduleParam(name, value);
    }

    protected JobScheduleParam getJobScheduleParam(String name, long value) {
        return new JobScheduleParam(name, value);
    }

    protected void updateStartDateForTimeZone(JobScheduleRequest jobScheduleRequest) {
        SchedulerResourceUtil.updateStartDateForTimeZone(jobScheduleRequest);
    }

    public Job updateBlockout(String jobId, JobScheduleRequest jobScheduleRequest) throws IllegalAccessException, SchedulerException, IOException {
        boolean isJobRemoved;
        if (this.canAdminister().booleanValue() && (isJobRemoved = this.removeJob(jobId))) {
            Job job = this.addBlockout(jobScheduleRequest);
            return job;
        }
        throw new IllegalAccessException();
    }

    public BlockStatusProxy getBlockStatus(JobScheduleRequest jobScheduleRequest) throws SchedulerException {
        this.updateStartDateForTimeZone(jobScheduleRequest);
        IJobTrigger trigger = this.convertScheduleRequestToJobTrigger(jobScheduleRequest);
        Boolean totallyBlocked = false;
        Boolean partiallyBlocked = this.getBlockoutManager().isPartiallyBlocked(trigger);
        if (partiallyBlocked.booleanValue()) {
            totallyBlocked = !this.getBlockoutManager().willFire(trigger);
        }
        return this.getBlockStatusProxy(totallyBlocked, partiallyBlocked);
    }

    protected BlockStatusProxy getBlockStatusProxy(Boolean totallyBlocked, Boolean partiallyBlocked) {
        return new BlockStatusProxy(totallyBlocked, partiallyBlocked);
    }

    protected IJobTrigger convertScheduleRequestToJobTrigger(JobScheduleRequest jobScheduleRequest) throws SchedulerException {
        return SchedulerResourceUtil.convertScheduleRequestToJobTrigger(jobScheduleRequest, this.scheduler);
    }

    public JobScheduleRequest getJobInfo() {
        JobScheduleRequest jobRequest = new JobScheduleRequest();
        ComplexJobTriggerProxy proxyTrigger = new ComplexJobTriggerProxy();
        proxyTrigger.setDaysOfMonth(new int[]{1, 2, 3});
        proxyTrigger.setDaysOfWeek(new int[]{1, 2, 3});
        proxyTrigger.setMonthsOfYear(new int[]{1, 2, 3});
        proxyTrigger.setYears(new int[]{2012, 2013});
        proxyTrigger.setStartTime(new Date());
        jobRequest.setComplexJobTrigger(proxyTrigger);
        jobRequest.setInputFile("aaaaa");
        jobRequest.setOutputFile("bbbbb");
        ArrayList<JobScheduleParam> jobParams = new ArrayList<JobScheduleParam>();
        jobParams.add(new JobScheduleParam("param1", "aString"));
        jobParams.add(new JobScheduleParam("param2", 1));
        jobParams.add(new JobScheduleParam("param3", true));
        jobParams.add(new JobScheduleParam("param4", new Date()));
        jobRequest.setJobParameters(jobParams);
        return jobRequest;
    }

    public Job.JobState getJobState(JobRequest jobRequest) throws SchedulerException {
        Job job = this.getJob(jobRequest.getJobId());
        if (this.isScheduleAllowed() || this.getSession().getName().equals(job.getUserName())) {
            return job.getState();
        }
        throw new UnsupportedOperationException();
    }

    protected IPentahoSession getSession() {
        return PentahoSessionHolder.getSession();
    }

    public Class<IAction> getAction(String actionClass) throws ClassNotFoundException {
        return Class.forName(actionClass);
    }

    public IUnifiedRepository getRepository() {
        if (this.repository == null) {
            this.repository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
        }
        return this.repository;
    }

    public IScheduler getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = (IScheduler)PentahoSystem.get(IScheduler.class, (String)"IScheduler2", null);
        }
        return this.scheduler;
    }

    public IAuthorizationPolicy getPolicy() {
        if (this.policy == null) {
            this.policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        }
        return this.policy;
    }

    protected SchedulerOutputPathResolver getSchedulerOutputPathResolver(JobScheduleRequest scheduleRequest) {
        return new SchedulerOutputPathResolver(scheduleRequest);
    }

    protected boolean isPdiFile(RepositoryFile file) {
        return SchedulerResourceUtil.isPdiFile(file);
    }

    protected HashMap<String, Serializable> handlePDIScheduling(RepositoryFile file, HashMap<String, Serializable> parameterMap, Map<String, String> pdiParameters) {
        return SchedulerResourceUtil.handlePDIScheduling(file, parameterMap, pdiParameters);
    }

    public boolean getAutoCreateUniqueFilename(JobScheduleRequest scheduleRequest) {
        ArrayList<JobScheduleParam> jobParameters = scheduleRequest.getJobParameters();
        for (JobScheduleParam jobParameter : jobParameters) {
            if (!"autoCreateUniqueFilename".equals(jobParameter.getName()) || !"boolean".equals(jobParameter.getType())) continue;
            return (Boolean)jobParameter.getValue();
        }
        return true;
    }

    public String getAppendDateFormat(JobScheduleRequest scheduleRequest) {
        ArrayList<JobScheduleParam> jobParameters = scheduleRequest.getJobParameters();
        for (JobScheduleParam jobParameter : jobParameters) {
            if (!"appendDateFormat".equals(jobParameter.getName()) || !"string".equals(jobParameter.getType())) continue;
            return (String)((Object)jobParameter.getValue());
        }
        return null;
    }

    public List<Job> getJobs() throws SchedulerException {
        IPentahoSession session = this.getSession();
        final String principalName = session.getName();
        final Boolean canAdminister = this.canAdminister(session);
        List jobs = this.getScheduler().getJobs(new IJobFilter(){

            public boolean accept(Job job) {
                if (canAdminister.booleanValue()) {
                    return !"BlockoutAction".equals(job.getJobName());
                }
                return principalName.equals(job.getUserName());
            }
        });
        return jobs;
    }

    protected Boolean canAdminister() {
        return this.canAdminister(null);
    }

    protected Boolean canAdminister(IPentahoSession session) {
        if (this.getPolicy().isAllowed("org.pentaho.security.administerSecurity")) {
            return true;
        }
        return false;
    }

    protected String resolveActionId(String inputFile) {
        return SchedulerResourceUtil.resolveActionId(inputFile);
    }

    protected String getExtension(String filename) {
        return SchedulerResourceUtil.getExtension(filename);
    }

    protected SessionResource getSessionResource() {
        if (this.sessionResource == null) {
            this.sessionResource = new SessionResource();
        }
        return this.sessionResource;
    }

    protected FileService getFileService() {
        if (this.fileService == null) {
            this.fileService = new FileService();
        }
        return this.fileService;
    }

    protected IBlockoutManager getBlockoutManager() {
        if (this.blockoutManager == null) {
            this.blockoutManager = (IBlockoutManager)PentahoSystem.get(IBlockoutManager.class, (String)"IBlockoutManager", null);
        }
        return this.blockoutManager;
    }

    protected ISecurityHelper getSecurityHelper() {
        return SecurityHelper.getInstance();
    }

    private class JobFilter
    implements IJobFilter {
        private boolean canAdminister;
        private String principalName;

        public JobFilter(boolean canAdminister, String principalName) {
            this.canAdminister = canAdminister;
            this.principalName = principalName;
        }

        public boolean accept(Job job) {
            String actionClass = (String)job.getJobParams().get("ActionAdapterQuartzJob-ActionClass");
            if (this.canAdminister && "org.pentaho.platform.admin.GeneratedContentCleaner".equals(actionClass)) {
                return true;
            }
            return this.principalName.equals(job.getUserName()) && "org.pentaho.platform.admin.GeneratedContentCleaner".equals(actionClass);
        }
    }
}

