/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.platform.api.repository2.unified.UnifiedRepositoryException;
import org.pentaho.platform.api.scheduler2.IJobTrigger;
import org.pentaho.platform.api.scheduler2.Job;
import org.pentaho.platform.api.scheduler2.SchedulerException;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileDto;
import org.pentaho.platform.web.http.api.resources.AbstractJaxRSResource;
import org.pentaho.platform.web.http.api.resources.JobRequest;
import org.pentaho.platform.web.http.api.resources.JobScheduleRequest;
import org.pentaho.platform.web.http.api.resources.SchedulerResourceUtil;
import org.pentaho.platform.web.http.api.resources.proxies.BlockStatusProxy;
import org.pentaho.platform.web.http.api.resources.services.SchedulerService;
import org.pentaho.platform.web.http.messages.Messages;

@Path(value="/scheduler")
public class SchedulerResource
extends AbstractJaxRSResource {
    protected SchedulerService schedulerService = new SchedulerService();
    protected static final Log logger = LogFactory.getLog(SchedulerResource.class);

    @POST
    @Path(value="/job")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Schedule created successfully."), @ResponseCode(code=401, condition="User is not allowed to create schedules."), @ResponseCode(code=403, condition="Cannot create schedules for the specified file."), @ResponseCode(code=500, condition="An error occurred while creating a schedule.")})
    public Response createJob(JobScheduleRequest scheduleRequest) {
        try {
            Job job = this.schedulerService.createJob(scheduleRequest);
            return this.buildPlainTextOkResponse(job.getJobId());
        }
        catch (SchedulerException e) {
            return this.buildServerErrorResponse(e.getCause().getMessage());
        }
        catch (IOException e) {
            return this.buildServerErrorResponse(e.getCause().getMessage());
        }
        catch (SecurityException e) {
            return this.buildStatusResponse(Response.Status.UNAUTHORIZED);
        }
        catch (IllegalAccessException e) {
            return this.buildStatusResponse(Response.Status.FORBIDDEN);
        }
    }

    @POST
    @Path(value="/job/update")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Schedule updated successfully."), @ResponseCode(code=401, condition="User is not allowed to update schedules."), @ResponseCode(code=403, condition="Cannot update schedules for the specified file."), @ResponseCode(code=500, condition="An error occurred while updating a schedule.")})
    public Response updateJob(JobScheduleRequest scheduleRequest) {
        try {
            Job job = this.schedulerService.updateJob(scheduleRequest);
            return this.buildPlainTextOkResponse(job.getJobId());
        }
        catch (SchedulerException e) {
            return this.buildServerErrorResponse(e.getCause().getMessage());
        }
        catch (IOException e) {
            return this.buildServerErrorResponse(e.getCause().getMessage());
        }
        catch (SecurityException e) {
            return this.buildStatusResponse(Response.Status.UNAUTHORIZED);
        }
        catch (IllegalAccessException e) {
            return this.buildStatusResponse(Response.Status.FORBIDDEN);
        }
    }

    @POST
    @Path(value="/triggerNow")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Job triggered successfully."), @ResponseCode(code=400, condition="Invalid input."), @ResponseCode(code=500, condition="Invalid jobId.")})
    public Response triggerNow(JobRequest jobRequest) {
        try {
            Job job = this.schedulerService.triggerNow(jobRequest.getJobId());
            return this.buildPlainTextOkResponse(job.getState().name());
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @GET
    @Path(value="/getContentCleanerJob")
    @Produces(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Content cleaner job successfully retrieved."), @ResponseCode(code=204, condition="No content cleaner job exists.")})
    public Job getContentCleanerJob() {
        try {
            return this.schedulerService.getContentCleanerJob();
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    @GET
    @Path(value="/jobs")
    @Produces(value={"application/json", "application/xml"})
    @Facet(name="Unsupported")
    @StatusCodes(value={@ResponseCode(code=200, condition="Jobs retrieved successfully."), @ResponseCode(code=500, condition="Error while retrieving jobs.")})
    public List<Job> getJobs(@DefaultValue(value="false") @QueryParam(value="asCronString") Boolean asCronString) {
        try {
            return this.schedulerService.getJobs();
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @GET
    @Path(value="/getJobs")
    @Produces(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Jobs retrieved successfully."), @ResponseCode(code=500, condition="Error while retrieving jobs.")})
    public List<Job> getAllJobs() {
        try {
            return this.schedulerService.getJobs();
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @GET
    @Path(value="/isScheduleAllowed")
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved scheduling ability of repository file."), @ResponseCode(code=500, condition="Invalid repository file id.")})
    public String isScheduleAllowed(@QueryParam(value="id") String id) {
        return "" + this.schedulerService.isScheduleAllowed(id);
    }

    @GET
    @Path(value="/canSchedule")
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successful retrieved the scheduling permission."), @ResponseCode(code=500, condition="Unable to retrieve the scheduling permission.")})
    public String doGetCanSchedule() {
        return this.schedulerService.doGetCanSchedule();
    }

    @GET
    @Path(value="/state")
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the state of the scheduler."), @ResponseCode(code=500, condition="An error occurred when getting the state of the scheduler.")})
    public Response getState() {
        try {
            String state = this.schedulerService.getState();
            return this.buildPlainTextOkResponse(state);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @POST
    @Path(value="/start")
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully started the server."), @ResponseCode(code=500, condition="An error occurred when resuming the scheduler.")})
    public Response start() {
        try {
            String status = this.schedulerService.start();
            return this.buildPlainTextOkResponse(status);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @POST
    @Path(value="/pause")
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully paused the server."), @ResponseCode(code=500, condition="An error occurred when pausing the scheduler.")})
    public Response pause() {
        try {
            String status = this.schedulerService.pause();
            return this.buildPlainTextOkResponse(status);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @POST
    @Path(value="/shutdown")
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully shut down the server."), @ResponseCode(code=500, condition="An error occurred when shutting down the scheduler.")})
    public Response shutdown() {
        try {
            String status = this.schedulerService.shutdown();
            return this.buildPlainTextOkResponse(status);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @POST
    @Path(value="/jobState")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the state of the requested job."), @ResponseCode(code=500, condition="Invalid jobId.")})
    public Response getJobState(JobRequest jobRequest) {
        try {
            return this.buildPlainTextOkResponse(this.schedulerService.getJobState(jobRequest).name());
        }
        catch (UnsupportedOperationException e) {
            return this.buildPlainTextStatusResponse(Response.Status.UNAUTHORIZED);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @POST
    @Path(value="/pauseJob")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully paused the job."), @ResponseCode(code=500, condition="Invalid jobId.")})
    public Response pauseJob(JobRequest jobRequest) {
        try {
            Job.JobState state = this.schedulerService.pauseJob(jobRequest.getJobId());
            return this.buildPlainTextOkResponse(state.name());
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @POST
    @Path(value="/resumeJob")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully resumed the job."), @ResponseCode(code=500, condition="Invalid jobId.")})
    public Response resumeJob(JobRequest jobRequest) {
        try {
            Job.JobState state = this.schedulerService.resumeJob(jobRequest.getJobId());
            return this.buildPlainTextOkResponse(state.name());
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @DELETE
    @Path(value="/removeJob")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully removed the job."), @ResponseCode(code=500, condition="Invalid jobId.")})
    public Response removeJob(JobRequest jobRequest) {
        try {
            if (this.schedulerService.removeJob(jobRequest.getJobId())) {
                return this.buildPlainTextOkResponse("REMOVED");
            }
            Job job = this.schedulerService.getJob(jobRequest.getJobId());
            return this.buildPlainTextOkResponse(job.getState().name());
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @GET
    @Path(value="/jobinfo")
    @Produces(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the information for the requested job."), @ResponseCode(code=204, condition="jobId is valid, but the job is either finished or does not exists."), @ResponseCode(code=500, condition="Internal error or invalid jobId.")})
    public Response getJob(@QueryParam(value="jobId") String jobId, @DefaultValue(value="false") @QueryParam(value="asCronString") String asCronString) {
        try {
            Job jobInfo = this.schedulerService.getJobInfo(jobId);
            if (jobInfo == null) {
                return this.buildStatusResponse(Response.Status.NO_CONTENT);
            }
            return this.buildOkResponse(jobInfo);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    @GET
    @Path(value="/jobinfotest")
    @Produces(value={"application/json"})
    @Facet(name="Unsupported")
    public JobScheduleRequest getJobInfo() {
        return this.schedulerService.getJobInfo();
    }

    @Deprecated
    @Facet(name="Unsupported")
    public List<Job> getJobs() {
        return this.getBlockoutJobs();
    }

    @GET
    @Path(value="/blockout/blockoutjobs")
    @Produces(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved blockout jobs.")})
    public List<Job> getBlockoutJobs() {
        return this.schedulerService.getBlockOutJobs();
    }

    @GET
    @Path(value="/blockout/hasblockouts")
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully determined whether or not the system contains blockouts.")})
    public Response hasBlockouts() {
        Boolean hasBlockouts = this.schedulerService.hasBlockouts();
        return this.buildOkResponse(hasBlockouts.toString());
    }

    @POST
    @Path(value="/blockout/add")
    @Consumes(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successful operation."), @ResponseCode(code=401, condition="User is not authorized to create blockout.")})
    public Response addBlockout(JobScheduleRequest jobScheduleRequest) {
        try {
            Job job = this.schedulerService.addBlockout(jobScheduleRequest);
            return this.buildPlainTextOkResponse(job.getJobId());
        }
        catch (IOException e) {
            return this.buildStatusResponse(Response.Status.UNAUTHORIZED);
        }
        catch (SchedulerException e) {
            return this.buildStatusResponse(Response.Status.UNAUTHORIZED);
        }
        catch (IllegalAccessException e) {
            return this.buildStatusResponse(Response.Status.UNAUTHORIZED);
        }
    }

    @POST
    @Path(value="/blockout/update")
    @Consumes(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successful operation."), @ResponseCode(code=401, condition="User is not authorized to update blockout.")})
    public Response updateBlockout(@QueryParam(value="jobid") String jobId, JobScheduleRequest jobScheduleRequest) {
        try {
            Job job = this.schedulerService.updateBlockout(jobId, jobScheduleRequest);
            return this.buildPlainTextOkResponse(job.getJobId());
        }
        catch (IOException e) {
            return this.buildStatusResponse(Response.Status.UNAUTHORIZED);
        }
        catch (SchedulerException e) {
            return this.buildStatusResponse(Response.Status.UNAUTHORIZED);
        }
        catch (IllegalAccessException e) {
            return this.buildStatusResponse(Response.Status.UNAUTHORIZED);
        }
    }

    @POST
    @Path(value="/blockout/willFire")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successful operation."), @ResponseCode(code=500, condition="An error occurred while determining blockouts being fired.")})
    public Response blockoutWillFire(JobScheduleRequest jobScheduleRequest) {
        Boolean willFire;
        try {
            willFire = this.schedulerService.willFire(this.convertScheduleRequestToJobTrigger(jobScheduleRequest));
        }
        catch (UnifiedRepositoryException e) {
            return this.buildServerErrorResponse((Object)e);
        }
        catch (SchedulerException e) {
            return this.buildServerErrorResponse((Object)e);
        }
        return this.buildOkResponse(willFire.toString());
    }

    @GET
    @Path(value="/blockout/shouldFireNow")
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successful operation.")})
    public Response shouldFireNow() {
        Boolean result = this.schedulerService.shouldFireNow();
        return this.buildOkResponse(result.toString());
    }

    @POST
    @Path(value="/blockout/blockstatus")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully got the blockout status."), @ResponseCode(code=401, condition="User is not authorized to get the blockout status.")})
    public Response getBlockStatus(JobScheduleRequest jobScheduleRequest) {
        try {
            BlockStatusProxy blockStatusProxy = this.schedulerService.getBlockStatus(jobScheduleRequest);
            return this.buildOkResponse(blockStatusProxy);
        }
        catch (SchedulerException e) {
            return this.buildStatusResponse(Response.Status.UNAUTHORIZED);
        }
    }

    @GET
    @Path(value="/generatedContentForSchedule")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully got the generated content for schedule")})
    public List<RepositoryFileDto> doGetGeneratedContentForSchedule(@QueryParam(value="lineageId") String lineageId) {
        List<RepositoryFileDto> repositoryFileDtoList = new ArrayList<RepositoryFileDto>();
        try {
            repositoryFileDtoList = this.schedulerService.doGetGeneratedContentForSchedule(lineageId);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Throwable t) {
            logger.error((Object)Messages.getInstance().getString("FileResource.GENERATED_CONTENT_FOR_USER_FAILED", new Object[]{lineageId}), t);
        }
        return repositoryFileDtoList;
    }

    protected Response buildOkResponse(Object entity) {
        return Response.ok((Object)entity).build();
    }

    protected Response buildPlainTextOkResponse(String msg) {
        return Response.ok((Object)msg).type("text/plain").build();
    }

    protected Response buildServerErrorResponse(Object entity) {
        return Response.serverError().entity(entity).build();
    }

    protected Response buildStatusResponse(Response.Status status) {
        return Response.status((Response.Status)status).build();
    }

    protected Response buildPlainTextStatusResponse(Response.Status status) {
        return Response.status((Response.Status)status).type("text/plain").build();
    }

    protected JobRequest getJobRequest() {
        return new JobRequest();
    }

    protected IJobTrigger convertScheduleRequestToJobTrigger(JobScheduleRequest request) throws SchedulerException {
        return SchedulerResourceUtil.convertScheduleRequestToJobTrigger(request, this.schedulerService.getScheduler());
    }
}

