/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.automodel.importing.strategy;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.metadata.automodel.PhysicalTableImporter;
import org.pentaho.metadata.model.thin.Column;

public class CsvDatasourceImportStrategy
implements PhysicalTableImporter.ImportStrategy {
    private Map<String, String> columnsIdToNameMap = new HashMap<String, String>();

    public CsvDatasourceImportStrategy(Column[] columns) {
        this.bindIdsToNames(columns);
    }

    private void bindIdsToNames(Column[] columns) {
        for (Column column : columns) {
            String name = column.getName();
            String id = column.getId();
            if (name == null || id == null) continue;
            this.columnsIdToNameMap.put(column.getId(), column.getName());
        }
    }

    @Override
    public boolean shouldInclude(ValueMetaInterface valueMeta) {
        return true;
    }

    @Override
    public String displayName(ValueMetaInterface valueMeta) {
        String columnId = valueMeta.getName();
        String columnName = this.columnsIdToNameMap.get(columnId);
        return columnName == null ? columnId : columnName;
    }
}

