/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.typehandling;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.pentaho.big.data.kettle.plugins.formats.orc.output.OrcOutputField;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.spark.api.Field;
import org.pentaho.di.engine.spark.api.FormatField;
import org.pentaho.di.engine.spark.api.IFormatDataType;
import org.pentaho.di.engine.spark.impl.typehandling.FormatDataTypeProvider;
import org.pentaho.di.engine.spark.impl.typehandling.FormatStructTypeMapper;
import org.pentaho.di.engine.spark.impl.typehandling.OrcSpec;
import org.pentaho.hadoop.shim.api.format.IFormatInputField;
import org.pentaho.hadoop.shim.api.format.IOrcInputField;

public class OrcTypeMapper
extends FormatStructTypeMapper {
    public OrcTypeMapper(IOrcInputField[] orcInputFields, StructType schema, Class<? extends IFormatDataType> dataTypeEnumeration) {
        this.iFormatDataTypeProvider = new FormatDataTypeProvider(OrcSpec.DataType.class);
        this.generateInputFormatFields((IFormatInputField[])orcInputFields, schema);
    }

    public OrcTypeMapper(RowMetaInterface orcInputFields, List<OrcOutputField> orcOutputFields, boolean allowNullables, Class<? extends IFormatDataType> dataTypeEnumeration) {
        this.iFormatDataTypeProvider = new FormatDataTypeProvider(OrcSpec.DataType.class);
        List<Field> incomingPdiFields = FormatStructTypeMapper.from(orcInputFields);
        this.generateOutputFormatFields(orcOutputFields, incomingPdiFields, allowNullables);
    }

    public static List<Field> from(List<? extends IOrcInputField> orcInputFields) {
        List<Field> fields = orcInputFields.stream().map(field -> Field.FieldBuilder.builder().path(field.getFormatFieldName()).name(field.getPentahoFieldName()).type(field.getFormatType()).build()).collect(Collectors.toList());
        return fields;
    }

    @Override
    protected Object sparkToStaging(Object value, DataType sparkSqlType, FormatField formatField) {
        Object retVal;
        if (value == null) {
            return null;
        }
        if (this.isDate(formatField.getPdiField().getType())) {
            if (sparkSqlType == DataTypes.IntegerType) {
                LocalDate localDate = LocalDate.ofEpochDay(0L).plusDays(((Integer)value).intValue());
                return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant()).getTime();
            }
            retVal = value;
        } else {
            retVal = sparkSqlType == DataTypes.ShortType ? new Long(((Short)value).shortValue()) : (sparkSqlType == DataTypes.StringType && formatField.getStagingField().getType() == 6 ? new BigDecimal(value.toString()) : super.sparkToStaging(value, sparkSqlType, formatField));
        }
        return retVal;
    }
}

