/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.typehandling;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.pentaho.di.engine.spark.api.IFormatDataType;
import org.pentaho.di.engine.spark.api.IObjectConverter;
import org.pentaho.di.engine.spark.api.SparkDataType;

public class OrcSpec {
    public static final int DEFAULT_DECIMAL_PRECISION = 20;
    public static final int DEFAULT_DECIMAL_SCALE = 10;

    public static enum DataType implements IFormatDataType
    {
        NULL(0, true, "null", null, false, "Null", 0, SparkDataType.NULL_TYPE.ordinal(), null),
        BOOLEAN(1, true, "LongColumnVector", null, true, "Boolean", 4, SparkDataType.BOOLEAN_TYPE.ordinal(), null),
        TINYINT(2, true, "LongColumnVector", null, true, "TinyInt", 5, SparkDataType.NULL_TYPE.ordinal(), null),
        SMALLINT(3, true, "LongColumnVector", null, true, "SmallInt", 5, SparkDataType.SHORT_TYPE.ordinal(), (IObjectConverter & Serializable)input -> ((Long)input).shortValue()),
        INTEGER(4, true, "LongColumnVector", null, true, "Int", 5, SparkDataType.INTEGER_TYPE.ordinal(), (IObjectConverter & Serializable)input -> ((Long)input).intValue()),
        BIGINT(5, true, "LongColumnVector", null, true, "BigInt", 5, SparkDataType.LONG_TYPE.ordinal(), null),
        BINARY(6, true, "BytesColumnVector", null, true, "Binary", 8, SparkDataType.BINARY_TYPE.ordinal(), null),
        FLOAT(7, true, "DoubleColumnVector", null, true, "Float", 1, SparkDataType.FLOAT_TYPE.ordinal(), (IObjectConverter & Serializable)input -> Float.valueOf(((Double)input).floatValue())),
        DOUBLE(8, true, "DoubleColumnVector", null, true, "Double", 1, SparkDataType.DOUBLE_TYPE.ordinal(), null),
        DECIMAL(9, true, "DecimalColumnVector", null, true, "Decimal", 6, SparkDataType.DECIMAL_TYPE.ordinal(), null),
        STRING(10, true, "BytesColumnVector", null, true, "String", 2, SparkDataType.STRING_TYPE.ordinal(), null),
        CHAR(11, true, "BytesColumnVector", null, true, "Char", 2, SparkDataType.NULL_TYPE.ordinal(), null),
        VARCHAR(12, true, "BytesColumnVector", null, true, "VarChar", 2, SparkDataType.NULL_TYPE.ordinal(), null),
        TIMESTAMP(13, true, "TimestampColumnVector", null, true, "Timestamp", 9, SparkDataType.TIMESTAMP_TYPE.ordinal(), null),
        DATE(14, true, "LongColumnVector", null, true, "Date", 3, SparkDataType.DATE_TYPE.ordinal(), (IObjectConverter & Serializable)input -> new java.sql.Date(((Date)input).getTime())),
        STRUCT(15, true, "StructColumnVector", null, false, "Struct", 0, SparkDataType.NULL_TYPE.ordinal(), null),
        LIST(16, true, "ListColumnVector", null, false, "List", 0, SparkDataType.NULL_TYPE.ordinal(), null),
        MAP(17, true, "MapColumnVector", null, false, "List", 0, SparkDataType.NULL_TYPE.ordinal(), null),
        UNION(18, true, "UnionColumnVector", null, false, "Union", 0, SparkDataType.NULL_TYPE.ordinal(), null);

        private final int id;
        private final boolean isPrimitive;
        private final String baseType;
        private final String logicalType;
        private final boolean displayable;
        private final String name;
        private final int pentahoType;
        private final int sparkSqlType;
        private final IObjectConverter sparkOutputConverter;
        private static final ArrayList<DataType> enumValues;

        private DataType(int id, boolean isPrimitiveType, String baseType, String logicalType, boolean displayable, String name, int pentahoType, int sparkSqlType, IObjectConverter sparkOutputConverter) {
            this.id = id;
            this.isPrimitive = isPrimitiveType;
            this.baseType = baseType;
            this.logicalType = logicalType;
            this.displayable = displayable;
            this.name = name;
            this.pentahoType = pentahoType;
            this.sparkSqlType = sparkSqlType;
            this.sparkOutputConverter = sparkOutputConverter;
        }

        public static DataType getDataType(int id) {
            return enumValues.get(id);
        }

        public int getId() {
            return this.id;
        }

        public boolean isPrimitiveType() {
            return this.isPrimitive;
        }

        public boolean isComplexType() {
            return !this.isPrimitive && this.logicalType == null;
        }

        public boolean isLogicalType() {
            return this.logicalType != null;
        }

        public String getBaseType() {
            return this.baseType;
        }

        public String getLogicalType() {
            return this.logicalType;
        }

        public String getType() {
            return this.isLogicalType() ? this.logicalType : this.baseType;
        }

        public boolean isDisplayable() {
            return this.displayable;
        }

        public String getName() {
            return this.name;
        }

        public int getPentahoType() {
            return this.pentahoType;
        }

        public int getPdiType() {
            return this.pentahoType;
        }

        public static String[] getDisplayableTypeNames() {
            return (String[])Arrays.stream(DataType.values()).filter(DataType::isDisplayable).map(DataType::getName).sorted().toArray(String[]::new);
        }

        public int getSparkSqlType() {
            return this.sparkSqlType;
        }

        public IObjectConverter getSparkOutputConverter() {
            return this.sparkOutputConverter;
        }

        static {
            enumValues = new ArrayList<DataType>(){
                {
                    for (DataType dataType : DataType.values()) {
                        this.add(dataType.getId(), dataType);
                    }
                }
            };
        }
    }
}

