/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.typehandling;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaConversionException;
import org.pentaho.di.core.row.value.ValueMetaConverter;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.engine.spark.api.Field;
import org.pentaho.di.engine.spark.api.FormatField;
import org.pentaho.di.engine.spark.api.IFormatDataType;
import org.pentaho.di.engine.spark.api.IFormatDataTypeProvider;
import org.pentaho.di.engine.spark.api.IObjectConverter;
import org.pentaho.di.engine.spark.api.SparkDataType;
import org.pentaho.di.engine.spark.api.SparkEngineException;
import org.pentaho.di.engine.spark.api.TypeMapper;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.shim.api.format.IFormatInputField;
import org.pentaho.hadoop.shim.api.format.IFormatOutputField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatStructTypeMapper
implements TypeMapper<StructType> {
    static final long serialVersionUID = -687001492234005033L;
    private static final String ERROR_NO_MATCH_INPUT = "ERROR.No_Matching_Input";
    protected IFormatDataTypeProvider iFormatDataTypeProvider;
    static final DataType DEFAULT_DECIMAL_TYPE = DataTypes.createDecimalType((int)18, (int)4);
    protected List<FormatField> formatFields;
    ValueMetaConverter valueMetaConverter = new ValueMetaConverter();
    private static final Logger LOG = LoggerFactory.getLogger(FormatStructTypeMapper.class);

    public Object[] mapValuesTo(Object[] vals) {
        this.preconditions(vals);
        Object[] objects = new Object[this.formatFields.size()];
        for (FormatField formatField : this.formatFields) {
            objects[formatField.getSparkField().getColumnOrdinal()] = this.typeToSparkCompatible(vals[formatField.getPdiField().getColumnOrdinal()], formatField);
        }
        return objects;
    }

    public Object[] mapValuesFrom(StructType schema, Object[] vals) {
        this.preconditions(vals);
        StructField[] structFields = schema.fields();
        return IntStream.range(0, this.formatFields.size()).mapToObj(index -> this.sparkToPdiConversion(vals[this.getSparkIndex(index)], structFields[this.getSparkIndex(index)].dataType(), this.formatFields.get(index))).collect(Collectors.toList()).toArray();
    }

    private int getSparkIndex(int pdiIndex) {
        return this.formatFields.get(pdiIndex).getSparkField().getColumnOrdinal();
    }

    public StructType schema() {
        StructType structType = this.getStructType();
        LOG.debug("Schema:  " + structType);
        return structType;
    }

    protected List<FormatField> generateOutputFormatFields(List<? extends IFormatOutputField> formatOutputFields, List<Field> incomingPdiFields, boolean allowSettingNullable) {
        this.formatFields = new ArrayList<FormatField>();
        int outputColumnOrdinal = 0;
        for (IFormatOutputField iFormatOutputField : formatOutputFields) {
            Field correspondingPdiField = incomingPdiFields.stream().filter(f -> f.getName().equals(formatOutputField.getPentahoFieldName())).findFirst().orElseThrow(() -> new SparkEngineException(FormatStructTypeMapper.msg(ERROR_NO_MATCH_INPUT, formatOutputField.getPentahoFieldName())));
            Field pdiField = Field.FieldBuilder.builder().field(correspondingPdiField).nullable(!allowSettingNullable).ifNull((Object)(iFormatOutputField.getDefaultValue() == null ? "" : iFormatOutputField.getDefaultValue())).build();
            IFormatDataType iFormatDataType = this.iFormatDataTypeProvider.getDataType(iFormatOutputField.getFormatType());
            Field stagingPdiField = Field.FieldBuilder.builder().name(iFormatOutputField.getPentahoFieldName()).path(iFormatOutputField.getFormatFieldName()).nullable(!allowSettingNullable).ifNull((Object)(iFormatOutputField.getDefaultValue() == null ? "" : iFormatOutputField.getDefaultValue())).type(iFormatDataType.getPdiType()).precision(iFormatOutputField.getScale()).length(iFormatOutputField.getPrecision()).dateFormat(pdiField.getDateFormat()).columnOrdinal(outputColumnOrdinal++).build();
            Field sparkField = Field.FieldBuilder.builder().name(iFormatOutputField.getFormatFieldName()).path(iFormatOutputField.getFormatFieldName()).nullable(!allowSettingNullable).ifNull((Object)iFormatOutputField.getDefaultValue()).type(iFormatDataType.getSparkSqlType()).precision(iFormatOutputField.getScale()).length(iFormatOutputField.getPrecision()).dateFormat(pdiField.getDateFormat()).columnOrdinal(stagingPdiField.getColumnOrdinal()).objectConverter(iFormatDataType.getSparkOutputConverter()).build();
            this.formatFields.add(new FormatField(pdiField, stagingPdiField, sparkField));
        }
        return this.formatFields;
    }

    protected List<FormatField> generateInputFormatFields(IFormatInputField[] formatInputFields, StructType schema) {
        return this.generateInputFormatFields(Arrays.asList(formatInputFields), schema);
    }

    protected List<FormatField> generateInputFormatFields(List<? extends IFormatInputField> formatInputFields, StructType schema) {
        this.formatFields = new ArrayList<FormatField>();
        StructField[] structFields = schema.fields();
        int inputColumnOrdinal = 0;
        for (IFormatInputField iFormatInputField : formatInputFields) {
            int orcFileOrdinal = IntStream.range(0, structFields.length).filter(x -> structFields[x].name().equals(field.getFormatFieldName())).findFirst().orElseThrow(() -> new RuntimeException(FormatStructTypeMapper.msg(ERROR_NO_MATCH_INPUT, field.getFormatFieldName())));
            IFormatDataType iFormatDataType = this.iFormatDataTypeProvider.getDataType(iFormatInputField.getFormatType());
            Field sparkField = Field.FieldBuilder.builder().path(iFormatInputField.getFormatFieldName()).name(iFormatInputField.getPentahoFieldName()).type(iFormatInputField.getFormatType()).columnOrdinal(orcFileOrdinal).build();
            Field stagingPdiField = Field.FieldBuilder.builder().path(iFormatInputField.getFormatFieldName()).name(iFormatInputField.getPentahoFieldName()).type(iFormatDataType.getPdiType()).columnOrdinal(inputColumnOrdinal).build();
            SimpleDateFormat dateFormat = new SimpleDateFormat(ValueMetaBase.DEFAULT_DATE_FORMAT_MASK);
            String stringFormat = iFormatInputField.getStringFormat();
            if (stringFormat != null && stringFormat.trim().length() > 0) {
                dateFormat = new SimpleDateFormat(stringFormat);
            }
            Field pdiField = Field.FieldBuilder.builder().path(iFormatInputField.getFormatFieldName()).name(iFormatInputField.getPentahoFieldName()).type(iFormatInputField.getPentahoType()).columnOrdinal(inputColumnOrdinal).dateFormat(dateFormat).build();
            ++inputColumnOrdinal;
            this.formatFields.add(new FormatField(pdiField, stagingPdiField, sparkField));
        }
        return this.formatFields;
    }

    public StructType schemaForRead() {
        throw new UnsupportedOperationException();
    }

    protected Object sparkToPdiConversion(Object value, DataType sparkSqlType, FormatField formatField) {
        Object toRet = this.sparkToStaging(value, sparkSqlType, formatField);
        toRet = this.stagingToPdi(toRet, formatField);
        return toRet;
    }

    protected Object sparkToStaging(Object value, DataType sparkSqlType, FormatField formatField) {
        Object toRet = value;
        if (value == null) {
            return null;
        }
        if (sparkSqlType == DataTypes.FloatType) {
            toRet = Double.valueOf(toRet.toString());
        } else if (sparkSqlType == DataTypes.IntegerType) {
            toRet = new Long(((Integer)toRet).intValue());
        }
        if (this.isDate(formatField.getStagingField().getType())) {
            toRet = this.handleDate(sparkSqlType, value, formatField.getStagingField());
        } else if (formatField.getStagingField().getType() == 10) {
            toRet = this.handleAddress(sparkSqlType, value, formatField.getStagingField());
        }
        return toRet;
    }

    private Object stagingToPdi(Object value, FormatField formatField) {
        Object toRet = value;
        if (formatField.getStagingField().getType() != formatField.getPdiField().getType()) {
            try {
                this.valueMetaConverter.setDatePattern(formatField.getPdiField().getDateFormat());
                toRet = this.valueMetaConverter.convertFromSourceToTargetDataType(formatField.getStagingField().getType(), formatField.getPdiField().getType(), toRet);
            }
            catch (ValueMetaConversionException e) {
                LOG.error("Could not convert from Staging Pdi type to final Pdi type", (Throwable)e);
            }
        }
        return toRet;
    }

    private Object typeToSparkCompatible(Object object, FormatField formatField) {
        if (object == null && formatField.getStagingField().isNullable()) {
            return null;
        }
        Object result = this.getStagedValue(object, formatField);
        return Optional.ofNullable(formatField.getSparkField().getObjectConverter()).orElse((IObjectConverter & Serializable)o -> o).apply(result);
    }

    private Object getStagedValue(Object object, FormatField formatField) {
        Object result = object;
        if (result == null) {
            result = this.nullValToDefault(formatField.getPdiField());
        }
        if (formatField.getPdiField().getType() != formatField.getStagingField().getType() || formatField.getStagingField().getType() == 1 && formatField.getStagingField().getPrecision() > 0) {
            try {
                this.valueMetaConverter.setPrecision(formatField.getStagingField().getPrecision());
                this.valueMetaConverter.setDatePattern(formatField.getStagingField().getDateFormat());
                result = this.valueMetaConverter.convertFromSourceToTargetDataType(formatField.getPdiField().getType(), formatField.getStagingField().getType(), result);
            }
            catch (ValueMetaConversionException e) {
                LOG.error("Could not convert to Staging Pdi type.", (Throwable)e);
            }
        }
        return result;
    }

    private Object nullValToDefault(Field field) {
        try {
            ValueMetaInterface valueMetaBase = ValueMetaFactory.createValueMeta((String)field.getName(), (int)field.getType(), (int)field.getLength(), (int)field.getPrecision());
            ValueMetaString stringValueMeta = new ValueMetaString();
            if (this.isDate(field.getType())) {
                valueMetaBase.setConversionMask(field.getDateFormat().toPattern());
                stringValueMeta.setConversionMask(field.getDateFormat().toPattern());
            }
            Object result = valueMetaBase.convertDataFromString(field.getIfNull().toString(), (ValueMetaInterface)stringValueMeta, null, null, 3);
            return result;
        }
        catch (KettlePluginException | KettleValueException e) {
            throw new SparkEngineException(e);
        }
    }

    private void preconditions(Object[] vals) {
        Preconditions.checkNotNull(this.formatFields);
        Preconditions.checkNotNull((Object)vals);
    }

    private Date handleDate(DataType sparkSqlType, Object value, Field field) {
        if (sparkSqlType == DataTypes.TimestampType) {
            return (Timestamp)value;
        }
        if (sparkSqlType == DataTypes.StringType) {
            return this.parseDate((String)value, field);
        }
        throw new RuntimeException(FormatStructTypeMapper.msg("ERROR.Unexpected_Type", sparkSqlType, ValueMetaBase.getTypeDesc((int)field.getType()), field.getName()));
    }

    private InetAddress handleAddress(DataType sparkSqlType, Object value, Field field) {
        try {
            if (sparkSqlType == DataTypes.BinaryType) {
                return value == null ? null : InetAddress.getByAddress((byte[])value);
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e.getMessage());
        }
        throw new RuntimeException(FormatStructTypeMapper.msg("ERROR.Unexpected_Type", sparkSqlType, ValueMetaBase.getTypeDesc((int)field.getType()), field.getName()));
    }

    public boolean isDate(int kettleType) {
        return kettleType == 3 || kettleType == 9;
    }

    private Date parseDate(String value, Field field) {
        try {
            return field.getDateFormat().parse(value);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private StructType getStructType() {
        List structFields = this.formatFields.stream().map(formatField -> DataTypes.createStructField((String)formatField.getSparkField().getName(), (DataType)FormatStructTypeMapper.getSparkType(formatField), (boolean)formatField.getSparkField().isNullable())).collect(Collectors.toList());
        return DataTypes.createStructType(structFields);
    }

    private static DataType getSparkType(FormatField formatField) {
        Preconditions.checkElementIndex((int)formatField.getSparkField().getType(), (int)SparkDataType.values.length, (String)FormatStructTypeMapper.msg("ERROR.Spark_Datatype_Not_Found", formatField.getSparkField().getName(), formatField.getSparkField().getType()));
        DataType sparkDataType = SparkDataType.values[formatField.getSparkField().getType()].getDataType();
        if (sparkDataType.sameType(DEFAULT_DECIMAL_TYPE)) {
            int length = formatField.getSparkField().getLength();
            int precision = formatField.getSparkField().getPrecision();
            if (length > 0) {
                precision = precision > length ? length : precision;
                return DataTypes.createDecimalType((int)length, (int)(precision < 0 ? 0 : precision));
            }
        }
        return sparkDataType;
    }

    public static List<Field> from(RowMetaInterface rowMeta) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (int i = 0; i < rowMeta.size(); ++i) {
            ValueMetaInterface valueMeta = rowMeta.getValueMeta(i);
            int type = valueMeta.getType();
            Field.FieldBuilder builder = Field.builder().name(rowMeta.getFieldNames()[i]).type(type).precision(valueMeta.getPrecision()).length(valueMeta.getLength()).columnOrdinal(i);
            if (type == 3 || type == 9) {
                Preconditions.checkArgument((valueMeta.getFormatMask() != null ? 1 : 0) != 0);
                builder.dateFormat(valueMeta.getDateFormat());
            }
            fields.add(builder.build());
        }
        return fields;
    }

    protected static String msg(String key, Object ... args) {
        return BaseMessages.getString(TypeMapper.class, (String)key, (Object[])args);
    }
}

