/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.resolvers;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.spark.api.java.JavaSparkContext;
import org.pentaho.di.core.exception.KettlePluginClassMapException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogChannelInterfaceFactory;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.api.reporting.LogLevel;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.api.SparkOperationResolver;
import org.pentaho.di.engine.spark.impl.ops.GenericSparkOperation;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.StepMeta;

public class PluginRegistryResolver
implements SparkOperationResolver {
    private static final Class<?> PKG = PluginRegistryResolver.class;
    private static final String SLCT_STEP_RUN_AS_SPARK_NATIVE = "PluginRegistryResolver.SelectStepRunAsSparkNative";
    private static final String SLCT_STEP_RUN_IN_PARALLEL = "PluginRegistryResolver.SelectStepRunInParallel";
    private static final String IN_PARALLEL = "PluginRegistryResolver.InParallel";
    private static final String SPLIT_REGEX = "\\|";
    private final Set<String> forceCoalesceSteps;
    private final PluginRegistry pluginRegistry;
    private final LogChannelInterface logChannel;

    public PluginRegistryResolver(String forceCoalesceSteps) {
        this(forceCoalesceSteps, PluginRegistry.getInstance(), arg_0 -> ((LogChannelInterfaceFactory)KettleLogStore.getLogChannelInterfaceFactory()).create(arg_0));
    }

    @VisibleForTesting
    public PluginRegistryResolver(String forceCoalesceSteps, PluginRegistry pluginRegistry, Function<Object, LogChannelInterface> logChannelFunction) {
        this.forceCoalesceSteps = Arrays.stream(forceCoalesceSteps.split(SPLIT_REGEX)).map(String::trim).collect(Collectors.toSet());
        this.pluginRegistry = pluginRegistry;
        this.logChannel = logChannelFunction.apply(this);
    }

    public SparkOperation resolve(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) throws KettlePluginException {
        Object sparkOperation;
        SparkOperationFactory sparkOperationFactory = null;
        this.logChannel.setLogLevel(Util.mapKettleLogLevel((LogLevel)executionContext.getLoggingLogLevel()));
        try {
            sparkOperationFactory = (SparkOperationFactory)this.pluginRegistry.loadClass(StepPluginType.class, stepMeta.getTypeId(), SparkOperationFactory.class);
        }
        catch (KettlePluginClassMapException kettlePluginClassMapException) {
        }
        catch (KettlePluginException e) {
            this.logChannel.logBasic(e.getLocalizedMessage());
            throw e;
        }
        if (sparkOperationFactory != null) {
            sparkOperation = sparkOperationFactory.getOperation(operation, transformation, stepMeta, sparkContext, executionContext);
            this.logChannel.logDebug(BaseMessages.getString(PKG, (String)SLCT_STEP_RUN_AS_SPARK_NATIVE, (String[])new String[]{stepMeta.getStepID(), sparkOperation.getClass().getSimpleName()}));
        } else {
            boolean isParallelSafe = !this.forceCoalesceSteps.stream().anyMatch(s -> s.equalsIgnoreCase(stepMeta.getStepID()));
            sparkOperation = new GenericSparkOperation(sparkContext, operation, stepMeta, isParallelSafe);
            this.logChannel.logDebug(BaseMessages.getString(PKG, (String)SLCT_STEP_RUN_IN_PARALLEL, (String[])new String[]{stepMeta.getStepID(), isParallelSafe ? BaseMessages.getString(PKG, (String)IN_PARALLEL, (String[])new String[0]) : "", sparkOperation.getClass().getSimpleName()}));
        }
        return sparkOperation;
    }
}

