/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.parquet;

import org.apache.hadoop.conf.Configuration;
import org.pentaho.big.data.kettle.plugins.formats.parquet.output.ParquetOutputMetaBase;

public class ParquetSetup {
    public static final String ENABLE_DICTIONARY = "parquet.enable.dictionary";
    public static final String BLOCK_SIZE = "parquet.block.size";
    public static final String PAGE_SIZE = "parquet.page.size";
    public static final String DICTIONARY_PAGE_SIZE = "parquet.dictionary.page.size";
    public static final String WRITER_VERSION = "parquet.writer.version";

    public static void enableDictionary(Configuration configuration, boolean useDictionary) {
        configuration.setBoolean(ENABLE_DICTIONARY, useDictionary);
    }

    public static void setBlockSize(Configuration configuration, int uiBlockSize) {
        if (uiBlockSize > 0) {
            configuration.setInt(BLOCK_SIZE, uiBlockSize * 1024 * 1024);
        }
    }

    public static void setPageSize(Configuration configuration, int uiPageSize) {
        if (uiPageSize > 0) {
            configuration.setInt(PAGE_SIZE, uiPageSize * 1024);
        }
    }

    public static void getDictionaryPageSize(Configuration configuration, int uiDictSize) {
        if (uiDictSize > 0) {
            configuration.setInt(DICTIONARY_PAGE_SIZE, uiDictSize * 1024);
        }
    }

    public static void setParquetVersion(Configuration configuration, ParquetOutputMetaBase.ParquetVersion uiParquetVersionName) {
        WriterVersion writerVersion = null;
        if (uiParquetVersionName == null) {
            uiParquetVersionName = ParquetOutputMetaBase.ParquetVersion.PARQUET_2;
        }
        switch (uiParquetVersionName) {
            case PARQUET_1: {
                writerVersion = WriterVersion.PARQUET_1_0;
                break;
            }
            case PARQUET_2: {
                writerVersion = WriterVersion.PARQUET_2_0;
                break;
            }
            default: {
                writerVersion = WriterVersion.PARQUET_2_0;
            }
        }
        configuration.set(WRITER_VERSION, writerVersion.toString());
    }

    public static enum WriterVersion {
        PARQUET_1_0("v1"),
        PARQUET_2_0("v2");

        private String code;

        private WriterVersion(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

