/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops.uniquerows.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.spark.api.Field;
import org.pentaho.di.engine.spark.api.PentahoSparkField;
import org.pentaho.di.engine.spark.impl.ops.uniquerows.model.UniqueRowsAelMeta;
import org.pentaho.di.engine.spark.impl.ops.uniquerows.model.UniqueRowsCompareField;
import org.pentaho.di.engine.spark.util.StructTypeMapper;
import org.pentaho.di.trans.steps.uniquerowsbyhashset.UniqueRowsByHashSetMeta;

public class UniqueRowsByHashetMetaDataMapper {
    public static UniqueRowsAelMeta fromPdiToAelUniqueRowsByHashSetRowsMeta(UniqueRowsByHashSetMeta uniqueRowsByHashSetMeta, RowMetaInterface inRowMeta, RowMetaInterface outRowMeta) {
        UniqueRowsAelMeta uniqueRowsAelMeta = new UniqueRowsAelMeta();
        uniqueRowsAelMeta.setStepName(uniqueRowsByHashSetMeta.getParentStepMeta().getName());
        uniqueRowsAelMeta.setAddCounterToOputut(false);
        uniqueRowsAelMeta.setCounterField(null);
        uniqueRowsAelMeta.setDuplicateRowErrorDescription(uniqueRowsByHashSetMeta.getErrorDescription());
        uniqueRowsAelMeta.setRedirectDuplicateRow(uniqueRowsByHashSetMeta.isRejectDuplicateRow());
        uniqueRowsAelMeta.setCompareFields(UniqueRowsByHashetMetaDataMapper.mapCompareFields(uniqueRowsAelMeta, uniqueRowsByHashSetMeta, inRowMeta, outRowMeta));
        return uniqueRowsAelMeta;
    }

    protected static List<UniqueRowsCompareField> mapCompareFields(UniqueRowsAelMeta uniqueRowsAelMeta, UniqueRowsByHashSetMeta uniqueRowsMeta, RowMetaInterface inRowMeta, RowMetaInterface outRowMeta) {
        ArrayList<UniqueRowsCompareField> uniqueRowsCompareFields = new ArrayList();
        StructType inSchema = new StructTypeMapper(inRowMeta).schema();
        uniqueRowsCompareFields = IntStream.range(0, uniqueRowsMeta.getCompareFields().length).mapToObj(i -> {
            UniqueRowsCompareField uniqueRowsCompareField = new UniqueRowsCompareField();
            String compareFieldName = uniqueRowsMeta.getCompareFields()[i];
            uniqueRowsCompareField.setCompareField(UniqueRowsByHashetMetaDataMapper.mapPentahoSparkField(compareFieldName, inSchema, inRowMeta));
            uniqueRowsCompareField.setIgnoreCase(false);
            uniqueRowsAelMeta.setHasIgnoreCaseFields(false);
            return uniqueRowsCompareField;
        }).collect(Collectors.toList());
        return uniqueRowsCompareFields;
    }

    protected static PentahoSparkField mapPentahoSparkField(String fieldName, StructType schema, RowMetaInterface rowMeta) {
        PentahoSparkField pentahoSparkField = new PentahoSparkField();
        DataType dataType = schema.fields()[(Integer)schema.getFieldIndex(fieldName).get()].dataType();
        Column column = functions.col((String)fieldName);
        Field pentahoField = StructTypeMapper.fromField((String)fieldName, (RowMetaInterface)rowMeta);
        pentahoSparkField.setFieldName(fieldName);
        pentahoSparkField.setPentahoField(pentahoField);
        pentahoSparkField.setSparkSqlColumn(column);
        pentahoSparkField.setSparkSqlDataType(dataType);
        return pentahoSparkField;
    }
}

