/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops.groupby.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.spark.api.Field;
import org.pentaho.di.engine.spark.api.PentahoSparkField;
import org.pentaho.di.engine.spark.impl.ops.groupby.model.GroupByAelMeta;
import org.pentaho.di.engine.spark.impl.ops.groupby.model.GroupByAggregateField;
import org.pentaho.di.engine.spark.impl.ops.groupby.model.GroupByAggregationTypeEnum;
import org.pentaho.di.engine.spark.util.StructTypeMapper;
import org.pentaho.di.trans.steps.groupby.GroupByMeta;

public class GroupByMetaDataMapper {
    public static GroupByAelMeta fromPdiToAelGroupByMeta(GroupByMeta groupByMeta, RowMetaInterface inRowMeta, RowMetaInterface outRowMeta) {
        GroupByAelMeta groupByAelMeta = new GroupByAelMeta();
        groupByAelMeta.setStepName(groupByMeta.getParentStepMeta().getName());
        groupByAelMeta.setShouldAddLineNumbersToEachRow(groupByMeta.isAddingLineNrInGroup());
        groupByAelMeta.setLineNumbersFieldName(groupByMeta.getLineNrInGroupField());
        groupByAelMeta.setShouldAlwaysReturnResultRow(groupByMeta.isAlwaysGivingBackOneRow());
        groupByAelMeta.setShouldIncludeAllRows(groupByMeta.passAllRows());
        groupByAelMeta.setGroupingFields(GroupByMetaDataMapper.mapGroupingFields(groupByMeta, inRowMeta));
        groupByAelMeta.setAggregateFields(GroupByMetaDataMapper.mapAggregateFields(groupByMeta, inRowMeta, outRowMeta));
        return groupByAelMeta;
    }

    protected static List<GroupByAggregateField> mapAggregateFields(GroupByMeta groupByMeta, RowMetaInterface inRowMeta, RowMetaInterface outRowMeta) {
        ArrayList<GroupByAggregateField> aggregateFields = new ArrayList();
        StructType inSchema = new StructTypeMapper(inRowMeta).schema();
        StructType outSchema = new StructTypeMapper(outRowMeta).schema();
        aggregateFields = IntStream.range(0, groupByMeta.getAggregateField().length).mapToObj(i -> {
            GroupByAggregateField aggregateField = new GroupByAggregateField();
            String aggregateFieldName = groupByMeta.getAggregateField()[i];
            String subjectFieldName = groupByMeta.getSubjectField()[i];
            String aggregateFieldConfigValue = groupByMeta.getValueField()[i];
            int aggregateType = groupByMeta.getAggregateType()[i];
            aggregateField.setAggregateField(GroupByMetaDataMapper.mapPentahoSparkField(aggregateFieldName, outSchema, outRowMeta));
            aggregateField.setSubjectField(GroupByMetaDataMapper.mapPentahoSparkField(subjectFieldName, inSchema, inRowMeta));
            aggregateField.setAggregateFieldConfgValue(aggregateFieldConfigValue);
            aggregateField.setAggregateType(GroupByAggregationTypeEnum.getGroupByAggregateTypeByGroupById(aggregateType));
            aggregateField = GroupByMetaDataMapper.makeTypeSpecificAggregateFieldModifications(aggregateField);
            return aggregateField;
        }).collect(Collectors.toList());
        if (groupByMeta.passAllRows() && groupByMeta.isAddingLineNrInGroup()) {
            GroupByAggregateField aggregateField = new GroupByAggregateField();
            String rowNumberAggregateFieldName = groupByMeta.getLineNrInGroupField();
            aggregateField.setAggregateField(GroupByMetaDataMapper.mapPentahoSparkField(rowNumberAggregateFieldName, outSchema, outRowMeta));
            aggregateField.setSubjectField(null);
            aggregateField.setAggregateFieldConfgValue(null);
            aggregateField.setAggregateType(GroupByAggregationTypeEnum.TYPE_GROUP_ROW_NUMBER);
            aggregateFields.add(aggregateField);
        }
        return aggregateFields;
    }

    protected static GroupByAggregateField makeTypeSpecificAggregateFieldModifications(GroupByAggregateField aggregateField) {
        if (aggregateField.getAggregateType().equals((Object)GroupByAggregationTypeEnum.TYPE_GROUP_PERCENTILE)) {
            double percentValue;
            if (aggregateField.getAggregateFieldConfgValue() == null) {
                return aggregateField;
            }
            try {
                percentValue = Double.valueOf(aggregateField.getAggregateFieldConfgValue());
            }
            catch (NumberFormatException e) {
                return aggregateField;
            }
            if (percentValue > 1.0) {
                aggregateField.setAggregateFieldConfgValue(Double.toString(percentValue / 100.0));
            }
        }
        if (aggregateField.getAggregateType().equals((Object)GroupByAggregationTypeEnum.TYPE_GROUP_CONCAT_STRING)) {
            if (aggregateField.getAggregateFieldConfgValue() == null) {
                return aggregateField;
            }
            if (aggregateField.getAggregateFieldConfgValue().startsWith("\"") && aggregateField.getAggregateFieldConfgValue().endsWith("\"") || aggregateField.getAggregateFieldConfgValue().startsWith("'") && aggregateField.getAggregateFieldConfgValue().endsWith("'")) {
                return aggregateField;
            }
            aggregateField.setAggregateFieldConfgValue("'" + aggregateField.getAggregateFieldConfgValue() + "'");
        }
        return aggregateField;
    }

    protected static List<PentahoSparkField> mapGroupingFields(GroupByMeta groupByMeta, RowMetaInterface inRowMeta) {
        ArrayList<PentahoSparkField> groupingFields = new ArrayList();
        String[] groupFieldNames = groupByMeta.getGroupField();
        StructType schema = new StructTypeMapper(inRowMeta).schema();
        groupingFields = Arrays.stream(groupFieldNames).map(fieldName -> {
            PentahoSparkField pentahoSparkField = GroupByMetaDataMapper.mapPentahoSparkField(fieldName, schema, inRowMeta);
            return pentahoSparkField;
        }).collect(Collectors.toList());
        return groupingFields;
    }

    protected static PentahoSparkField mapPentahoSparkField(String fieldName, StructType schema, RowMetaInterface rowMeta) {
        PentahoSparkField pentahoSparkField = new PentahoSparkField();
        DataType dataType = schema.fields()[(Integer)schema.getFieldIndex(fieldName).get()].dataType();
        Column column = functions.col((String)fieldName);
        Field pentahoField = StructTypeMapper.fromField((String)fieldName, (RowMetaInterface)rowMeta);
        pentahoSparkField.setFieldName(fieldName);
        pentahoSparkField.setPentahoField(pentahoField);
        pentahoSparkField.setSparkSqlColumn(column);
        pentahoSparkField.setSparkSqlDataType(dataType);
        return pentahoSparkField;
    }
}

