/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.BaseSparkOperation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.SparkEngineContext;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.engine.spark.util.MetaHelper;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.rowstoresult.RowsToResultMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowsToResultSparkOperation
extends BaseSparkOperation {
    private static final long serialVersionUID = 2219016759308906766L;
    private final Logger LOG = LoggerFactory.getLogger(RowsToResultSparkOperation.class);
    private final TransMeta transMeta;
    private final JavaSparkContext sparkContext;
    private final RowsToResultMeta rowsToResultMeta;
    private JavaRDD<Row> output;
    private SparkEngineContext sparkEngineContext;

    public RowsToResultSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        this(operation, stepMeta, sparkContext);
        this.sparkEngineContext = (SparkEngineContext)executionContext;
    }

    RowsToResultSparkOperation(Operation operation, StepMeta stepMeta, JavaSparkContext sparkContext) {
        super(operation);
        this.transMeta = stepMeta.getParentTransMeta();
        this.rowsToResultMeta = (RowsToResultMeta)MetaHelper.getTypedStepMeta((StepMeta)stepMeta, RowsToResultMeta.class);
        this.sparkContext = sparkContext;
    }

    public void apply(SparkOperation.Subscriber subscriber) {
        this.LOG.trace("apply(subscriber: {})", (Object)subscriber);
        this.output = (JavaRDD)subscriber.getInput().get();
        this.sparkEngineContext.setFinalRdd(this.output);
        subscriber.setOutput(this.output);
    }

    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }

    public static SparkOperationFactory factory() {
        return new SparkOperationFactory(RowsToResultSparkOperation::new, new Supplier[0]);
    }
}

