/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.BaseSparkOperation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.SparkEngineContext;
import org.pentaho.di.engine.spark.impl.functions.KettleRowMappingFunction;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.engine.spark.util.MetaHelper;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.recordsfromstream.RecordsFromStreamMeta;

public class RecordsFromStreamSparkOperation
extends BaseSparkOperation {
    private final TransMeta transMeta;
    private final JavaSparkContext sparkContext;
    private transient SparkEngineContext executionContext;
    private final transient RecordsFromStreamMeta consumerMeta;

    public RecordsFromStreamSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        this(operation, stepMeta, sparkContext);
        this.executionContext = (SparkEngineContext)executionContext;
    }

    RecordsFromStreamSparkOperation(Operation operation, StepMeta stepMeta, JavaSparkContext sparkContext) {
        super(operation);
        this.transMeta = stepMeta.getParentTransMeta();
        this.consumerMeta = (RecordsFromStreamMeta)MetaHelper.getTypedStepMeta((StepMeta)stepMeta, RecordsFromStreamMeta.class);
        this.sparkContext = sparkContext;
    }

    public static SparkOperationFactory factory() {
        return new SparkOperationFactory(RecordsFromStreamSparkOperation::new, new Supplier[]{KettleRowMappingFunction::new});
    }

    public void apply(SparkOperation.Subscriber subscriber) {
        this.executionContext.getInitialRdd().ifPresent(inputRdd -> {
            JavaRDD outputRdd = inputRdd.mapPartitions(new KettleRowMappingFunction(this.consumerMeta.getParentStepMeta(), subscriber.getMetricsAccumulator()).asRegisteredFunction(this.consumerMeta.getParentStepMeta().getStepID()).toFlatMap());
            subscriber.setOutput(outputRdd);
        });
    }

    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }
}

