/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.pentaho.big.data.kettle.plugins.formats.parquet.input.ParquetInputMetaBase;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.BaseSparkOperation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.functions.FileInputContentFunction;
import org.pentaho.di.engine.spark.impl.functions.SparkToKettleRowFunction;
import org.pentaho.di.engine.spark.impl.ops.FileInputResolver;
import org.pentaho.di.engine.spark.impl.typehandling.ParquetSpec;
import org.pentaho.di.engine.spark.impl.typehandling.ParquetTypeMapper;
import org.pentaho.di.engine.spark.spi.RegisteredFunction;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.engine.spark.util.MetaHelper;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.file.BaseFileInputMeta;
import org.pentaho.hadoop.shim.api.format.IParquetInputField;
import scala.collection.Iterator;
import scala.collection.JavaConverters;

public class ParquetInputSparkOperation
extends BaseSparkOperation {
    private final TransMeta transMeta;
    private final JavaSparkContext sparkContext;
    private final ParquetInputMetaBase fileMeta;
    @VisibleForTesting
    protected MetricsAccumulator metricsAccumulator;

    public ParquetInputSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        this(operation, stepMeta, sparkContext);
    }

    ParquetInputSparkOperation(Operation operation, StepMeta stepMeta, JavaSparkContext sparkContext) {
        super(operation);
        this.transMeta = stepMeta.getParentTransMeta();
        this.fileMeta = (ParquetInputMetaBase)MetaHelper.getTypedStepMeta((StepMeta)stepMeta, ParquetInputMetaBase.class);
        this.sparkContext = sparkContext;
    }

    public static SparkOperationFactory factory() {
        return new SparkOperationFactory(ParquetInputSparkOperation::new, new Supplier[]{FileInputContentFunction::new, SparkToKettleRowFunction::new});
    }

    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }

    public void apply(SparkOperation.Subscriber subscriber) {
        this.metricsAccumulator = subscriber.getMetricsAccumulator();
        Supplier<JavaRDD> readAction = this::loadDefaultAction;
        subscriber.setOutput(CompletableFuture.supplyAsync(readAction, arg_0 -> ((SparkOperation.Subscriber)subscriber).registerDriverAction(arg_0)));
    }

    @VisibleForTesting
    protected JavaRDD<Row> loadDefaultAction() {
        SparkSession sparkSession = Util.getSparkSession();
        List<String> files = FileInputResolver.getFiles((VariableSpace)this.transMeta, (BaseFileInputMeta)this.fileMeta, this.sparkContext);
        Dataset dataset = sparkSession.read().parquet(((Iterator)JavaConverters.asScalaIteratorConverter(files.iterator()).asScala()).toSeq());
        ParquetTypeMapper typeMapper = new ParquetTypeMapper((IParquetInputField[])this.fileMeta.getInputFields(), dataset.schema(), ParquetSpec.DataType.class);
        this.metricsAccumulator.setCountRowIn(false);
        SparkToKettleRowFunction rowFunction = new SparkToKettleRowFunction(this.transMeta.findStep(this.getId()), this.metricsAccumulator, typeMapper);
        RegisteredFunction registeredFunction = rowFunction.asRegisteredFunction(this.fileMeta.getParentStepMeta().getStepID());
        return dataset.toJavaRDD().mapPartitions(registeredFunction.toFlatMap());
    }
}

