/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.pentaho.big.data.kettle.plugins.formats.orc.input.OrcInputMetaBase;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.BaseSparkOperation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.functions.FileInputContentFunction;
import org.pentaho.di.engine.spark.impl.functions.SparkToKettleRowFunction;
import org.pentaho.di.engine.spark.impl.typehandling.OrcSpec;
import org.pentaho.di.engine.spark.impl.typehandling.OrcTypeMapper;
import org.pentaho.di.engine.spark.spi.RegisteredFunction;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.engine.spark.util.MetaHelper;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.hadoop.shim.api.format.IOrcInputField;

public class OrcInputSparkOperation
extends BaseSparkOperation {
    private static final long serialVersionUID = -7371722688423186458L;
    private final TransMeta transMeta;
    private final OrcInputMetaBase fileMeta;
    private MetricsAccumulator metricsAccumulator;

    public OrcInputSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        this(operation, stepMeta, sparkContext);
    }

    protected OrcInputSparkOperation(Operation operation, StepMeta stepMeta, JavaSparkContext sparkContext) {
        super(operation);
        this.transMeta = stepMeta.getParentTransMeta();
        this.fileMeta = (OrcInputMetaBase)MetaHelper.getTypedStepMeta((StepMeta)stepMeta, OrcInputMetaBase.class);
    }

    public static SparkOperationFactory factory() {
        return new SparkOperationFactory(OrcInputSparkOperation::new, new Supplier[]{FileInputContentFunction::new, SparkToKettleRowFunction::new});
    }

    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }

    public void apply(SparkOperation.Subscriber subscriber) {
        this.metricsAccumulator = subscriber.getMetricsAccumulator();
        Supplier<JavaRDD> readAction = this::loadDefaultAction;
        subscriber.setOutput(CompletableFuture.supplyAsync(readAction, arg_0 -> ((SparkOperation.Subscriber)subscriber).registerDriverAction(arg_0)));
    }

    private JavaRDD<Row> loadDefaultAction() {
        SparkSession.builder().enableHiveSupport();
        SparkSession sparkSession = Util.getSparkSession();
        String filename = this.transMeta.environmentSubstitute(this.fileMeta.getFilename());
        Dataset rowDataset = sparkSession.read().orc(filename);
        this.metricsAccumulator.setCountRowIn(false);
        SparkToKettleRowFunction rowFunction = new SparkToKettleRowFunction(this.transMeta.findStep(this.getId()), this.metricsAccumulator, new OrcTypeMapper((IOrcInputField[])this.fileMeta.getInputFields(), rowDataset.schema(), OrcSpec.DataType.class));
        RegisteredFunction registeredFunction = rowFunction.asRegisteredFunction(this.fileMeta.getParentStepMeta().getStepID());
        return rowDataset.toJavaRDD().mapPartitions(registeredFunction.toFlatMap());
    }
}

