/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import java.util.function.Supplier;
import org.apache.commons.lang.BooleanUtils;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.streaming.api.java.JavaInputDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.mqtt.MQTTUtils;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.util.serialization.BaseSerializingMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.BaseSparkStreamingOperation;
import org.pentaho.di.engine.spark.impl.events.OperationErrorEvent;
import org.pentaho.di.engine.spark.impl.functions.TupleToKettleRowFunction;
import org.pentaho.di.engine.spark.impl.functions.WaitForeverFunction;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.engine.spark.util.MetaHelper;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.mqtt.MQTTClientBuilder;
import org.pentaho.di.trans.step.mqtt.MQTTConsumerMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTSparkOperation
extends BaseSparkStreamingOperation {
    private final Logger LOG = LoggerFactory.getLogger(BaseSparkStreamingOperation.class);
    protected final transient MQTTConsumerMeta mqttConsumerMeta;
    private final StepMeta stepMeta;

    public MQTTSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        super(operation, transformation, stepMeta, sparkContext, executionContext);
        this.stepMeta = stepMeta;
        BaseSerializingMeta serializingMeta = (BaseSerializingMeta)MetaHelper.getTypedStepMeta((StepMeta)stepMeta, MQTTConsumerMeta.class);
        this.mqttConsumerMeta = (MQTTConsumerMeta)serializingMeta.withVariables((VariableSpace)this.transMeta);
    }

    public static SparkOperationFactory factory() {
        return new SparkOperationFactory(MQTTSparkOperation::new, new Supplier[]{TupleToKettleRowFunction::new, WaitForeverFunction::new});
    }

    protected JavaInputDStream buildStream() {
        String username = StringUtil.isEmpty((String)this.mqttConsumerMeta.getUsername()) ? null : this.mqttConsumerMeta.getUsername();
        String password = StringUtil.isEmpty((String)this.mqttConsumerMeta.getPassword()) ? null : this.mqttConsumerMeta.getPassword();
        boolean cleanSession = StringUtil.isEmpty((String)this.mqttConsumerMeta.getCleanSession()) ? true : BooleanUtils.toBoolean((String)this.mqttConsumerMeta.getCleanSession());
        int qosLevel = StringUtil.isEmpty((String)this.mqttConsumerMeta.getQos()) ? 0 : Integer.parseInt(this.mqttConsumerMeta.getQos());
        int connectionTimeout = StringUtil.isEmpty((String)this.mqttConsumerMeta.getConnectionTimeout()) ? 30 : Integer.parseInt(this.mqttConsumerMeta.getConnectionTimeout());
        int keepAliveInterval = StringUtil.isEmpty((String)this.mqttConsumerMeta.getKeepAliveInterval()) ? 60 : Integer.parseInt(this.mqttConsumerMeta.getKeepAliveInterval());
        int mqttVersion = StringUtil.isEmpty((String)this.mqttConsumerMeta.getMqttVersion()) ? 0 : Integer.parseInt(this.mqttConsumerMeta.getMqttVersion());
        this.operationLogger.debug("Clean Session value: " + cleanSession);
        this.operationLogger.debug("QOS Level value: " + qosLevel);
        this.operationLogger.debug("Connection Timeout value: " + connectionTimeout);
        this.operationLogger.debug("Keep Alive Interval value: " + keepAliveInterval);
        this.operationLogger.debug("MQTT Version value: " + mqttVersion);
        try {
            this.verifyMqttConnection();
            return MQTTUtils.createPairedStream((JavaStreamingContext)this.javaStreamingContext, (String)("tcp://" + this.mqttConsumerMeta.getMqttServer()), (String[])this.mqttConsumerMeta.getTopics().toArray(new String[0]), (String)MqttAsyncClient.generateClientId(), (String)username, (String)password, (boolean)cleanSession, (int)qosLevel, (int)connectionTimeout, (int)keepAliveInterval, (int)mqttVersion);
        }
        catch (Exception e) {
            OperationErrorEvent.sendEvent((JavaSparkContext)this.sparkContext, (String)this.getUUID(), (Throwable)e);
            return null;
        }
    }

    void verifyMqttConnection() throws MqttException {
        MqttClient mqttClient = MQTTClientBuilder.builder().withBroker(this.mqttConsumerMeta.getMqttServer()).withStep((StepInterface)Util.getTypedStep((StepMeta)this.stepMeta, BaseStep.class)).withQos(this.mqttConsumerMeta.getQos()).withUsername(this.mqttConsumerMeta.getUsername()).withPassword(this.mqttConsumerMeta.getPassword()).withKeepAliveInterval(this.mqttConsumerMeta.getKeepAliveInterval()).withConnectionTimeout(this.mqttConsumerMeta.getConnectionTimeout()).withCleanSession(this.mqttConsumerMeta.getCleanSession()).withMqttVersion(this.mqttConsumerMeta.getMqttVersion()).withAutomaticReconnect(Boolean.FALSE.toString()).buildAndConnect();
        mqttClient.disconnect();
    }

    protected JavaRDD<Row> mapPartitions(JavaRDD javaRDD) {
        return javaRDD.mapPartitions(new TupleToKettleRowFunction(this.consumerMeta.getParentStepMeta(), this.subscriber.getMetricsAccumulator()).asRegisteredFunction(this.consumerMeta.getParentStepMeta().getStepID()).toFlatMap());
    }
}

