/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.hadoop.fs.Path;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.BaseSparkOperation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.SparkEngineContext;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.events.FinalOperationEvent;
import org.pentaho.di.engine.spark.impl.events.OperationErrorEvent;
import org.pentaho.di.engine.spark.impl.functions.FileOutputContentFunction;
import org.pentaho.di.engine.spark.impl.logger.FunctionLogger;
import org.pentaho.di.engine.spark.spi.KettleRow;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.engine.spark.util.MetaHelper;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutput;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputMeta;

public class FileOutputSparkOperation
extends BaseSparkOperation {
    private static final Class<?> PKG = FileOutputSparkOperation.class;
    private static final String ERROR_INITIALIZING = "FileOutputSparkOperation.ErrorInitializing";
    private static final String NONE = "NONE";
    private static final String FILE = "file";
    private static final String HDFS = "hdfs";
    private static final String DATE_PATTERN = "yyyMMdd";
    private static final String TIME_PATTERN = "HHmmss";
    private final TransMeta transMeta;
    private final TextFileOutputMeta fileMeta;
    private final JavaSparkContext sparkContext;
    private final AtomicReference<Object[]> nextRow = new AtomicReference();
    private final Consumer<JavaRDD<Row>> DEFAULT_FILE_ACTION = this::saveDefaultAction;
    private Map<String, Consumer<JavaRDD<Row>>> fileActionMap = ImmutableMap.of((Object)"file", this::saveAsLocalFile, (Object)"hdfs", this.DEFAULT_FILE_ACTION);
    private final boolean isFinalOperation;
    private MetricsAccumulator metricsAccumulator = MetricsAccumulator.empty();
    private FunctionLogger transLogger = FunctionLogger.empty();
    private FunctionLogger operationLogger = FunctionLogger.empty();
    private final LocalDateTime now;
    private SparkEngineContext sparkEngineContext;

    public FileOutputSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        super(operation);
        this.transMeta = stepMeta.getParentTransMeta();
        this.fileMeta = (TextFileOutputMeta)MetaHelper.getTypedStepMeta((StepMeta)stepMeta, TextFileOutputMeta.class);
        this.sparkContext = sparkContext;
        this.isFinalOperation = operation.getHopsOut() == null || operation.getHopsOut().isEmpty();
        this.now = LocalDateTime.now();
        this.sparkEngineContext = (SparkEngineContext)executionContext;
    }

    @VisibleForTesting
    FileOutputSparkOperation(Operation operation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext, Map<String, Consumer<JavaRDD<Row>>> fileActionMap) {
        this(operation, null, stepMeta, sparkContext, executionContext);
        this.fileActionMap = fileActionMap;
    }

    public static SparkOperationFactory factory() {
        return new SparkOperationFactory(FileOutputSparkOperation::new, new Supplier[]{FileOutputContentFunction::new});
    }

    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }

    public void apply(SparkOperation.Subscriber subscriber) {
        Set expectedOutputs = subscriber.getExpectedOutputs();
        this.metricsAccumulator = subscriber.getMetricsAccumulator();
        this.transLogger = Util.getTransformationLogger((SparkOperation.Subscriber)subscriber);
        this.operationLogger = Util.getOperationLogger((SparkOperation.Subscriber)subscriber);
        JavaRDD rdd = subscriber.getInput().map(input -> expectedOutputs.isEmpty() ? input : input.cache()).orElseGet(() -> ((JavaSparkContext)this.sparkContext).emptyRDD());
        expectedOutputs.forEach(output -> subscriber.addOutput(output, rdd));
        subscriber.registerDriverAction(() -> this.fileActionMap.getOrDefault(this.getUri().getScheme(), this.DEFAULT_FILE_ACTION).accept((JavaRDD<Row>)rdd));
    }

    @VisibleForTesting
    protected void saveDefaultAction(JavaRDD<Row> rdd) {
        try {
            this.fileMeta.setFileFormat(NONE);
            FileOutputContentFunction partMap = new FileOutputContentFunction(this.transMeta.findStep(this.getId()), this.metricsAccumulator, this.transLogger, this.operationLogger);
            JavaRDD outputRdd = rdd.mapPartitions(partMap.asRegisteredFunction(this.fileMeta.getParentStepMeta().getStepID()).toFlatMap());
            if (this.fileMeta.isAddToResultFiles()) {
                this.sparkEngineContext.addResultFile(this.getUri().getPath());
            }
            outputRdd.saveAsTextFile(this.getUri().getPath());
            if (this.isFinalOperation) {
                FinalOperationEvent.sendEvent((JavaSparkContext)this.sparkContext, (String)this.getUUID());
            }
        }
        catch (Exception e) {
            OperationErrorEvent.sendEvent((JavaSparkContext)this.sparkContext, (String)this.getUUID(), (Throwable)e);
        }
    }

    private void saveAsLocalFile(JavaRDD<Row> rdd) {
        try {
            Preconditions.checkArgument((boolean)FILE.equals(this.getUri().getScheme()));
            TextFileOutput step = (TextFileOutput)Util.getTypedStep((TransMeta)this.transMeta, (String)this.operation.getId(), TextFileOutput.class);
            step.setInputRowMeta(MetaHelper.getPrevStepFields((TransMeta)this.transMeta, (String)this.getId()));
            if (step.getParentVariableSpace() == null) {
                step.setParentVariableSpace((VariableSpace)new Variables());
            }
            if (step.init(step.getStepMeta().getStepMetaInterface(), step.getStepDataInterface()) && step.getErrors() == 0L) {
                step.setRowHandler(Util.rowGetter(() -> this.nextRow.get()));
                rdd.toLocalIterator().forEachRemaining(row -> this.processRow(step, (Row)row));
                this.processRow(step, (Row)new KettleRow(MetaHelper.getRowMeta((TransMeta)this.transMeta, (String)this.operation.getId()), null));
                if (this.fileMeta.isAddToResultFiles()) {
                    step.getResultFiles().forEach((fileName, resultFile) -> this.sparkEngineContext.addResultFile(fileName));
                }
                step.dispose(step.getStepMeta().getStepMetaInterface(), step.getStepDataInterface());
                if (this.isFinalOperation) {
                    FinalOperationEvent.sendEvent((JavaSparkContext)this.sparkContext, (String)this.getUUID());
                }
            } else {
                OperationErrorEvent.sendEvent((JavaSparkContext)this.sparkContext, (String)this.getUUID(), (Throwable)new RuntimeException(BaseMessages.getString(PKG, (String)ERROR_INITIALIZING, (String[])new String[]{this.operation.getId()})));
            }
        }
        catch (Exception e) {
            OperationErrorEvent.sendEvent((JavaSparkContext)this.sparkContext, (String)this.getUUID(), (Throwable)e);
        }
    }

    private void processRow(TextFileOutput step, Row row) {
        this.nextRow.set(row.getObjects());
        try {
            if (step.processRow(step.getStepMeta().getStepMetaInterface(), step.getStepDataInterface())) {
                this.metricsAccumulator.addRowIn();
                this.metricsAccumulator.addRowOut();
            }
        }
        catch (KettleException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    URI getUri() {
        String fileName = this.transMeta.environmentSubstitute(this.fileMeta.getFileName());
        if (this.fileMeta.isSpecifyingFormat() && !Utils.isEmpty((CharSequence)this.fileMeta.getDateTimeFormat())) {
            fileName = fileName + this.now.format(DateTimeFormatter.ofPattern(this.fileMeta.getDateTimeFormat()));
        } else {
            if (this.fileMeta.isDateInFilename()) {
                fileName = fileName + "_" + this.now.format(DateTimeFormatter.ofPattern(DATE_PATTERN));
            }
            if (this.fileMeta.isTimeInFilename()) {
                fileName = fileName + "_" + this.now.format(DateTimeFormatter.ofPattern(TIME_PATTERN));
            }
        }
        try {
            Path path = new Path(fileName);
            URI uri = path.toUri();
            if (uri.getScheme() == null) {
                uri = this.fileMeta.getParentStepMeta().getStepID().matches(".*[Hh]adoop.*") ? new URI(HDFS, uri.getHost(), uri.getPath(), uri.getFragment()) : new URI(FILE, uri.getHost(), uri.getPath(), uri.getFragment());
            }
            return uri;
        }
        catch (URISyntaxException e) {
            return new File(fileName).toURI();
        }
    }
}

