/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.pentaho.big.data.kettle.plugins.formats.avro.output.AvroOutputMetaBase;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.BaseSparkOperation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.events.FinalOperationEvent;
import org.pentaho.di.engine.spark.impl.events.OperationErrorEvent;
import org.pentaho.di.engine.spark.impl.functions.KettleToFormatRowFunction;
import org.pentaho.di.engine.spark.impl.logger.FunctionLogger;
import org.pentaho.di.engine.spark.impl.typehandling.AvroSpec;
import org.pentaho.di.engine.spark.impl.typehandling.AvroTypeMapper;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.engine.spark.util.MetaHelper;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;

public class AvroOutputSparkOperation
extends BaseSparkOperation {
    private static final String AVRO_COMPRESSION_CODEC = "spark.sql.avro.compression.codec";
    private static final String HDFS = "hdfs";
    private static final String AVRO_FORMAT = "com.databricks.spark.avro";
    private static final String RECORD_NAMESPACE = "recordNamespace";
    private static final String RECORD_NAME = "recordName";
    private static final String SNAPPY_COMPRESS_OPTION = "snappy";
    private static final String DEFLATE_COMPRESS_OPTION = "deflate";
    private static final String UNCOMPRESSED_COMPRESS_OPTION = "uncompressed";
    private final TransMeta transMeta;
    private final AvroOutputMetaBase avroOutputMetaBase;
    private final AvroOutputMetaBase outputMeta;
    private final JavaSparkContext sparkContext;
    private final RowMetaInterface rowMeta;
    private final AtomicReference<Object[]> nextRow = new AtomicReference();
    private final Consumer<JavaRDD<org.pentaho.di.engine.api.model.Row>> DEFAULT_FILE_ACTION = this::saveDefaultAction;
    private Map<String, Consumer<JavaRDD<org.pentaho.di.engine.api.model.Row>>> fileActionMap = ImmutableMap.of((Object)"hdfs", this.DEFAULT_FILE_ACTION);
    private int totalRows = 0;
    private final boolean isFinalOperation;
    private MetricsAccumulator metricsAccumulator = MetricsAccumulator.empty();
    private FunctionLogger operationLogger = FunctionLogger.empty();

    public AvroOutputSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        super(operation);
        this.transMeta = stepMeta.getParentTransMeta();
        this.avroOutputMetaBase = (AvroOutputMetaBase)MetaHelper.getTypedStepMeta((StepMeta)stepMeta, AvroOutputMetaBase.class);
        this.outputMeta = (AvroOutputMetaBase)stepMeta.getStepMetaInterface();
        this.sparkContext = sparkContext;
        this.isFinalOperation = operation.getHopsOut() == null || operation.getHopsOut().isEmpty();
        this.rowMeta = MetaHelper.getRowMeta((TransMeta)this.transMeta, (String)operation.getId());
    }

    @VisibleForTesting
    AvroOutputSparkOperation(Operation operation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext, Map<String, Consumer<JavaRDD<org.pentaho.di.engine.api.model.Row>>> fileActionMap) {
        this(operation, null, stepMeta, sparkContext, executionContext);
        this.fileActionMap = fileActionMap;
    }

    public static SparkOperationFactory factory() {
        return new SparkOperationFactory(AvroOutputSparkOperation::new, new Supplier[]{KettleToFormatRowFunction::new});
    }

    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }

    public void apply(SparkOperation.Subscriber subscriber) {
        Set expectedOutputs = subscriber.getExpectedOutputs();
        this.metricsAccumulator = subscriber.getMetricsAccumulator();
        FunctionLogger transLogger = Util.getTransformationLogger((SparkOperation.Subscriber)subscriber);
        this.operationLogger = Util.getOperationLogger((SparkOperation.Subscriber)subscriber);
        JavaRDD rdd = subscriber.getInput().map(input -> expectedOutputs.isEmpty() ? input : input.cache()).orElseGet(() -> ((JavaSparkContext)this.sparkContext).emptyRDD());
        expectedOutputs.forEach(output -> subscriber.addOutput(output, rdd));
        subscriber.registerDriverAction(() -> this.saveDefaultAction((JavaRDD<org.pentaho.di.engine.api.model.Row>)rdd));
    }

    @VisibleForTesting
    protected void saveDefaultAction(JavaRDD<org.pentaho.di.engine.api.model.Row> rdd) {
        try {
            Dataset<Row> rowDataset = this.convert(rdd);
            switch (AvroOutputMetaBase.CompressionType.valueOf((String)this.avroOutputMetaBase.getCompressionType().toUpperCase())) {
                case SNAPPY: {
                    rowDataset.sqlContext().setConf(AVRO_COMPRESSION_CODEC, SNAPPY_COMPRESS_OPTION);
                    break;
                }
                case DEFLATE: {
                    rowDataset.sqlContext().setConf(AVRO_COMPRESSION_CODEC, DEFLATE_COMPRESS_OPTION);
                    break;
                }
                default: {
                    rowDataset.sqlContext().setConf(AVRO_COMPRESSION_CODEC, UNCOMPRESSED_COMPRESS_OPTION);
                }
            }
            String filename = this.transMeta.environmentSubstitute(this.avroOutputMetaBase.getFilename());
            DataFrameWriter writer = rowDataset.write().format(AVRO_FORMAT);
            if (this.avroOutputMetaBase.isOverrideOutput()) {
                writer.mode(SaveMode.Overwrite);
            } else {
                writer.mode(SaveMode.ErrorIfExists);
            }
            if (this.avroOutputMetaBase.getNamespace() != null) {
                writer.option(RECORD_NAMESPACE, this.avroOutputMetaBase.getNamespace());
            }
            if (this.avroOutputMetaBase.getRecordName() != null) {
                writer.option(RECORD_NAME, this.avroOutputMetaBase.getRecordName());
            }
            writer.save(this.avroOutputMetaBase.constructOutputFilename(filename));
            if (this.isFinalOperation) {
                FinalOperationEvent.sendEvent((JavaSparkContext)this.sparkContext, (String)this.getUUID());
            }
        }
        catch (Exception e) {
            OperationErrorEvent.sendEvent((JavaSparkContext)this.sparkContext, (String)this.getUUID(), (Throwable)e);
        }
    }

    private Dataset<Row> convert(JavaRDD<org.pentaho.di.engine.api.model.Row> input) {
        SparkSession spark = Util.getSparkSession();
        AvroTypeMapper typeMapper = new AvroTypeMapper(MetaHelper.getRowMeta((StepMeta)this.avroOutputMetaBase.getParentStepMeta()), this.avroOutputMetaBase.getOutputFields(), true, AvroSpec.DataType.class);
        JavaRDD sparkRDD = input.map((Function)new KettleToFormatRowFunction(this.metricsAccumulator, typeMapper).asRegisteredFunction(this.avroOutputMetaBase.getParentStepMeta().getStepID()));
        return spark.createDataFrame(sparkRDD, typeMapper.schema());
    }
}

