/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.pentaho.big.data.kettle.plugins.formats.avro.input.AvroInputMetaBase;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.BaseSparkOperation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.events.OperationErrorEvent;
import org.pentaho.di.engine.spark.impl.functions.FileInputContentFunction;
import org.pentaho.di.engine.spark.impl.functions.SparkToKettleRowFunction;
import org.pentaho.di.engine.spark.impl.ops.FileInputResolver;
import org.pentaho.di.engine.spark.impl.typehandling.AvroSpec;
import org.pentaho.di.engine.spark.impl.typehandling.AvroTypeMapper;
import org.pentaho.di.engine.spark.spi.RegisteredFunction;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.engine.spark.util.MetaHelper;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.file.BaseFileInputMeta;
import org.pentaho.hadoop.shim.api.format.IAvroInputField;

public class AvroInputSparkOperation
extends BaseSparkOperation {
    private static final String AVRO_FORMAT = "com.databricks.spark.avro";
    private final TransMeta transMeta;
    private final JavaSparkContext sparkContext;
    private final AvroInputMetaBase fileMeta;
    private MetricsAccumulator metricsAccumulator;

    public AvroInputSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        this(operation, stepMeta, sparkContext);
    }

    AvroInputSparkOperation(Operation operation, StepMeta stepMeta, JavaSparkContext sparkContext) {
        super(operation);
        this.transMeta = stepMeta.getParentTransMeta();
        this.fileMeta = (AvroInputMetaBase)MetaHelper.getTypedStepMeta((StepMeta)stepMeta, AvroInputMetaBase.class);
        this.sparkContext = sparkContext;
    }

    public static SparkOperationFactory factory() {
        return new SparkOperationFactory(AvroInputSparkOperation::new, new Supplier[]{FileInputContentFunction::new, SparkToKettleRowFunction::new});
    }

    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }

    public void apply(SparkOperation.Subscriber subscriber) {
        this.metricsAccumulator = subscriber.getMetricsAccumulator();
        subscriber.setOutput(CompletableFuture.supplyAsync(this::loadDefaultAction, arg_0 -> ((SparkOperation.Subscriber)subscriber).registerDriverAction(arg_0)));
    }

    @VisibleForTesting
    protected JavaRDD<Row> loadDefaultAction() {
        try {
            SparkSession sparkSession = Util.getSparkSession();
            List<String> files = FileInputResolver.getFiles((VariableSpace)this.transMeta, this.mergeFileList(this.fileMeta), this.sparkContext);
            Dataset rowDataset = sparkSession.read().format(AVRO_FORMAT).load(files.toArray(new String[0]));
            this.metricsAccumulator.setCountRowIn(false);
            SparkToKettleRowFunction rowFunction = new SparkToKettleRowFunction(this.transMeta.findStep(this.getId()), this.metricsAccumulator, new AvroTypeMapper((IAvroInputField[])this.fileMeta.getInputFields(), rowDataset.schema(), AvroSpec.DataType.class));
            RegisteredFunction registeredFunction = rowFunction.asRegisteredFunction(this.fileMeta.getParentStepMeta().getStepID());
            return rowDataset.toJavaRDD().mapPartitions(registeredFunction.toFlatMap());
        }
        catch (Exception e) {
            OperationErrorEvent.sendEvent((JavaSparkContext)this.sparkContext, (String)this.getUUID(), (Throwable)e);
            return null;
        }
    }

    private BaseFileInputMeta mergeFileList(AvroInputMetaBase fileMeta) {
        BaseFileInputMeta inputMeta = (BaseFileInputMeta)fileMeta.clone();
        ArrayList<String> files = new ArrayList<String>(Arrays.asList(inputMeta.inputFiles.fileName));
        files.add(fileMeta.getFilename());
        inputMeta.inputFiles.fileName = (String[])files.stream().filter(Objects::nonNull).toArray(String[]::new);
        inputMeta.inputFiles.fileMask = new String[inputMeta.inputFiles.fileName.length];
        inputMeta.inputFiles.excludeFileMask = new String[inputMeta.inputFiles.fileName.length];
        inputMeta.inputFiles.fileRequired = new String[inputMeta.inputFiles.fileName.length];
        inputMeta.inputFiles.includeSubFolders = new String[inputMeta.inputFiles.fileName.length];
        return inputMeta;
    }
}

