/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.spark.api.TypeMapper;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.spi.ConfigurableFunction;
import org.pentaho.di.engine.spark.spi.KettleRow;
import org.pentaho.di.engine.spark.util.MetaHelper;
import org.pentaho.di.engine.spark.util.ObjectStringSerializer;
import org.pentaho.di.engine.spark.util.SerializableStepMeta;
import org.pentaho.di.engine.spark.util.StructTypeMapper;
import org.pentaho.di.trans.step.StepMeta;

public class SparkToKettleRowFunction
extends ConfigurableFunction<Iterator<Row>, Iterator<org.pentaho.di.engine.api.model.Row>>
implements FlatMapFunction<Iterator<Row>, org.pentaho.di.engine.api.model.Row> {
    private static final long serialVersionUID = -8387294136003736814L;
    private static final String METRICS_ACCUMULATOR_SERIALIZED_ATT = "-metricsAccumulator";
    private static final String TYPE_MAPPER_SERIALIZED_ATT = "-typeMapper";
    private transient StepMeta stepMeta;
    private transient MetricsAccumulator metricsAccumulator;
    private transient TypeMapper<StructType> typeMapper;

    public SparkToKettleRowFunction() {
    }

    public SparkToKettleRowFunction(StepMeta stepMeta, MetricsAccumulator metricsAccumulator, TypeMapper<StructType> mapperFactory) {
        this.stepMeta = stepMeta;
        this.metricsAccumulator = metricsAccumulator;
        this.typeMapper = mapperFactory;
    }

    public SparkToKettleRowFunction(StepMeta stepMeta, MetricsAccumulator metricsAccumulator) {
        this(stepMeta, metricsAccumulator, (TypeMapper<StructType>)new StructTypeMapper(MetaHelper.getRowMeta((StepMeta)stepMeta)));
    }

    public Iterator<org.pentaho.di.engine.api.model.Row> call(final Iterator<Row> rowIterator) throws Exception {
        final RowMetaInterface rowMeta = this.stepMeta.getParentTransMeta().getStepFields(this.stepMeta);
        return new Iterator<org.pentaho.di.engine.api.model.Row>(){

            @Override
            public boolean hasNext() {
                return rowIterator.hasNext();
            }

            @Override
            public org.pentaho.di.engine.api.model.Row next() {
                SparkToKettleRowFunction.this.metricsAccumulator.addRowIn();
                SparkToKettleRowFunction.this.metricsAccumulator.addRowOut();
                Row row = (Row)rowIterator.next();
                return new KettleRow(rowMeta, SparkToKettleRowFunction.this.typeMapper.mapValuesFrom((Object)row.schema(), SparkToKettleRowFunction.this.objects(row)));
            }
        };
    }

    private Object[] objects(Row row) {
        return IntStream.range(0, row.size()).mapToObj(arg_0 -> ((Row)row).get(arg_0)).toArray();
    }

    public Map<String, Serializable> getConfig() {
        return ImmutableMap.of((Object)SerializableStepMeta.class.getName(), (Object)new SerializableStepMeta(this.stepMeta), (Object)(((Object)((Object)this)).getClass().getName() + METRICS_ACCUMULATOR_SERIALIZED_ATT), (Object)this.metricsAccumulator, (Object)(((Object)((Object)this)).getClass().getName() + TYPE_MAPPER_SERIALIZED_ATT), (Object)ObjectStringSerializer.ser(this.typeMapper));
    }

    public void setConfig(String key, Serializable value) {
        if (Objects.equals(key, SerializableStepMeta.class.getName())) {
            SerializableStepMeta delegate = (SerializableStepMeta)value;
            this.stepMeta = delegate.getStepMeta();
        } else if (Objects.equals(key, ((Object)((Object)this)).getClass().getName() + METRICS_ACCUMULATOR_SERIALIZED_ATT)) {
            this.metricsAccumulator = (MetricsAccumulator)value;
        } else if (Objects.equals(key, ((Object)((Object)this)).getClass().getName() + TYPE_MAPPER_SERIALIZED_ATT)) {
            this.typeMapper = (TypeMapper)ObjectStringSerializer.deser((String)value.toString(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        }
    }
}

