/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.types.StructType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.spark.api.TypeMapper;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.spi.ConfigurableFunction;
import org.pentaho.di.engine.spark.util.ObjectStringSerializer;
import org.pentaho.di.engine.spark.util.StructTypeMapper;

public class KettleToSparkRowFunction
extends ConfigurableFunction<org.pentaho.di.engine.api.model.Row, Row>
implements Function<org.pentaho.di.engine.api.model.Row, Row> {
    private static final long serialVersionUID = 1249005474535308786L;
    private transient TypeMapper<StructType> typeMapper;
    private transient MetricsAccumulator metricsAccumulator;

    public KettleToSparkRowFunction(MetricsAccumulator metricsAccumulator, TypeMapper<StructType> typeMapper) {
        this.metricsAccumulator = metricsAccumulator;
        this.typeMapper = typeMapper;
    }

    public KettleToSparkRowFunction(RowMetaInterface rowMeta, MetricsAccumulator metricsAccumulator) {
        this(metricsAccumulator, (TypeMapper<StructType>)new StructTypeMapper(rowMeta));
    }

    public KettleToSparkRowFunction() {
    }

    public Row call(org.pentaho.di.engine.api.model.Row row) throws Exception {
        this.metricsAccumulator.addRowIn();
        this.metricsAccumulator.addRowOut();
        return RowFactory.create((Object[])this.typeMapper.mapValuesTo(row.getObjects()));
    }

    public Map<String, Serializable> getConfig() {
        return ImmutableMap.of((Object)(((Object)((Object)this)).getClass().getName() + "_METRICSACCUMULATOR"), (Object)this.metricsAccumulator, (Object)(((Object)((Object)this)).getClass().getName() + "_TYPEMAPPER"), (Object)ObjectStringSerializer.ser(this.typeMapper));
    }

    public void setConfig(String key, Serializable value) {
        if (Objects.equals(key, ((Object)((Object)this)).getClass().getName() + "_METRICSACCUMULATOR")) {
            this.metricsAccumulator = (MetricsAccumulator)value;
        } else if (Objects.equals(key, ((Object)((Object)this)).getClass().getName() + "_TYPEMAPPER")) {
            this.typeMapper = (TypeMapper)ObjectStringSerializer.deser((String)value.toString(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        }
    }
}

