/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.types.StructType;
import org.pentaho.di.engine.spark.api.TypeMapper;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.spi.ConfigurableFunction;
import org.pentaho.di.engine.spark.util.ObjectStringSerializer;

public class KettleToFormatRowFunction
extends ConfigurableFunction<org.pentaho.di.engine.api.model.Row, Row>
implements Function<org.pentaho.di.engine.api.model.Row, Row> {
    private static final long serialVersionUID = 1249005474535308786L;
    private static final String METRICS_ACCUMULATOR_SERIALIZED_ATT = "_METRICSACCUMULATOR";
    private static final String TYPE_MAPPER_SERIALIZED_ATT = "_TYPEMAPPER";
    private transient TypeMapper<StructType> typeMapper;
    private transient MetricsAccumulator metricsAccumulator;

    public KettleToFormatRowFunction(MetricsAccumulator metricsAccumulator, TypeMapper<StructType> typeMapper) {
        this.metricsAccumulator = metricsAccumulator;
        this.typeMapper = typeMapper;
    }

    public KettleToFormatRowFunction() {
    }

    public Row call(org.pentaho.di.engine.api.model.Row row) throws Exception {
        this.metricsAccumulator.addRowIn();
        this.metricsAccumulator.addRowOut();
        return RowFactory.create((Object[])this.typeMapper.mapValuesTo(row.getObjects()));
    }

    public Map<String, Serializable> getConfig() {
        return ImmutableMap.of((Object)(((Object)((Object)this)).getClass().getName() + METRICS_ACCUMULATOR_SERIALIZED_ATT), (Object)this.metricsAccumulator, (Object)(((Object)((Object)this)).getClass().getName() + TYPE_MAPPER_SERIALIZED_ATT), (Object)ObjectStringSerializer.ser(this.typeMapper));
    }

    public void setConfig(String key, Serializable value) {
        if (Objects.equals(key, ((Object)((Object)this)).getClass().getName() + METRICS_ACCUMULATOR_SERIALIZED_ATT)) {
            this.metricsAccumulator = (MetricsAccumulator)value;
        } else if (Objects.equals(key, ((Object)((Object)this)).getClass().getName() + TYPE_MAPPER_SERIALIZED_ATT)) {
            this.typeMapper = (TypeMapper)ObjectStringSerializer.deser((String)value.toString(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        }
    }
}

