/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.spi.ConfigurableFunction;
import org.pentaho.di.engine.spark.spi.KettleRow;
import org.pentaho.di.engine.spark.util.SerializableStepMeta;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.StepMeta;

public class KettleRowMappingFunction
extends ConfigurableFunction<Iterator<Row>, Iterator<Row>>
implements FlatMapFunction<Iterator<Row>, Row> {
    private static final long serialVersionUID = 7659889265814619250L;
    private static final Class<?> PKG = KettleRowMappingFunction.class;
    private static final String FIELD_NOT_FOUND = "KettleRowMappingFunction.CantFindField";
    private transient StepMeta stepMeta;
    private MetricsAccumulator metricsAccumulator;

    public KettleRowMappingFunction() {
    }

    public KettleRowMappingFunction(StepMeta stepMeta, MetricsAccumulator metricsAccumulator) {
        this.stepMeta = stepMeta;
        this.metricsAccumulator = metricsAccumulator;
    }

    public Iterator<Row> call(final Iterator<Row> rowIterator) throws Exception {
        final RowMetaInterface rowMeta = this.stepMeta.getParentTransMeta().getStepFields(this.stepMeta);
        return new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                return rowIterator.hasNext();
            }

            @Override
            public Row next() {
                KettleRowMappingFunction.this.metricsAccumulator.addRowIn();
                Row row = KettleRowMappingFunction.this.toKettleRow((Row)rowIterator.next(), rowMeta);
                KettleRowMappingFunction.this.metricsAccumulator.addRowOut();
                return row;
            }
        };
    }

    private Row toKettleRow(Row row, RowMetaInterface rowMeta) {
        List columnNames = row.getColumnNames().stream().map(String::toLowerCase).collect(Collectors.toList());
        List values = rowMeta.getValueMetaList().stream().map(meta -> {
            int rowIndex = columnNames.indexOf(meta.getName().toLowerCase());
            if (-1 == rowIndex) {
                throw new NoSuchElementException(BaseMessages.getString(PKG, (String)FIELD_NOT_FOUND, (String[])new String[]{meta.getName()}));
            }
            return row.getObjects()[rowIndex];
        }).collect(Collectors.toList());
        return new KettleRow(rowMeta, values.toArray());
    }

    public Map<String, Serializable> getConfig() {
        return ImmutableMap.of((Object)SerializableStepMeta.class.getName(), (Object)new SerializableStepMeta(this.stepMeta), (Object)MetricsAccumulator.class.getName(), (Object)this.metricsAccumulator);
    }

    public void setConfig(String key, Serializable value) {
        if (Objects.equals(key, SerializableStepMeta.class.getName())) {
            SerializableStepMeta delegate = (SerializableStepMeta)value;
            this.stepMeta = delegate.getStepMeta();
        } else if (Objects.equals(key, MetricsAccumulator.class.getName())) {
            this.metricsAccumulator = (MetricsAccumulator)value;
        }
    }
}

