/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.spi.ConfigurableFunction;
import org.pentaho.di.engine.spark.util.MetaHelper;
import org.pentaho.di.engine.spark.util.SerializableStepMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.filterrows.FilterRowsMeta;

public class KettleFilterFunction
extends ConfigurableFunction<Row, Boolean> {
    private static final String STEP_META = "KettleFilterFunction-stepMeta";
    private static final String TRUE_PATH = "KettleFilterFunction-truePath";
    private static final String METRICS_ACCUM = "KettleFilterFunction-metricsAccumulator";
    private boolean truePath;
    private transient StepMeta stepMeta;
    private transient MetricsAccumulator metricsAccumulator;
    private transient RowMetaInterface rowMetaInterface;
    private transient Condition condition;

    public KettleFilterFunction() {
    }

    public KettleFilterFunction(StepMeta stepMeta, boolean truePredicate, MetricsAccumulator metricsAccumulator) {
        this.stepMeta = stepMeta;
        this.truePath = truePredicate;
        this.metricsAccumulator = metricsAccumulator;
        this.rowMetaInterface = MetaHelper.getRowMeta((TransMeta)stepMeta.getParentTransMeta(), (String)stepMeta.getName());
        this.condition = ((FilterRowsMeta)MetaHelper.getTypedStepMeta((StepMeta)stepMeta, FilterRowsMeta.class)).getCondition();
    }

    public Boolean call(Row row) throws Exception {
        this.metricsAccumulator.addRowIn();
        this.metricsAccumulator.addRowOut();
        return this.truePath == this.condition.evaluate(this.rowMetaInterface, row.getObjects());
    }

    public Map<String, Serializable> getConfig() {
        return ImmutableMap.of((Object)STEP_META, (Object)new SerializableStepMeta(this.stepMeta), (Object)TRUE_PATH, (Object)this.truePath, (Object)METRICS_ACCUM, (Object)this.metricsAccumulator);
    }

    public void setConfig(String key, Serializable value) {
        switch (key) {
            case "KettleFilterFunction-stepMeta": {
                this.stepMeta = ((SerializableStepMeta)value).getStepMeta();
                this.rowMetaInterface = MetaHelper.getRowMeta((TransMeta)this.stepMeta.getParentTransMeta(), (String)this.stepMeta.getName());
                this.condition = ((FilterRowsMeta)MetaHelper.getTypedStepMeta((StepMeta)this.stepMeta, FilterRowsMeta.class)).getCondition();
                break;
            }
            case "KettleFilterFunction-truePath": {
                this.truePath = (Boolean)value;
                break;
            }
            case "KettleFilterFunction-metricsAccumulator": {
                this.metricsAccumulator = (MetricsAccumulator)value;
            }
        }
    }
}

