/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.spi.ConfigurableFunction;
import org.pentaho.di.engine.spark.spi.KettleRow;
import org.pentaho.di.engine.spark.util.SerializableStepMeta;
import org.pentaho.di.trans.step.StepMeta;

public class KafkaToKettleRowFunction<K, V>
extends ConfigurableFunction<Iterator<ConsumerRecord<K, V>>, Iterator<Row>>
implements FlatMapFunction<Iterator<ConsumerRecord<K, V>>, Row> {
    private static final long serialVersionUID = 8124440930068633661L;
    private transient StepMeta stepMeta;
    private MetricsAccumulator metricsAccumulator;

    public KafkaToKettleRowFunction() {
    }

    public KafkaToKettleRowFunction(StepMeta stepMeta, MetricsAccumulator metricsAccumulator) {
        this.stepMeta = stepMeta;
        this.metricsAccumulator = metricsAccumulator;
    }

    public Iterator<Row> call(final Iterator<ConsumerRecord<K, V>> rowIterator) throws Exception {
        final RowMetaInterface rowMeta = this.stepMeta.getParentTransMeta().getStepFields(this.stepMeta);
        return new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                return rowIterator.hasNext();
            }

            @Override
            public Row next() {
                KafkaToKettleRowFunction.this.metricsAccumulator.addRowIn();
                return KafkaToKettleRowFunction.this.toKettleRow((ConsumerRecord)rowIterator.next(), rowMeta);
            }
        };
    }

    private Row toKettleRow(ConsumerRecord row, RowMetaInterface rowMeta) {
        Object[] values = new Object[]{row.key(), row.value(), row.topic(), (long)row.partition(), row.offset(), row.timestamp()};
        return new KettleRow(rowMeta, values);
    }

    public Map<String, Serializable> getConfig() {
        return ImmutableMap.of((Object)SerializableStepMeta.class.getName(), (Object)new SerializableStepMeta(this.stepMeta), (Object)MetricsAccumulator.class.getName(), (Object)this.metricsAccumulator);
    }

    public void setConfig(String key, Serializable value) {
        if (Objects.equals(key, SerializableStepMeta.class.getName())) {
            SerializableStepMeta delegate = (SerializableStepMeta)value;
            this.stepMeta = delegate.getStepMeta();
        } else if (Objects.equals(key, MetricsAccumulator.class.getName())) {
            this.metricsAccumulator = (MetricsAccumulator)value;
        }
    }
}

