/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.listeners.LoggingToAccumAdapter;
import org.pentaho.di.engine.spark.impl.logger.FunctionLogger;
import org.pentaho.di.engine.spark.spi.ConfigurableFunction;
import org.pentaho.di.engine.spark.util.MetaHelper;
import org.pentaho.di.engine.spark.util.SerializableStepMeta;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.textfileoutput.TextFileField;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutput;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputData;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputMeta;

public class FileOutputContentFunction
extends ConfigurableFunction<Iterator<Row>, Iterator<String>>
implements FlatMapFunction<Iterator<Row>, String> {
    private static final Class<?> PKG = FileOutputContentFunction.class;
    private static final String ERROR_PROCESSING = "FileOutputContentFunction.ErrorProcessing";
    private static final String ERROR_COLUMN_VALIDATION = "FileOutputContentFunction.ColumnNameValidation";
    private static final String STEP_META = "FileOutputContentFunction-stepMeta";
    private static final String METRICS_ACCUM = "FileOutputContentFunction-metricsAccumulator";
    private static final String TRANS_LOGGER = "FileOutputContentFunction-transLogger";
    private static final String OPERATION_LOGGER = "FileOutputContentFunction-operationLogger";
    private transient StepMeta stepMeta;
    private transient MetricsAccumulator metricsAccumulator;
    private transient FunctionLogger transLogger;
    private transient FunctionLogger operationLogger;
    private boolean isFirst;

    public FileOutputContentFunction() {
    }

    public FileOutputContentFunction(StepMeta stepMeta, MetricsAccumulator metricsAccumulator, FunctionLogger transLogger, FunctionLogger operationLogger) {
        this.stepMeta = stepMeta;
        this.metricsAccumulator = metricsAccumulator;
        this.transLogger = transLogger;
        this.operationLogger = operationLogger;
    }

    public Iterator<String> call(Iterator<Row> rowIterator) throws Exception {
        this.isFirst = true;
        LoggingToAccumAdapter logAdapter = Util.setLogAccumulators((String)this.stepMeta.getName(), (FunctionLogger)this.transLogger, (FunctionLogger)this.operationLogger);
        TextFileOutput step = (TextFileOutput)Util.getTypedStep((StepMeta)this.stepMeta, TextFileOutput.class);
        TextFileOutputMeta textFileOutputMeta = (TextFileOutputMeta)step.getStepMeta().getStepMetaInterface();
        textFileOutputMeta.setDoNotOpenNewFileInit(true);
        TextFileOutputData textFileOutputData = (TextFileOutputData)textFileOutputMeta.getStepData();
        textFileOutputData.outputRowMeta = MetaHelper.getRowMeta((TransMeta)this.stepMeta.getParentTransMeta(), (String)this.stepMeta.getName()).clone();
        textFileOutputData.fieldnrs = Ints.toArray((Collection)Arrays.stream(textFileOutputMeta.getOutputFields()).map(TextFileField::getName).map(arg_0 -> ((RowMetaInterface)textFileOutputData.outputRowMeta).indexOfValue(arg_0)).collect(Collectors.toList()));
        step.init((StepMetaInterface)textFileOutputMeta, (StepDataInterface)textFileOutputData);
        ArrayList outputRows = new ArrayList();
        rowIterator.forEachRemaining(row -> {
            try (ByteArrayOutputStream writer = new ByteArrayOutputStream();){
                if (this.isFirst) {
                    this.isFirst = false;
                    this.validateColumnNames(this.stepMeta, (Row)row);
                }
                this.metricsAccumulator.addRowIn();
                textFileOutputData.writer = writer;
                step.writeRow(textFileOutputData.outputRowMeta, row.getObjects());
                this.metricsAccumulator.addRowOut();
                outputRows.add(((Object)writer).toString());
            }
            catch (InvalidColumnException ex) {
                throw new RuntimeException(ex.getMessage());
            }
            catch (Exception ex) {
                this.operationLogger.error(BaseMessages.getString(PKG, (String)ERROR_PROCESSING, (String[])new String[]{ex.getMessage()}));
            }
        });
        Util.removeLogAccumulatores((LoggingToAccumAdapter)logAdapter);
        return outputRows.iterator();
    }

    private void validateColumnNames(StepMeta stepMeta, Row row) throws InvalidColumnException {
        TextFileOutputMeta textFileOutputMeta = (TextFileOutputMeta)stepMeta.getStepMetaInterface();
        TextFileField[] outputFields = textFileOutputMeta.getOutputFields();
        List rowFields = row.getColumnNames();
        for (TextFileField outputField : outputFields) {
            if (rowFields.contains(outputField.getName())) continue;
            throw new InvalidColumnException(BaseMessages.getString(PKG, (String)ERROR_COLUMN_VALIDATION, (String[])new String[]{outputField.getName()}));
        }
    }

    public Map<String, Serializable> getConfig() {
        return ImmutableMap.of((Object)STEP_META, (Object)new SerializableStepMeta(this.stepMeta), (Object)METRICS_ACCUM, (Object)this.metricsAccumulator, (Object)TRANS_LOGGER, (Object)this.transLogger, (Object)OPERATION_LOGGER, (Object)this.operationLogger);
    }

    public void setConfig(String key, Serializable value) {
        switch (key) {
            case "FileOutputContentFunction-stepMeta": {
                this.stepMeta = ((SerializableStepMeta)value).getStepMeta();
                break;
            }
            case "FileOutputContentFunction-metricsAccumulator": {
                this.metricsAccumulator = (MetricsAccumulator)value;
                break;
            }
            case "FileOutputContentFunction-transLogger": {
                this.transLogger = (FunctionLogger)value;
                break;
            }
            case "FileOutputContentFunction-operationLogger": {
                this.operationLogger = (FunctionLogger)value;
            }
        }
    }

    class InvalidColumnException
    extends Exception {
        private static final long serialVersionUID = 3999916281891222715L;

        public InvalidColumnException(String message) {
            super(message);
        }
    }
}

