/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ssh;

import com.google.common.annotations.VisibleForTesting;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.HTTPProxyData;
import com.trilead.ssh2.ProxyData;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.ssh.SSHMeta;

public class SSHData
extends BaseStepData
implements StepDataInterface {
    public int indexOfCommand = -1;
    public Connection conn = null;
    public boolean wroteOneRow = false;
    public String commands = null;
    public int nrInputFields;
    public int nrOutputFields;
    public String stdOutField = null;
    public String stdTypeField = null;
    public RowMetaInterface outputRowMeta;

    public static Connection OpenConnection(String serveur, int port, String username, String password, boolean useKey, String keyFilename, String passPhrase, int timeOut, VariableSpace space, String proxyhost, int proxyport, String proxyusername, String proxypassword) throws KettleException {
        Connection conn = null;
        char[] content = null;
        boolean isAuthenticated = false;
        try {
            if (useKey) {
                if (Utils.isEmpty((CharSequence)keyFilename)) {
                    throw new KettleException(BaseMessages.getString(SSHMeta.PKG, (String)"SSH.Error.PrivateKeyFileMissing", (String[])new String[0]));
                }
                FileObject keyFileObject = KettleVFS.getFileObject((String)keyFilename);
                if (!keyFileObject.exists()) {
                    throw new KettleException(BaseMessages.getString(SSHMeta.PKG, (String)"SSH.Error.PrivateKeyNotExist", (String[])new String[]{keyFilename}));
                }
                FileContent keyFileContent = keyFileObject.getContent();
                CharArrayWriter charArrayWriter = new CharArrayWriter((int)keyFileContent.getSize());
                try (InputStream in = keyFileContent.getInputStream();){
                    IOUtils.copy((InputStream)in, (Writer)charArrayWriter);
                }
                content = charArrayWriter.toCharArray();
            }
            conn = SSHData.createConnection(serveur, port);
            if (!Utils.isEmpty((CharSequence)proxyhost)) {
                if (!Utils.isEmpty((CharSequence)proxyusername)) {
                    conn.setProxyData((ProxyData)new HTTPProxyData(proxyhost, proxyport, proxyusername, proxypassword));
                } else {
                    conn.setProxyData((ProxyData)new HTTPProxyData(proxyhost, proxyport));
                }
            }
            if (timeOut == 0) {
                conn.connect();
            } else {
                conn.connect(null, 0, timeOut * 1000);
            }
            isAuthenticated = useKey ? conn.authenticateWithPublicKey(username, content, space.environmentSubstitute(passPhrase)) : conn.authenticateWithPassword(username, password);
            if (!isAuthenticated) {
                throw new KettleException(BaseMessages.getString(SSHMeta.PKG, (String)"SSH.Error.AuthenticationFailed", (String[])new String[]{username}));
            }
        }
        catch (Exception e) {
            if (conn != null) {
                conn.close();
            }
            throw new KettleException(BaseMessages.getString(SSHMeta.PKG, (String)"SSH.Error.ErrorConnecting", (String[])new String[]{serveur, username}), (Throwable)e);
        }
        return conn;
    }

    @VisibleForTesting
    static Connection createConnection(String serveur, int port) {
        return new Connection(serveur, port);
    }
}

