/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rest;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.api.uri.UriComponent;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.sun.jersey.client.apache4.config.DefaultApacheHttpClient4Config;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.json.simple.JSONObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.rest.RestData;
import org.pentaho.di.trans.steps.rest.RestMeta;

public class Rest
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = RestMeta.class;
    private RestMeta meta;
    private RestData data;

    public Rest(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    MultivaluedMapImpl createMultivalueMap(String paramName, String paramValue) {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add(paramName, UriComponent.encode((String)paramValue, (UriComponent.Type)UriComponent.Type.QUERY_PARAM));
        return queryParams;
    }

    private Object[] callRest(Object[] rowData) throws KettleException {
        if (this.meta.isUrlInField()) {
            this.data.realUrl = this.data.inputRowMeta.getString(rowData, this.data.indexOfUrlField);
        }
        if (this.meta.isDynamicMethod()) {
            this.data.method = this.data.inputRowMeta.getString(rowData, this.data.indexOfMethod);
            if (Utils.isEmpty((CharSequence)this.data.method)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Error.MethodMissing", (String[])new String[0]));
            }
        }
        WebResource webResource = null;
        ApacheHttpClient4 client = null;
        Object[] newRow = null;
        if (rowData != null) {
            newRow = (Object[])rowData.clone();
        }
        try {
            String body;
            ClientResponse response;
            long startTime;
            block43: {
                String value;
                int i;
                UriBuilder builder;
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Rest.Log.ConnectingToURL", (String[])new String[]{this.data.realUrl}));
                }
                client = ApacheHttpClient4.create((ClientConfig)this.data.config);
                if (this.data.basicAuthentication != null) {
                    client.addFilter((ClientFilter)this.data.basicAuthentication);
                }
                webResource = client.resource(this.data.realUrl);
                startTime = System.currentTimeMillis();
                if (this.data.useMatrixParams) {
                    builder = webResource.getUriBuilder();
                    for (i = 0; i < this.data.nrMatrixParams; ++i) {
                        value = this.data.inputRowMeta.getString(rowData, this.data.indexOfMatrixParamFields[i]);
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"Rest.Log.matrixParameterValue", (String[])new String[]{this.data.matrixParamNames[i], value}));
                        }
                        builder = builder.matrixParam(this.data.matrixParamNames[i], new Object[]{UriComponent.encode((String)value, (UriComponent.Type)UriComponent.Type.QUERY_PARAM)});
                    }
                    webResource = client.resource(builder.build(new Object[0]));
                }
                if (this.data.useParams) {
                    for (int i2 = 0; i2 < this.data.nrParams; ++i2) {
                        String value2 = this.data.inputRowMeta.getString(rowData, this.data.indexOfParamFields[i2]);
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"Rest.Log.queryParameterValue", (String[])new String[]{this.data.paramNames[i2], value2}));
                        }
                        webResource = webResource.queryParams((MultivaluedMap)this.createMultivalueMap(this.data.paramNames[i2], value2));
                    }
                }
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"Rest.Log.ConnectingToURL", (Object[])new Object[]{webResource.getURI()}));
                }
                builder = webResource.getRequestBuilder();
                if (this.data.useHeaders) {
                    for (i = 0; i < this.data.nrheader; ++i) {
                        value = this.data.inputRowMeta.getString(rowData, this.data.indexOfHeaderFields[i]);
                        builder = (WebResource.Builder)builder.header(this.data.headerNames[i], (Object)value);
                        if (!this.isDebug()) continue;
                        this.logDebug(BaseMessages.getString(PKG, (String)"Rest.Log.HeaderValue", (String[])new String[]{this.data.headerNames[i], value}));
                    }
                }
                response = null;
                String entityString = null;
                if (this.data.useBody) {
                    entityString = Const.NVL((String)this.data.inputRowMeta.getString(rowData, this.data.indexOfBodyField), null);
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"Rest.Log.BodyValue", (String[])new String[]{entityString}));
                    }
                }
                try {
                    if (this.data.method.equals("GET")) {
                        response = (ClientResponse)builder.get(ClientResponse.class);
                        break block43;
                    }
                    if (this.data.method.equals("POST")) {
                        response = (ClientResponse)((WebResource.Builder)builder.type(this.data.mediaType)).post(ClientResponse.class, (Object)entityString);
                        break block43;
                    }
                    if (this.data.method.equals("PUT")) {
                        response = (ClientResponse)((WebResource.Builder)builder.type(this.data.mediaType)).put(ClientResponse.class, (Object)entityString);
                        break block43;
                    }
                    if (this.data.method.equals("DELETE")) {
                        response = (ClientResponse)((WebResource.Builder)builder.type(this.data.mediaType)).delete(ClientResponse.class, (Object)entityString);
                        break block43;
                    }
                    if (this.data.method.equals("HEAD")) {
                        response = builder.head();
                        break block43;
                    }
                    if (this.data.method.equals("OPTIONS")) {
                        response = (ClientResponse)builder.options(ClientResponse.class);
                        break block43;
                    }
                    if (this.data.method.equals("PATCH")) {
                        response = (ClientResponse)((WebResource.Builder)builder.type(this.data.mediaType)).method("PATCH", ClientResponse.class, (Object)entityString);
                        break block43;
                    }
                    throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Error.UnknownMethod", (String[])new String[]{this.data.method}));
                }
                catch (UniformInterfaceException u) {
                    response = u.getResponse();
                }
            }
            long responseTime = System.currentTimeMillis() - startTime;
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"Rest.Log.ResponseTime", (String[])new String[]{String.valueOf(responseTime), this.data.realUrl}));
            }
            int status = response.getStatus();
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"Rest.Log.ResponseCode", (String[])new String[]{"" + status}));
            }
            String headerString = null;
            try {
                body = (String)response.getEntity(String.class);
            }
            catch (UniformInterfaceException ex) {
                body = "";
            }
            MultivaluedMap<String, String> headers = this.searchForHeaders(response);
            JSONObject json = new JSONObject();
            for (Map.Entry entry : headers.entrySet()) {
                String name = (String)entry.getKey();
                List value = (List)entry.getValue();
                if (value.size() > 1) {
                    json.put((Object)name, (Object)value);
                    continue;
                }
                json.put((Object)name, value.get(0));
            }
            headerString = json.toJSONString();
            int returnFieldsOffset = this.data.inputRowMeta.size();
            if (!Utils.isEmpty((CharSequence)this.data.resultFieldName)) {
                newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)body);
                ++returnFieldsOffset;
            }
            if (!Utils.isEmpty((CharSequence)this.data.resultCodeFieldName)) {
                newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)new Long(status));
                ++returnFieldsOffset;
            }
            if (!Utils.isEmpty((CharSequence)this.data.resultResponseFieldName)) {
                newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)new Long(responseTime));
                ++returnFieldsOffset;
            }
            if (!Utils.isEmpty((CharSequence)this.data.resultHeaderFieldName)) {
                newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)headerString);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Error.CanNotReadURL", (String[])new String[]{this.data.realUrl}), (Throwable)e);
        }
        finally {
            if (webResource != null) {
                webResource = null;
            }
            if (client != null) {
                client.destroy();
            }
        }
        return newRow;
    }

    private void setConfig() throws KettleException {
        if (this.data.config == null) {
            this.data.config = new DefaultApacheHttpClient4Config();
            if (!Utils.isEmpty((CharSequence)this.data.realProxyHost)) {
                this.data.config.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyURI", "http://" + this.data.realProxyHost + ":" + this.data.realProxyPort);
                if (!Utils.isEmpty((CharSequence)this.data.realHttpLogin) && !Utils.isEmpty((CharSequence)this.data.realHttpPassword)) {
                    AuthScope authScope = new AuthScope(this.data.realProxyHost, this.data.realProxyPort);
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.data.realHttpLogin, this.data.realHttpPassword);
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(authScope, (Credentials)credentials);
                    this.data.config.getProperties().put("com.sun.jersey.impl.client.httpclient.credentialsProvider", credentialsProvider);
                }
            } else if (!Utils.isEmpty((CharSequence)this.data.realHttpLogin)) {
                this.data.basicAuthentication = new HTTPBasicAuthFilter(this.data.realHttpLogin, this.data.realHttpPassword);
            }
            if (this.meta.isPreemptive()) {
                this.data.config.getProperties().put("com.sun.jersey.impl.client.httpclient.preemptiveBasicAuthentication", true);
            }
            if (!Utils.isEmpty((CharSequence)this.data.trustStoreFile)) {
                try (FileInputStream trustFileStream = new FileInputStream(this.data.trustStoreFile);){
                    KeyStore trustStore = KeyStore.getInstance("JKS");
                    trustStore.load(trustFileStream, this.data.trustStorePassword.toCharArray());
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                    tmf.init(trustStore);
                    SSLContext ctx = SSLContext.getInstance("SSL");
                    ctx.init(null, tmf.getTrustManagers(), null);
                    HostnameVerifier hv = new HostnameVerifier(){

                        @Override
                        public boolean verify(String hostname, SSLSession session) {
                            if (Rest.this.isDebug()) {
                                Rest.this.logDebug("Warning: URL Host: " + hostname + " vs. " + session.getPeerHost());
                            }
                            return true;
                        }
                    };
                    this.data.config.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(hv, ctx));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Error.NoSuchAlgorithm", (String[])new String[0]), (Throwable)e);
                }
                catch (KeyStoreException e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Error.KeyStoreException", (String[])new String[0]), (Throwable)e);
                }
                catch (CertificateException e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Error.CertificateException", (String[])new String[0]), (Throwable)e);
                }
                catch (FileNotFoundException e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Error.FileNotFound", (String[])new String[]{this.data.trustStoreFile}), (Throwable)e);
                }
                catch (IOException e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Error.IOException", (String[])new String[0]), (Throwable)e);
                }
                catch (KeyManagementException e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Error.KeyManagementException", (String[])new String[0]), (Throwable)e);
                }
            }
        }
    }

    protected MultivaluedMap<String, String> searchForHeaders(ClientResponse response) {
        return response.getHeaders();
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block26: {
            this.meta = (RestMeta)smi;
            this.data = (RestData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                String field;
                int nrargs;
                this.first = false;
                this.data.inputRowMeta = this.getInputRowMeta();
                this.data.outputRowMeta = this.data.inputRowMeta.clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                if (this.meta.isUrlInField()) {
                    if (Utils.isEmpty((CharSequence)this.meta.getUrlField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"Rest.Log.NoField", (String[])new String[0]));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Log.NoField", (String[])new String[0]));
                    }
                    if (this.data.indexOfUrlField < 0) {
                        String realUrlfieldName = this.environmentSubstitute(this.meta.getUrlField());
                        this.data.indexOfUrlField = this.data.inputRowMeta.indexOfValue(realUrlfieldName);
                        if (this.data.indexOfUrlField < 0) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Exception.ErrorFindingField", (String[])new String[]{realUrlfieldName}));
                        }
                    }
                } else {
                    this.data.realUrl = this.environmentSubstitute(this.meta.getUrl());
                }
                if (this.meta.isDynamicMethod()) {
                    String field2 = this.environmentSubstitute(this.meta.getMethodFieldName());
                    if (Utils.isEmpty((CharSequence)field2)) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Exception.MethodFieldMissing", (String[])new String[0]));
                    }
                    this.data.indexOfMethod = this.data.inputRowMeta.indexOfValue(field2);
                    if (this.data.indexOfMethod < 0) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Exception.ErrorFindingField", (String[])new String[]{field2}));
                    }
                }
                int n = nrargs = this.meta.getHeaderName() == null ? 0 : this.meta.getHeaderName().length;
                if (nrargs > 0) {
                    this.data.nrheader = nrargs;
                    this.data.indexOfHeaderFields = new int[nrargs];
                    this.data.headerNames = new String[nrargs];
                    for (int i = 0; i < nrargs; ++i) {
                        this.data.headerNames[i] = this.environmentSubstitute(this.meta.getHeaderName()[i]);
                        String field3 = this.environmentSubstitute(this.meta.getHeaderField()[i]);
                        if (Utils.isEmpty((CharSequence)field3)) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Exception.HeaderFieldEmpty", (String[])new String[0]));
                        }
                        this.data.indexOfHeaderFields[i] = this.data.inputRowMeta.indexOfValue(field3);
                        if (this.data.indexOfHeaderFields[i] >= 0) continue;
                        throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Exception.ErrorFindingField", (String[])new String[]{field3}));
                    }
                    this.data.useHeaders = true;
                }
                if (RestMeta.isActiveParameters(this.meta.getMethod())) {
                    int nrmatrixparams;
                    int nrparams;
                    int n2 = nrparams = this.meta.getParameterField() == null ? 0 : this.meta.getParameterField().length;
                    if (nrparams > 0) {
                        this.data.nrParams = nrparams;
                        this.data.paramNames = new String[nrparams];
                        this.data.indexOfParamFields = new int[nrparams];
                        for (int i = 0; i < nrparams; ++i) {
                            this.data.paramNames[i] = this.environmentSubstitute(this.meta.getParameterName()[i]);
                            String field4 = this.environmentSubstitute(this.meta.getParameterField()[i]);
                            if (Utils.isEmpty((CharSequence)field4)) {
                                throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Exception.ParamFieldEmpty", (String[])new String[0]));
                            }
                            this.data.indexOfParamFields[i] = this.data.inputRowMeta.indexOfValue(field4);
                            if (this.data.indexOfParamFields[i] >= 0) continue;
                            throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Exception.ErrorFindingField", (String[])new String[]{field4}));
                        }
                        this.data.useParams = true;
                    }
                    int n3 = nrmatrixparams = this.meta.getMatrixParameterField() == null ? 0 : this.meta.getMatrixParameterField().length;
                    if (nrmatrixparams > 0) {
                        this.data.nrMatrixParams = nrmatrixparams;
                        this.data.matrixParamNames = new String[nrmatrixparams];
                        this.data.indexOfMatrixParamFields = new int[nrmatrixparams];
                        for (int i = 0; i < nrmatrixparams; ++i) {
                            this.data.matrixParamNames[i] = this.environmentSubstitute(this.meta.getMatrixParameterName()[i]);
                            String field5 = this.environmentSubstitute(this.meta.getMatrixParameterField()[i]);
                            if (Utils.isEmpty((CharSequence)field5)) {
                                throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Exception.MatrixParamFieldEmpty", (String[])new String[0]));
                            }
                            this.data.indexOfMatrixParamFields[i] = this.data.inputRowMeta.indexOfValue(field5);
                            if (this.data.indexOfMatrixParamFields[i] >= 0) continue;
                            throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Exception.ErrorFindingField", (String[])new String[]{field5}));
                        }
                        this.data.useMatrixParams = true;
                    }
                }
                if (RestMeta.isActiveBody(this.meta.getMethod()) && !Utils.isEmpty((CharSequence)(field = this.environmentSubstitute(this.meta.getBodyField())))) {
                    this.data.indexOfBodyField = this.data.inputRowMeta.indexOfValue(field);
                    if (this.data.indexOfBodyField < 0) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Exception.ErrorFindingField", (String[])new String[]{field}));
                    }
                    this.data.useBody = true;
                }
            }
            try {
                Object[] outputRowData = this.callRest(r);
                this.putRow(this.data.outputRowMeta, outputRowData);
                if (this.checkFeedback(this.getLinesRead()) && this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Rest.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"Rest.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.logError(Const.getStackTracker((Throwable)e));
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block26;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "Rest001");
            }
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RestMeta)smi;
        this.data = (RestData)sdi;
        if (super.init(smi, sdi)) {
            this.data.resultFieldName = this.environmentSubstitute(this.meta.getFieldName());
            this.data.resultCodeFieldName = this.environmentSubstitute(this.meta.getResultCodeFieldName());
            this.data.resultResponseFieldName = this.environmentSubstitute(this.meta.getResponseTimeFieldName());
            this.data.resultHeaderFieldName = this.environmentSubstitute(this.meta.getResponseHeaderFieldName());
            this.data.realProxyHost = this.environmentSubstitute(this.meta.getProxyHost());
            this.data.realProxyPort = Const.toInt((String)this.environmentSubstitute(this.meta.getProxyPort()), (int)8080);
            this.data.realHttpLogin = this.environmentSubstitute(this.meta.getHttpLogin());
            this.data.realHttpPassword = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.meta.getHttpPassword()));
            if (!this.meta.isDynamicMethod()) {
                this.data.method = this.environmentSubstitute(this.meta.getMethod());
                if (Utils.isEmpty((CharSequence)this.data.method)) {
                    this.logError(BaseMessages.getString(PKG, (String)"Rest.Error.MethodMissing", (String[])new String[0]));
                    return false;
                }
            }
            this.data.trustStoreFile = this.environmentSubstitute(this.meta.getTrustStoreFile());
            this.data.trustStorePassword = this.environmentSubstitute(this.meta.getTrustStorePassword());
            String applicationType = Const.NVL((String)this.meta.getApplicationType(), (String)"");
            this.data.mediaType = applicationType.equals("XML") ? MediaType.APPLICATION_XML_TYPE : (applicationType.equals("JSON") ? MediaType.APPLICATION_JSON_TYPE : (applicationType.equals("OCTET STREAM") ? MediaType.APPLICATION_OCTET_STREAM_TYPE : (applicationType.equals("XHTML") ? MediaType.APPLICATION_XHTML_XML_TYPE : (applicationType.equals("FORM URLENCODED") ? MediaType.APPLICATION_FORM_URLENCODED_TYPE : (applicationType.equals("ATOM XML") ? MediaType.APPLICATION_ATOM_XML_TYPE : (applicationType.equals("SVG XML") ? MediaType.APPLICATION_SVG_XML_TYPE : (applicationType.equals("TEXT XML") ? MediaType.TEXT_XML_TYPE : MediaType.TEXT_PLAIN_TYPE)))))));
            try {
                this.setConfig();
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"Rest.Error.Config", (String[])new String[0]), e);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RestMeta)smi;
        this.data = (RestData)sdi;
        this.data.config = null;
        this.data.headerNames = null;
        this.data.indexOfHeaderFields = null;
        this.data.paramNames = null;
        super.dispose(smi, sdi);
    }
}

