/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.pentahoreporting;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.ReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public abstract class ReportExportTask
implements Runnable {
    protected static final Log logger = LogFactory.getLog(ReportExportTask.class);
    public static final String BASE_RESOURCE_CLASS = "org.pentaho.di.trans.steps.pentahoreporting.messages.messages";
    private Messages messages;
    protected MasterReport report;
    protected StatusListener statusListener;
    protected Boolean createParentFolder;
    protected String targetPath;
    protected FileObject targetFile;

    public ReportExportTask(MasterReport report, SwingGuiContext swingGuiContext, String targetPath, Boolean createParentFolder) {
        if (report == null) {
            throw new NullPointerException("ReportExportTask(..): Report parameter cannot be null");
        }
        this.report = report;
        this.statusListener = swingGuiContext.getStatusListener();
        this.messages = new Messages(swingGuiContext.getLocale(), BASE_RESOURCE_CLASS, ObjectUtilities.getClassLoader(ReportExportTask.class));
        this.targetPath = targetPath;
        this.createParentFolder = createParentFolder;
    }

    @Override
    public void run() {
        try {
            this.targetFile = KettleVFS.getFileObject((String)this.targetPath);
            if (this.targetFile.exists() && !this.targetFile.delete()) {
                throw new ReportProcessingException(this.messages.getErrorString("ReportExportTask.ERROR_0001_TARGET_EXISTS", new String[0]));
            }
            if (this.createParentFolder.booleanValue()) {
                this.targetFile.getParent().createFolder();
            }
            this.execute();
        }
        catch (Exception ex) {
            this.statusListener.setStatus(StatusType.ERROR, this.messages.getString("ReportExportTask.USER_EXPORT_FAILED"), (Throwable)ex);
            logger.error((Object)"Failed");
        }
    }

    protected void execute() throws Exception {
        BufferedOutputStream fout = null;
        ReportProcessor reportProcessor = null;
        try {
            fout = new BufferedOutputStream(this.targetFile.getContent().getOutputStream());
            reportProcessor = this.createReportProcessor(fout);
            reportProcessor.processReport();
            this.statusListener.setStatus(StatusType.INFORMATION, this.messages.getString("ReportExportTask.USER_EXPORT_COMPLETE"), null);
            reportProcessor.close();
            try {
                fout.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception ex) {
            try {
                reportProcessor.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                fout.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.targetFile.exists() && !this.targetFile.delete()) {
                    logger.warn((Object)("Unable to delete incomplete export: " + this.targetFile));
                }
            }
            catch (Exception ex2) {
                logger.warn((Object)("Unable to delete incomplete export: " + this.targetFile));
            }
            throw ex;
        }
    }

    protected abstract ReportProcessor createReportProcessor(OutputStream var1) throws Exception;

    protected String getSuffix(String filename) {
        String suffix = IOUtils.getInstance().getFileExtension(filename);
        if (suffix.length() == 0) {
            return "";
        }
        return suffix.substring(1);
    }
}

