/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.csvinput;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleConversionException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.csvinput.CsvInputData;
import org.pentaho.di.trans.steps.csvinput.CsvInputMeta;
import org.pentaho.di.trans.steps.csvinput.EmptyPatternMatcher;
import org.pentaho.di.trans.steps.csvinput.FieldsMapping;
import org.pentaho.di.trans.steps.csvinput.MultiByteBigCrLfMatcher;
import org.pentaho.di.trans.steps.csvinput.MultiByteLittleCrLfMatcher;
import org.pentaho.di.trans.steps.csvinput.MultiBytePatternMatcher;
import org.pentaho.di.trans.steps.csvinput.NamedFieldsMapping;
import org.pentaho.di.trans.steps.csvinput.SingleByteCrLfMatcher;
import org.pentaho.di.trans.steps.csvinput.SingleBytePatternMatcher;
import org.pentaho.di.trans.steps.csvinput.UnnamedFieldsMapping;
import org.pentaho.di.trans.steps.fileinput.text.BOMDetector;
import org.pentaho.di.trans.steps.textfileinput.EncodingType;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;

public class CsvInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = CsvInput.class;
    private CsvInputMeta meta;
    private CsvInputData data;

    public CsvInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (CsvInputMeta)smi;
        this.data = (CsvInputData)sdi;
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            if (this.data.filenames == null) {
                this.getFilenamesFromPreviousSteps();
            }
            this.data.parallel = this.meta.isRunningInParallel() && this.data.totalNumberOfSteps > 1;
            this.data.convertRowMeta = this.data.outputRowMeta.clone();
            for (ValueMetaInterface valueMeta : this.data.convertRowMeta.getValueMetaList()) {
                valueMeta.setStorageType(1);
            }
            this.data.filenameFieldIndex = -1;
            if (!Utils.isEmpty((CharSequence)this.meta.getFilenameField()) && this.meta.isIncludingFilename()) {
                this.data.filenameFieldIndex = this.meta.getInputFields().length;
            }
            this.data.rownumFieldIndex = -1;
            if (!Utils.isEmpty((CharSequence)this.meta.getRowNumField())) {
                this.data.rownumFieldIndex = this.meta.getInputFields().length;
                if (this.data.filenameFieldIndex >= 0) {
                    ++this.data.rownumFieldIndex;
                }
            }
            if (this.data.parallel) {
                this.prepareToRunInParallel();
            }
            if (!this.openNextFile()) {
                this.setOutputDone();
                return false;
            }
        }
        if (this.data.parallel && this.data.totalBytesRead >= this.data.blockToRead) {
            this.setOutputDone();
            return false;
        }
        try {
            Object[] outputRowData = this.readOneRow(false, false);
            if (outputRowData == null) {
                if (this.openNextFile()) {
                    return true;
                }
                this.setOutputDone();
                return false;
            }
            this.putRow(this.data.outputRowMeta, outputRowData);
            if (this.checkFeedback(this.getLinesInput()) && this.log.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"CsvInput.Log.LineNumber", (String[])new String[]{Long.toString(this.getLinesInput())}));
            }
        }
        catch (KettleConversionException e) {
            if (this.getStepMeta().isDoingErrorHandling()) {
                StringBuilder errorDescriptions = new StringBuilder(100);
                StringBuilder errorFields = new StringBuilder(50);
                for (int i = 0; i < e.getCauses().size(); ++i) {
                    if (i > 0) {
                        errorDescriptions.append(", ");
                        errorFields.append(", ");
                    }
                    errorDescriptions.append(((Exception)e.getCauses().get(i)).getMessage());
                    errorFields.append(((ValueMetaInterface)e.getFields().get(i)).toStringMeta());
                }
                this.putError(this.data.outputRowMeta, e.getRowData(), e.getCauses().size(), errorDescriptions.toString(), errorFields.toString(), "CSVINPUT001");
            }
            throw new KettleException(e.getMessage(), (Throwable)e.getCauses().get(0));
        }
        return true;
    }

    private void prepareToRunInParallel() throws KettleException {
        try {
            for (String filename : this.data.filenames) {
                long size = KettleVFS.getFileObject((String)filename, (VariableSpace)this.getTransMeta()).getContent().getSize();
                this.data.fileSizes.add(size);
                this.data.totalFileSize += size;
            }
            this.data.blockToRead = Math.round((double)this.data.totalFileSize / (double)this.data.totalNumberOfSteps);
            this.data.startPosition = this.data.blockToRead * (long)this.data.stepNumber;
            this.data.endPosition = this.data.startPosition + this.data.blockToRead;
            long totalFileSize = 0L;
            for (int i = 0; i < this.data.fileSizes.size(); ++i) {
                long size = this.data.fileSizes.get(i);
                if (this.data.startPosition >= totalFileSize && this.data.startPosition < totalFileSize + size) {
                    this.data.filenr = i;
                    this.data.startFilenr = i;
                    if (this.data.startPosition == 0L) {
                        this.data.bytesToSkipInFirstFile = 0L;
                        break;
                    }
                    this.data.bytesToSkipInFirstFile = this.data.startPosition - totalFileSize;
                    break;
                }
                totalFileSize += size;
            }
            if (this.data.filenames.length > 0) {
                this.logBasic(BaseMessages.getString(PKG, (String)"CsvInput.Log.ParallelFileNrAndPositionFeedback", (String[])new String[]{this.data.filenames[this.data.filenr], Long.toString(this.data.fileSizes.get(this.data.filenr)), Long.toString(this.data.bytesToSkipInFirstFile), Long.toString(this.data.blockToRead)}));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"CsvInput.Exception.ErrorPreparingParallelRun", (String[])new String[0]), (Throwable)e);
        }
    }

    private void getFilenamesFromPreviousSteps() throws KettleException {
        ArrayList<String> filenames = new ArrayList<String>();
        boolean firstRow = true;
        int index = -1;
        Object[] row = this.getRow();
        while (row != null) {
            if (firstRow) {
                firstRow = false;
                String filenameField = this.environmentSubstitute(this.meta.getFilenameField());
                index = this.getInputRowMeta().indexOfValue(filenameField);
                if (index < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"CsvInput.Exception.FilenameFieldNotFound", (String[])new String[]{filenameField}));
                }
            }
            String filename = this.getInputRowMeta().getString(row, index);
            filenames.add(filename);
            row = this.getRow();
        }
        this.data.filenames = filenames.toArray(new String[filenames.size()]);
        this.logBasic(BaseMessages.getString(PKG, (String)"CsvInput.Log.ReadingFromNrFiles", (String[])new String[]{Integer.toString(this.data.filenames.length)}));
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        try {
            if (this.data.fc != null) {
                this.data.fc.close();
            }
        }
        catch (Exception e) {
            this.logError("Error closing file channel", e);
        }
        try {
            if (this.data.fis != null) {
                this.data.fis.close();
            }
        }
        catch (Exception e) {
            this.logError("Error closing file input stream", e);
        }
        super.dispose(smi, sdi);
    }

    private boolean openNextFile() throws KettleException {
        try {
            this.data.closeFile();
            if (this.data.filenr >= this.data.filenames.length) {
                return false;
            }
            this.data.fieldsMapping = this.createFieldMapping(this.data.filenames[this.data.filenr], this.meta);
            FileObject fileObject = KettleVFS.getFileObject((String)this.data.filenames[this.data.filenr], (VariableSpace)this.getTransMeta());
            if (!(fileObject instanceof LocalFile)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"CsvInput.Log.OnlyLocalFilesAreSupported", (String[])new String[0]));
            }
            if (this.meta.isLazyConversionActive()) {
                this.data.binaryFilename = this.data.filenames[this.data.filenr].getBytes();
            }
            BOMDetector bom = new BOMDetector(new BufferedInputStream(new FileInputStream(KettleVFS.getFilename((FileObject)fileObject))));
            this.data.fis = new FileInputStream(KettleVFS.getFilename((FileObject)fileObject));
            if (bom.bomExist()) {
                this.data.fis.skip(bom.getBomSize());
            }
            this.data.fc = this.data.fis.getChannel();
            this.data.bb = ByteBuffer.allocateDirect(this.data.preferredBufferSize);
            if (this.data.parallel && this.data.bytesToSkipInFirstFile > 0L) {
                this.data.fc.position(this.data.bytesToSkipInFirstFile);
                if (this.needToSkipRow()) {
                    while (!this.data.newLineFound()) {
                        this.data.moveEndBufferPointer();
                    }
                    this.data.moveEndBufferPointer();
                    if (this.data.newLineFound()) {
                        this.data.moveEndBufferPointer();
                    }
                }
                this.data.setStartBuffer(this.data.getEndBuffer());
            }
            if (this.meta.isAddResultFile()) {
                ResultFile resultFile = new ResultFile(0, fileObject, this.getTransMeta().getName(), this.toString());
                resultFile.setComment("File was read by a Csv input step");
                this.addResultFile(resultFile);
            }
            ++this.data.filenr;
            if (this.meta.isHeaderPresent() && (!this.data.parallel || this.data.bytesToSkipInFirstFile <= 0L)) {
                this.readOneRow(true, false);
                this.logBasic(BaseMessages.getString(PKG, (String)"CsvInput.Log.HeaderRowSkipped", (String[])new String[]{this.data.filenames[this.data.filenr - 1]}));
            }
            this.data.rowNumber = 1L;
            this.data.bytesToSkipInFirstFile = -1L;
            return true;
        }
        catch (KettleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    FieldsMapping createFieldMapping(String fileName, CsvInputMeta csvInputMeta) throws KettleException {
        FieldsMapping mapping = null;
        if (csvInputMeta.isHeaderPresent()) {
            String[] fieldNames = this.readFieldNamesFromFile(fileName, csvInputMeta);
            mapping = NamedFieldsMapping.mapping(fieldNames, CsvInput.fieldNames(csvInputMeta));
        } else {
            int fieldsCount = csvInputMeta.getInputFields() == null ? 0 : csvInputMeta.getInputFields().length;
            mapping = UnnamedFieldsMapping.mapping(fieldsCount);
        }
        return mapping;
    }

    /*
     * Exception decompiling
     */
    String[] readFieldNamesFromFile(String fileName, CsvInputMeta csvInputMeta) throws KettleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static String[] fieldNames(CsvInputMeta csvInputMeta) {
        TextFileInputField[] fields = csvInputMeta.getInputFields();
        String[] fieldNames = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldNames[i] = EncodingType.removeBOMIfPresent(fields[i].getName());
        }
        return fieldNames;
    }

    static void trimFieldNames(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = strings[i].trim();
        }
    }

    static void removeEnclosure(String[] fields, String enclosure) {
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].startsWith(enclosure) || !fields[i].endsWith(enclosure) || fields[i].length() <= 1) continue;
            fields[i] = fields[i].substring(1, fields[i].length() - 1);
        }
    }

    private boolean needToSkipRow() {
        try {
            this.data.fc.position(this.data.fc.position() - 1L);
            this.data.resizeBufferIfNeeded();
            if (this.data.newLineFound()) {
                this.data.moveEndBufferPointer(false);
                boolean bl = this.data.newLineFound();
                return bl;
            }
            this.data.moveEndBufferPointer(false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.data.fc.position(this.data.fc.position() + 1L);
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    private Object[] readOneRow(boolean skipRow, boolean ignoreEnclosures) throws KettleException {
        try {
            Object[] outputRowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            int outputIndex = 0;
            boolean newLineFound = false;
            boolean endOfBuffer = false;
            ArrayList<KettleValueException> conversionExceptions = null;
            ArrayList<ValueMetaInterface> exceptionFields = null;
            while (!newLineFound && outputIndex < this.data.fieldsMapping.size()) {
                int currentFieldIndex;
                int actualFieldIndex;
                if (this.data.resizeBufferIfNeeded()) {
                    if (outputRowData != null && outputIndex > 0) {
                        if (this.meta.isIncludingFilename() && !Utils.isEmpty((CharSequence)this.meta.getFilenameField())) {
                            outputRowData[this.data.filenameFieldIndex] = this.meta.isLazyConversionActive() ? (Object)this.data.binaryFilename : this.data.filenames[this.data.filenr - 1];
                        }
                        if (this.data.isAddingRowNumber) {
                            outputRowData[this.data.rownumFieldIndex] = this.data.rowNumber++;
                        }
                        this.incrementLinesInput();
                        return outputRowData;
                    }
                    return null;
                }
                boolean delimiterFound = false;
                boolean enclosureFound = false;
                boolean doubleLineEnd = false;
                int escapedEnclosureFound = 0;
                boolean ignoreEnclosuresInField = ignoreEnclosures;
                while (!(delimiterFound || newLineFound || endOfBuffer)) {
                    if (this.data.delimiterFound()) {
                        delimiterFound = true;
                        continue;
                    }
                    if ((!this.meta.isNewlinePossibleInFields() || outputIndex == this.data.fieldsMapping.size() - 1) && this.data.newLineFound()) {
                        newLineFound = true;
                        for (int i = 0; i < this.data.encodingType.getLength(); ++i) {
                            this.data.moveEndBufferPointer();
                        }
                        if (!this.data.newLineFound()) continue;
                        doubleLineEnd = true;
                        continue;
                    }
                    if (this.data.enclosureFound() && !ignoreEnclosuresInField) {
                        int enclosurePosition = this.data.getEndBuffer();
                        int fieldFirstBytePosition = this.data.getStartBuffer();
                        if (fieldFirstBytePosition == enclosurePosition) {
                            boolean keepGoing;
                            enclosureFound = true;
                            do {
                                if (this.data.moveEndBufferPointer()) {
                                    enclosureFound = false;
                                    break;
                                }
                                boolean bl = keepGoing = !this.data.enclosureFound();
                                if (keepGoing) continue;
                                if (!this.data.endOfBuffer() && this.data.moveEndBufferPointer()) break;
                                if (this.data.enclosure.length > 1) {
                                    this.data.moveEndBufferPointer();
                                }
                                if (!(keepGoing = this.data.enclosureFound())) continue;
                                ++escapedEnclosureFound;
                            } while (keepGoing);
                            if (!this.data.endOfBuffer()) continue;
                            endOfBuffer = true;
                            break;
                        }
                        ignoreEnclosuresInField = true;
                        continue;
                    }
                    if (!this.data.moveEndBufferPointer()) continue;
                    endOfBuffer = true;
                    break;
                }
                byte[] field = this.data.getField(delimiterFound, enclosureFound, newLineFound, endOfBuffer);
                if (escapedEnclosureFound > 0) {
                    if (this.log.isRowLevel()) {
                        this.logRowlevel("Escaped enclosures found in " + new String(field));
                    }
                    field = this.data.removeEscapedEnclosures(field, escapedEnclosureFound);
                }
                if ((actualFieldIndex = this.data.fieldsMapping.fieldMetaIndex(currentFieldIndex = outputIndex++)) != -1) {
                    if (!skipRow) {
                        if (this.meta.isLazyConversionActive()) {
                            outputRowData[actualFieldIndex] = field;
                        } else {
                            ValueMetaInterface sourceValueMeta = this.data.convertRowMeta.getValueMeta(actualFieldIndex);
                            try {
                                outputRowData[actualFieldIndex] = sourceValueMeta.convertBinaryStringToNativeType(field);
                            }
                            catch (KettleValueException e) {
                                outputRowData[actualFieldIndex] = null;
                                if (conversionExceptions == null) {
                                    conversionExceptions = new ArrayList<KettleValueException>();
                                    exceptionFields = new ArrayList<ValueMetaInterface>();
                                }
                                conversionExceptions.add(e);
                                exceptionFields.add(sourceValueMeta);
                            }
                        }
                    } else {
                        outputRowData[actualFieldIndex] = null;
                    }
                }
                if (!newLineFound && outputIndex < this.data.fieldsMapping.size() || newLineFound && doubleLineEnd) {
                    for (int i = 0; !this.data.newLineFound() && i < this.data.delimiter.length; ++i) {
                        this.data.moveEndBufferPointer();
                    }
                    if (this.data.newLineFound() && outputIndex >= this.data.fieldsMapping.size()) {
                        this.data.moveEndBufferPointer();
                    }
                    if (doubleLineEnd && this.data.encodingType.getLength() > 1) {
                        this.data.moveEndBufferPointer();
                    }
                }
                this.data.setStartBuffer(this.data.getEndBuffer());
            }
            if (!newLineFound && !this.data.resizeBufferIfNeeded()) {
                do {
                    this.data.moveEndBufferPointer();
                } while (!this.data.resizeBufferIfNeeded() && !this.data.newLineFound());
                if (!this.data.resizeBufferIfNeeded()) {
                    while (this.data.newLineFound()) {
                        this.data.moveEndBufferPointer();
                        if (!this.data.resizeBufferIfNeeded()) continue;
                    }
                }
                this.data.setStartBuffer(this.data.getEndBuffer());
            }
            if (this.meta.isIncludingFilename() && !Utils.isEmpty((CharSequence)this.meta.getFilenameField())) {
                outputRowData[this.data.filenameFieldIndex] = this.meta.isLazyConversionActive() ? (Object)this.data.binaryFilename : this.data.filenames[this.data.filenr - 1];
            }
            if (this.data.isAddingRowNumber) {
                outputRowData[this.data.rownumFieldIndex] = this.data.rowNumber++;
            }
            if (!ignoreEnclosures) {
                this.incrementLinesInput();
            }
            if (conversionExceptions != null && conversionExceptions.size() > 0) {
                throw new KettleConversionException("There were " + conversionExceptions.size() + " conversion errors on line " + this.getLinesInput(), (List)conversionExceptions, exceptionFields, outputRowData);
            }
            return outputRowData;
        }
        catch (KettleConversionException e) {
            throw e;
        }
        catch (IOException e) {
            throw new KettleFileException("Exception reading line using NIO", (Throwable)e);
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CsvInputMeta)smi;
        this.data = (CsvInputData)sdi;
        if (super.init(smi, sdi)) {
            String realEncoding = this.environmentSubstitute(this.meta.getEncoding());
            this.data.preferredBufferSize = Integer.parseInt(this.environmentSubstitute(this.meta.getBufferSize()));
            if (this.getTransMeta().findNrPrevSteps(this.getStepMeta()) == 0) {
                String filename = this.environmentSubstitute(this.meta.getFilename());
                if (Utils.isEmpty((CharSequence)filename)) {
                    this.logError(BaseMessages.getString(PKG, (String)"CsvInput.MissingFilename.Message", (String[])new String[0]));
                    return false;
                }
                this.data.filenames = new String[]{filename};
            } else {
                this.data.filenames = null;
                this.data.filenr = 0;
            }
            this.data.totalBytesRead = 0L;
            this.data.encodingType = EncodingType.guessEncodingType(realEncoding);
            try {
                this.data.delimiter = this.data.encodingType.getBytes(this.environmentSubstitute(this.meta.getDelimiter()), realEncoding);
                this.data.enclosure = (byte[])(Utils.isEmpty((CharSequence)this.meta.getEnclosure()) ? null : this.data.encodingType.getBytes(this.environmentSubstitute(this.meta.getEnclosure()), realEncoding));
            }
            catch (UnsupportedEncodingException e) {
                this.logError(BaseMessages.getString(PKG, (String)"CsvInput.BadEncoding.Message", (String[])new String[0]), e);
                return false;
            }
            this.data.isAddingRowNumber = !Utils.isEmpty((CharSequence)this.meta.getRowNumField());
            this.data.stopReading = false;
            if (this.meta.isRunningInParallel()) {
                this.data.stepNumber = this.getUniqueStepNrAcrossSlaves();
                this.data.totalNumberOfSteps = this.getUniqueStepCountAcrossSlaves();
                this.data.fileSizes = new ArrayList<Long>();
                this.data.totalFileSize = 0L;
            }
            this.data.delimiterMatcher = this.data.delimiter.length == 1 ? new SingleBytePatternMatcher() : new MultiBytePatternMatcher();
            this.data.enclosureMatcher = this.data.enclosure == null ? new EmptyPatternMatcher() : (this.data.enclosure.length == 1 ? new SingleBytePatternMatcher() : new MultiBytePatternMatcher());
            switch (this.data.encodingType) {
                case DOUBLE_BIG_ENDIAN: {
                    this.data.crLfMatcher = new MultiByteBigCrLfMatcher();
                    break;
                }
                case DOUBLE_LITTLE_ENDIAN: {
                    this.data.crLfMatcher = new MultiByteLittleCrLfMatcher();
                    break;
                }
                default: {
                    this.data.crLfMatcher = new SingleByteCrLfMatcher();
                }
            }
            return true;
        }
        return false;
    }

    public static String[] guessStringsFromLine(LogChannelInterface log, String line, String delimiter, String enclosure, String escapeCharacter) throws KettleException {
        ArrayList<String> strings = new ArrayList<String>();
        try {
            int len_esc;
            if (line == null) {
                return null;
            }
            int pos = 0;
            int length = line.length();
            boolean dencl = false;
            int len_encl = enclosure == null ? 0 : enclosure.length();
            int n = len_esc = escapeCharacter == null ? 0 : escapeCharacter.length();
            while (pos < length) {
                String pol;
                int next;
                boolean encl_found;
                int from = pos;
                boolean contains_escaped_enclosures = false;
                boolean contains_escaped_separators = false;
                if (len_encl > 0 && line.substring(from, from + len_encl).equalsIgnoreCase(enclosure)) {
                    String strnext;
                    if (log.isRowLevel()) {
                        log.logRowlevel(BaseMessages.getString(PKG, (String)"CsvInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"CsvInput.Log.ConvertLineToRow", (String[])new String[]{line.substring(from, from + len_encl)})});
                    }
                    encl_found = true;
                    int p = from + len_encl;
                    boolean is_enclosure = len_encl > 0 && p + len_encl < length && line.substring(p, p + len_encl).equalsIgnoreCase(enclosure);
                    boolean is_escape = len_esc > 0 && p + len_esc < length && line.substring(p, p + len_esc).equalsIgnoreCase(escapeCharacter);
                    boolean enclosure_after = false;
                    if ((is_enclosure || is_escape) && p < length - 1 && (strnext = line.substring(p + len_encl, p + 2 * len_encl)).equalsIgnoreCase(enclosure)) {
                        ++p;
                        enclosure_after = true;
                        dencl = true;
                        if (is_escape) {
                            contains_escaped_enclosures = true;
                        }
                    }
                    while ((!is_enclosure || enclosure_after) && p < line.length()) {
                        enclosure_after = false;
                        is_enclosure = len_encl > 0 && ++p + len_encl < length && line.substring(p, p + len_encl).equals(enclosure);
                        boolean bl = is_escape = len_esc > 0 && p + len_esc < length && line.substring(p, p + len_esc).equals(escapeCharacter);
                        if (!is_enclosure && !is_escape || p >= length - 1 || !(strnext = line.substring(p + len_encl, p + 2 * len_encl)).equals(enclosure)) continue;
                        ++p;
                        enclosure_after = true;
                        dencl = true;
                        if (!is_escape) continue;
                        contains_escaped_enclosures = true;
                    }
                    next = p >= length ? p : p + len_encl;
                    if (log.isRowLevel()) {
                        log.logRowlevel(BaseMessages.getString(PKG, (String)"CsvInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"CsvInput.Log.EndOfEnclosure", (String[])new String[]{"" + p})});
                    }
                } else {
                    encl_found = false;
                    boolean found = false;
                    int startpoint = from;
                    do {
                        next = line.indexOf(delimiter, startpoint);
                        if (len_esc > 0 && next - len_esc > 0) {
                            String before = line.substring(next - len_esc, next);
                            if (escapeCharacter != null && escapeCharacter.equals(before)) {
                                startpoint = next + 1;
                                contains_escaped_separators = true;
                                continue;
                            }
                            found = true;
                            continue;
                        }
                        found = true;
                    } while (!found && next >= 0);
                }
                if (next == -1) {
                    next = length;
                }
                if (encl_found) {
                    pol = line.substring(from + len_encl, next - len_encl);
                    if (log.isRowLevel()) {
                        log.logRowlevel(BaseMessages.getString(PKG, (String)"CsvInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"CsvInput.Log.EnclosureFieldFound", (String[])new String[]{"" + pol})});
                    }
                } else {
                    pol = line.substring(from, next);
                    if (log.isRowLevel()) {
                        log.logRowlevel(BaseMessages.getString(PKG, (String)"CsvInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"CsvInput.Log.NormalFieldFound", (String[])new String[]{"" + pol})});
                    }
                }
                if (dencl) {
                    StringBuilder sbpol = new StringBuilder(pol);
                    int idx = sbpol.indexOf(enclosure + enclosure);
                    while (idx >= 0) {
                        sbpol.delete(idx, idx + (enclosure == null ? 0 : enclosure.length()));
                        idx = sbpol.indexOf(enclosure + enclosure);
                    }
                    pol = sbpol.toString();
                }
                if (contains_escaped_enclosures) {
                    String replace = escapeCharacter + enclosure;
                    pol = Const.replace((String)pol, (String)replace, (String)enclosure);
                }
                if (contains_escaped_separators) {
                    String replace = escapeCharacter + delimiter;
                    pol = Const.replace((String)pol, (String)replace, (String)delimiter);
                }
                strings.add(pol);
                pos = next + delimiter.length();
            }
            if (pos == length) {
                if (log.isRowLevel()) {
                    log.logRowlevel(BaseMessages.getString(PKG, (String)"CsvInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"CsvInput.Log.EndOfEmptyLineFound", (String[])new String[0])});
                }
                strings.add("");
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"CsvInput.Log.Error.ErrorConvertingLine", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        return strings.toArray(new String[strings.size()]);
    }
}

