/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.pan;

import java.util.ArrayList;
import org.pentaho.di.base.CommandExecutorCodes;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.logging.FileLoggingEventListener;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.KettleLoggingEventListener;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.kitchen.Kitchen;
import org.pentaho.di.pan.CommandLineOption;
import org.pentaho.di.pan.PanCommandExecutor;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;

public class Pan {
    private static Class<?> PKG = Pan.class;
    public static final String STRING_PAN = "Pan";
    private static LogChannelInterface log = new LogChannel((Object)"Pan");
    private static FileLoggingEventListener fileLoggingEventListener;
    private static PanCommandExecutor commandExecutor;

    public static void main(String[] a) throws Exception {
        KettleClientEnvironment.getInstance().setClient(KettleClientEnvironment.ClientType.PAN);
        KettleEnvironment.init();
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 0; i < a.length; ++i) {
            if (a[i].length() <= 0) continue;
            args.add(a[i]);
        }
        Object repositoryMeta = null;
        Object trans = null;
        NamedParamsDefault optionParams = new NamedParamsDefault();
        CommandLineOption maxLogLinesOption = new CommandLineOption("maxloglines", BaseMessages.getString(PKG, (String)"Pan.CmdLine.MaxLogLines", (String[])new String[0]), new StringBuilder());
        CommandLineOption maxLogTimeoutOption = new CommandLineOption("maxlogtimeout", BaseMessages.getString(PKG, (String)"Pan.CmdLine.MaxLogTimeout", (String[])new String[0]), new StringBuilder());
        CommandLineOption[] commandLineOptionArray = new CommandLineOption[24];
        StringBuilder optionRepname = new StringBuilder();
        commandLineOptionArray[0] = new CommandLineOption("rep", BaseMessages.getString(PKG, (String)"Pan.ComdLine.RepName", (String[])new String[0]), optionRepname);
        StringBuilder optionUsername = new StringBuilder();
        commandLineOptionArray[1] = new CommandLineOption("user", BaseMessages.getString(PKG, (String)"Pan.ComdLine.RepUsername", (String[])new String[0]), optionUsername);
        StringBuilder optionTrustUser = new StringBuilder();
        commandLineOptionArray[2] = new CommandLineOption("trustuser", BaseMessages.getString(PKG, (String)"Pan.ComdLine.RepUsername", (String[])new String[0]), optionTrustUser);
        StringBuilder optionPassword = new StringBuilder();
        commandLineOptionArray[3] = new CommandLineOption("pass", BaseMessages.getString(PKG, (String)"Pan.ComdLine.RepPassword", (String[])new String[0]), optionPassword);
        StringBuilder optionTransname = new StringBuilder();
        commandLineOptionArray[4] = new CommandLineOption("trans", BaseMessages.getString(PKG, (String)"Pan.ComdLine.TransName", (String[])new String[0]), optionTransname);
        StringBuilder optionDirname = new StringBuilder();
        commandLineOptionArray[5] = new CommandLineOption("dir", BaseMessages.getString(PKG, (String)"Pan.ComdLine.RepDir", (String[])new String[0]), optionDirname);
        StringBuilder optionFilename = new StringBuilder();
        commandLineOptionArray[6] = new CommandLineOption("file", BaseMessages.getString(PKG, (String)"Pan.ComdLine.XMLTransFile", (String[])new String[0]), optionFilename);
        StringBuilder optionLoglevel = new StringBuilder();
        commandLineOptionArray[7] = new CommandLineOption("level", BaseMessages.getString(PKG, (String)"Pan.ComdLine.LogLevel", (String[])new String[0]), optionLoglevel);
        StringBuilder optionLogfile = new StringBuilder();
        commandLineOptionArray[8] = new CommandLineOption("logfile", BaseMessages.getString(PKG, (String)"Pan.ComdLine.LogFile", (String[])new String[0]), optionLogfile);
        StringBuilder optionLogfileOld = new StringBuilder();
        commandLineOptionArray[9] = new CommandLineOption("log", BaseMessages.getString(PKG, (String)"Pan.ComdLine.LogOldFile", (String[])new String[0]), optionLogfileOld, false, true);
        StringBuilder optionListdir = new StringBuilder();
        commandLineOptionArray[10] = new CommandLineOption("listdir", BaseMessages.getString(PKG, (String)"Pan.ComdLine.ListDirRep", (String[])new String[0]), optionListdir, true, false);
        StringBuilder optionListtrans = new StringBuilder();
        commandLineOptionArray[11] = new CommandLineOption("listtrans", BaseMessages.getString(PKG, (String)"Pan.ComdLine.ListTransDir", (String[])new String[0]), optionListtrans, true, false);
        StringBuilder optionListrep = new StringBuilder();
        commandLineOptionArray[12] = new CommandLineOption("listrep", BaseMessages.getString(PKG, (String)"Pan.ComdLine.ListReps", (String[])new String[0]), optionListrep, true, false);
        StringBuilder optionExprep = new StringBuilder();
        commandLineOptionArray[13] = new CommandLineOption("exprep", BaseMessages.getString(PKG, (String)"Pan.ComdLine.ExpObjectsXML", (String[])new String[0]), optionExprep, true, false);
        StringBuilder optionNorep = new StringBuilder();
        commandLineOptionArray[14] = new CommandLineOption("norep", BaseMessages.getString(PKG, (String)"Pan.ComdLine.NoRep", (String[])new String[0]), optionNorep, true, false);
        StringBuilder optionSafemode = new StringBuilder();
        commandLineOptionArray[15] = new CommandLineOption("safemode", BaseMessages.getString(PKG, (String)"Pan.ComdLine.SafeMode", (String[])new String[0]), optionSafemode, true, false);
        StringBuilder optionVersion = new StringBuilder();
        commandLineOptionArray[16] = new CommandLineOption("version", BaseMessages.getString(PKG, (String)"Pan.ComdLine.Version", (String[])new String[0]), optionVersion, true, false);
        StringBuilder optionJarFilename = new StringBuilder();
        commandLineOptionArray[17] = new CommandLineOption("jarfile", BaseMessages.getString(PKG, (String)"Pan.ComdLine.JarFile", (String[])new String[0]), optionJarFilename, false, true);
        commandLineOptionArray[18] = new CommandLineOption("param", BaseMessages.getString(PKG, (String)"Pan.ComdLine.Param", (String[])new String[0]), (NamedParams)optionParams, false);
        StringBuilder optionListParam = new StringBuilder();
        commandLineOptionArray[19] = new CommandLineOption("listparam", BaseMessages.getString(PKG, (String)"Pan.ComdLine.ListParam", (String[])new String[0]), optionListParam, true, false);
        StringBuilder initialDir = new StringBuilder();
        commandLineOptionArray[20] = new CommandLineOption("initialDir", null, initialDir, false, true);
        StringBuilder optionMetrics = new StringBuilder();
        commandLineOptionArray[21] = new CommandLineOption("metrics", BaseMessages.getString(PKG, (String)"Pan.ComdLine.Metrics", (String[])new String[0]), optionMetrics, true, false);
        commandLineOptionArray[22] = maxLogLinesOption;
        commandLineOptionArray[23] = maxLogTimeoutOption;
        CommandLineOption[] options = commandLineOptionArray;
        if (args.size() == 2) {
            CommandLineOption.printUsage(options);
            Pan.exitJVM(CommandExecutorCodes.Pan.CMD_LINE_PRINT.getCode());
        }
        if (!CommandLineOption.parseArguments(args, options, log)) {
            log.logError(BaseMessages.getString(PKG, (String)"Pan.Error.CommandLineError", (String[])new String[0]));
            Pan.exitJVM(CommandExecutorCodes.Pan.ERROR_LOADING_STEPS_PLUGINS.getCode());
        }
        Kitchen.configureLogging(maxLogLinesOption, maxLogTimeoutOption);
        String kettleRepname = Const.getEnvironmentVariable((String)"KETTLE_REPOSITORY", null);
        String kettleUsername = Const.getEnvironmentVariable((String)"KETTLE_USER", null);
        String kettlePassword = Const.getEnvironmentVariable((String)"KETTLE_PASSWORD", null);
        if (kettleRepname != null && kettleRepname.length() > 0) {
            optionRepname = new StringBuilder(kettleRepname);
        }
        if (kettleUsername != null && kettleUsername.length() > 0) {
            optionUsername = new StringBuilder(kettleUsername);
        }
        if (kettlePassword != null && kettlePassword.length() > 0) {
            optionPassword = new StringBuilder(kettlePassword);
        }
        if (Utils.isEmpty((CharSequence)optionLogfile) && !Utils.isEmpty((CharSequence)optionLogfileOld)) {
            optionLogfile = optionLogfileOld;
        }
        if (!Utils.isEmpty((CharSequence)optionLogfile)) {
            fileLoggingEventListener = new FileLoggingEventListener(optionLogfile.toString(), true);
            KettleLogStore.getAppender().addLoggingEventListener((KettleLoggingEventListener)fileLoggingEventListener);
        } else {
            fileLoggingEventListener = null;
        }
        if (!Utils.isEmpty((CharSequence)optionLoglevel)) {
            log.setLogLevel(LogLevel.getLogLevelForCode((String)optionLoglevel.toString()));
            log.logMinimal(BaseMessages.getString(PKG, (String)"Pan.Log.Loglevel", (String[])new String[]{log.getLogLevel().getDescription()}));
        }
        if (log.isDebug()) {
            System.out.println("Arguments:");
            for (int i = 0; i < options.length; ++i) {
                System.out.println(Const.rightPad((String)options[i].getOption(), (int)12) + " : " + options[i].getArgument());
            }
            System.out.println("");
        }
        try {
            if (Pan.getCommandExecutor() == null) {
                Pan.setCommandExecutor(new PanCommandExecutor(PKG, log));
            }
            if (!Utils.isEmpty((CharSequence)optionVersion)) {
                Pan.getCommandExecutor().printVersion();
                if (a.length == 1) {
                    Pan.exitJVM(CommandExecutorCodes.Pan.KETTLE_VERSION_PRINT.getCode());
                }
            }
            int returnCode = Pan.getCommandExecutor().execute(optionRepname.toString(), optionNorep.toString(), optionUsername.toString(), optionTrustUser.toString(), optionPassword.toString(), optionDirname.toString(), optionFilename.toString(), optionJarFilename.toString(), optionTransname.toString(), optionListtrans.toString(), optionListdir.toString(), optionExprep.toString(), initialDir.toString(), optionListrep.toString(), optionSafemode.toString(), optionMetrics.toString(), optionListParam.toString(), (NamedParams)optionParams, args.toArray(new String[args.size()]));
            Pan.exitJVM(returnCode);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Pan.exitJVM(CommandExecutorCodes.Pan.UNEXPECTED_ERROR.getCode());
        }
    }

    protected static void configureParameters(Trans trans, NamedParams optionParams, TransMeta transMeta) throws UnknownParamException {
        PanCommandExecutor.configureParameters(trans, optionParams, transMeta);
    }

    private static final void exitJVM(int status) {
        if (fileLoggingEventListener != null) {
            try {
                fileLoggingEventListener.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                status = 1;
            }
            KettleLogStore.getAppender().removeLoggingEventListener((KettleLoggingEventListener)fileLoggingEventListener);
        }
        System.exit(status);
    }

    public static PanCommandExecutor getCommandExecutor() {
        return commandExecutor;
    }

    public static void setCommandExecutor(PanCommandExecutor commandExecutor) {
        Pan.commandExecutor = commandExecutor;
    }
}

