/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util.serialization;

import java.util.List;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.util.serialization.MetaXmlSerializer;
import org.pentaho.di.core.util.serialization.RepoSerializer;
import org.pentaho.di.core.util.serialization.StepMetaProps;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public abstract class BaseSerializingMeta
extends BaseStepMeta
implements StepMetaInterface {
    @Override
    public String getXML() {
        return MetaXmlSerializer.serialize(StepMetaProps.from(this));
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        MetaXmlSerializer.deserialize(stepnode).to(this);
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        RepoSerializer.builder().stepMeta(this).repo(rep).stepId(id_step).deserialize();
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId transId, ObjectId stepId) throws KettleException {
        RepoSerializer.builder().stepMeta(this).repo(rep).stepId(stepId).transId(transId).serialize();
    }

    public StepMetaInterface withVariables(VariableSpace variables) {
        return StepMetaProps.from(this).withVariables(variables).to((StepMetaInterface)this.clone());
    }
}

