/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.Version;
import org.elasticsearch.action.fieldstats.FieldStats;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.joda.DateMathParser;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.util.LocaleUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericDateAnalyzer;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.LongFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.search.internal.SearchContext;
import org.joda.time.DateTimeZone;

public class DateFieldMapper
extends NumberFieldMapper {
    public static final String CONTENT_TYPE = "date";

    protected DateFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, ignoreMalformed, coerce, indexSettings, multiFields, copyTo);
    }

    @Override
    public DateFieldType fieldType() {
        return (DateFieldType)super.fieldType();
    }

    private static Callable<Long> now() {
        return new Callable<Long>(){

            @Override
            public Long call() {
                SearchContext context = SearchContext.current();
                return context != null ? context.nowInMillis() : System.currentTimeMillis();
            }
        };
    }

    @Override
    protected boolean customBoost() {
        return true;
    }

    @Override
    protected void innerParseCreateField(ParseContext context, List<Field> fields) throws IOException {
        String dateAsString = null;
        float boost = this.fieldType().boost();
        if (context.externalValueSet()) {
            Object externalValue = context.externalValue();
            dateAsString = (String)externalValue;
            if (dateAsString == null) {
                dateAsString = this.fieldType().nullValueAsString();
            }
        } else {
            XContentParser parser = context.parser();
            XContentParser.Token token = parser.currentToken();
            if (token == XContentParser.Token.VALUE_NULL) {
                dateAsString = this.fieldType().nullValueAsString();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                dateAsString = parser.text();
            } else if (token == XContentParser.Token.START_OBJECT) {
                String currentFieldName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("value".equals(currentFieldName) || "_value".equals(currentFieldName)) {
                        if (token == XContentParser.Token.VALUE_NULL) {
                            dateAsString = this.fieldType().nullValueAsString();
                            continue;
                        }
                        dateAsString = parser.text();
                        continue;
                    }
                    if ("boost".equals(currentFieldName) || "_boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    throw new IllegalArgumentException("unknown property [" + currentFieldName + "]");
                }
            } else {
                dateAsString = parser.text();
            }
        }
        Long value = null;
        if (dateAsString != null) {
            if (context.includeInAll(this.includeInAll, this)) {
                context.allEntries().addText(this.fieldType().names().fullName(), dateAsString, boost);
            }
            value = this.fieldType().parseStringValue(dateAsString);
        }
        if (value != null) {
            if (this.fieldType().indexOptions() != IndexOptions.NONE || this.fieldType().stored()) {
                LongFieldMapper.CustomLongNumericField field = new LongFieldMapper.CustomLongNumericField(value, (MappedFieldType)this.fieldType());
                field.setBoost(boost);
                fields.add(field);
            }
            if (this.fieldType().hasDocValues()) {
                this.addDocValue(context, fields, value);
            }
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.fieldType().numericPrecisionStep() != 16) {
            builder.field("precision_step", this.fieldType().numericPrecisionStep());
        }
        builder.field("format", this.fieldType().dateTimeFormatter().format());
        if (includeDefaults || this.fieldType().nullValueAsString() != null) {
            builder.field("null_value", this.fieldType().nullValueAsString());
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", false);
        }
        if (includeDefaults || this.fieldType().timeUnit() != Defaults.TIME_UNIT) {
            builder.field("numeric_resolution", this.fieldType().timeUnit().name().toLowerCase(Locale.ROOT));
        }
        if (this.fieldType().dateTimeFormatter().locale() != null && this.fieldType().dateTimeFormatter().locale() != Locale.ROOT) {
            builder.field("locale", (Object)this.fieldType().dateTimeFormatter().locale());
        } else if (includeDefaults) {
            if (this.fieldType().dateTimeFormatter().locale() == null) {
                builder.field("locale", (Object)Locale.ROOT);
            } else {
                builder.field("locale", (Object)this.fieldType().dateTimeFormatter().locale());
            }
        }
    }

    public static class DateFieldType
    extends NumberFieldMapper.NumberFieldType {
        protected FormatDateTimeFormatter dateTimeFormatter = Defaults.DATE_TIME_FORMATTER;
        protected TimeUnit timeUnit = Defaults.TIME_UNIT;
        protected DateMathParser dateMathParser = new DateMathParser(this.dateTimeFormatter);

        public DateFieldType() {
            super(FieldType.NumericType.LONG);
            this.setFieldDataType(new FieldDataType("long"));
        }

        protected DateFieldType(DateFieldType ref) {
            super(ref);
            this.dateTimeFormatter = ref.dateTimeFormatter;
            this.timeUnit = ref.timeUnit;
            this.dateMathParser = ref.dateMathParser;
        }

        @Override
        public DateFieldType clone() {
            return new DateFieldType(this);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            DateFieldType that = (DateFieldType)((Object)o);
            return Objects.equals(this.dateTimeFormatter.format(), that.dateTimeFormatter.format()) && Objects.equals(this.dateTimeFormatter.locale(), that.dateTimeFormatter.locale()) && Objects.equals((Object)this.timeUnit, (Object)that.timeUnit);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.dateTimeFormatter.format(), this.timeUnit});
        }

        @Override
        public String typeName() {
            return DateFieldMapper.CONTENT_TYPE;
        }

        @Override
        public void checkCompatibility(MappedFieldType fieldType, List<String> conflicts, boolean strict) {
            super.checkCompatibility(fieldType, conflicts, strict);
            if (strict) {
                DateFieldType other = (DateFieldType)fieldType;
                if (!Objects.equals(this.dateTimeFormatter().format(), other.dateTimeFormatter().format())) {
                    conflicts.add("mapper [" + this.names().fullName() + "] is used by multiple types. Set update_all_types to true to update [format] across all types.");
                }
                if (!Objects.equals(this.dateTimeFormatter().locale(), other.dateTimeFormatter().locale())) {
                    conflicts.add("mapper [" + this.names().fullName() + "] is used by multiple types. Set update_all_types to true to update [locale] across all types.");
                }
                if (!Objects.equals((Object)this.timeUnit(), (Object)other.timeUnit())) {
                    conflicts.add("mapper [" + this.names().fullName() + "] is used by multiple types. Set update_all_types to true to update [numeric_resolution] across all types.");
                }
            }
        }

        public FormatDateTimeFormatter dateTimeFormatter() {
            return this.dateTimeFormatter;
        }

        public void setDateTimeFormatter(FormatDateTimeFormatter dateTimeFormatter) {
            this.checkIfFrozen();
            this.dateTimeFormatter = dateTimeFormatter;
            this.dateMathParser = new DateMathParser(dateTimeFormatter);
        }

        public TimeUnit timeUnit() {
            return this.timeUnit;
        }

        public void setTimeUnit(TimeUnit timeUnit) {
            this.checkIfFrozen();
            this.timeUnit = timeUnit;
            this.dateMathParser = new DateMathParser(this.dateTimeFormatter);
        }

        protected DateMathParser dateMathParser() {
            return this.dateMathParser;
        }

        private long parseValue(Object value) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof BytesRef) {
                return this.dateTimeFormatter().parser().parseMillis(((BytesRef)value).utf8ToString());
            }
            return this.dateTimeFormatter().parser().parseMillis(value.toString());
        }

        protected long parseStringValue(String value) {
            return this.dateTimeFormatter().parser().parseMillis(value);
        }

        @Override
        public Long value(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof BytesRef) {
                return Numbers.bytesToLong((BytesRef)value);
            }
            return this.parseStringValue(value.toString());
        }

        @Override
        public BytesRef indexedValueForSearch(Object value) {
            BytesRefBuilder bytesRef = new BytesRefBuilder();
            NumericUtils.longToPrefixCoded((long)this.parseValue(value), (int)0, (BytesRefBuilder)bytesRef);
            return bytesRef.get();
        }

        @Override
        public Object valueForSearch(Object value) {
            if (value instanceof String) {
                return value;
            }
            Long val = this.value(value);
            if (val == null) {
                return null;
            }
            return this.dateTimeFormatter().printer().print(val.longValue());
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper) {
            return this.rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, null, null);
        }

        @Override
        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions) {
            long iSim;
            long iValue = this.parseValue(value);
            try {
                iSim = fuzziness.asTimeValue().millis();
            }
            catch (Exception e) {
                iSim = fuzziness.asLong();
            }
            return NumericRangeQuery.newLongRange((String)this.names().indexName(), (int)this.numericPrecisionStep(), (Long)(iValue - iSim), (Long)(iValue + iSim), (boolean)true, (boolean)true);
        }

        @Override
        public FieldStats stats(Terms terms, int maxDoc) throws IOException {
            long minValue = NumericUtils.getMinLong((Terms)terms);
            long maxValue = NumericUtils.getMaxLong((Terms)terms);
            return new FieldStats.Date((long)maxDoc, (long)terms.getDocCount(), terms.getSumDocFreq(), terms.getSumTotalTermFreq(), minValue, maxValue, this.dateTimeFormatter());
        }

        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable DateTimeZone timeZone, @Nullable DateMathParser forcedDateParser) {
            return new LateParsingQuery(lowerTerm, upperTerm, includeLower, includeUpper, timeZone, forcedDateParser);
        }

        private Query innerRangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable DateTimeZone timeZone, @Nullable DateMathParser forcedDateParser) {
            return NumericRangeQuery.newLongRange((String)this.names().indexName(), (int)this.numericPrecisionStep(), lowerTerm == null ? null : Long.valueOf(this.parseToMilliseconds(lowerTerm, !includeLower, timeZone, forcedDateParser == null ? this.dateMathParser : forcedDateParser)), upperTerm == null ? null : Long.valueOf(this.parseToMilliseconds(upperTerm, includeUpper, timeZone, forcedDateParser == null ? this.dateMathParser : forcedDateParser)), (boolean)includeLower, (boolean)includeUpper);
        }

        public long parseToMilliseconds(Object value, boolean inclusive, @Nullable DateTimeZone zone, @Nullable DateMathParser forcedDateParser) {
            DateMathParser dateParser = this.dateMathParser();
            if (forcedDateParser != null) {
                dateParser = forcedDateParser;
            }
            String strValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            return dateParser.parse(strValue, DateFieldMapper.now(), inclusive, zone);
        }

        final class LateParsingQuery
        extends Query {
            final Object lowerTerm;
            final Object upperTerm;
            final boolean includeLower;
            final boolean includeUpper;
            final DateTimeZone timeZone;
            final DateMathParser forcedDateParser;

            public LateParsingQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, DateTimeZone timeZone, DateMathParser forcedDateParser) {
                this.lowerTerm = lowerTerm;
                this.upperTerm = upperTerm;
                this.includeLower = includeLower;
                this.includeUpper = includeUpper;
                this.timeZone = timeZone;
                this.forcedDateParser = forcedDateParser;
            }

            public Query rewrite(IndexReader reader) throws IOException {
                if (this.getBoost() != 1.0f) {
                    return super.rewrite(reader);
                }
                return DateFieldType.this.innerRangeQuery(this.lowerTerm, this.upperTerm, this.includeLower, this.includeUpper, this.timeZone, this.forcedDateParser);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                LateParsingQuery that = (LateParsingQuery)((Object)o);
                if (this.includeLower != that.includeLower) {
                    return false;
                }
                if (this.includeUpper != that.includeUpper) {
                    return false;
                }
                if (this.lowerTerm != null ? !this.lowerTerm.equals(that.lowerTerm) : that.lowerTerm != null) {
                    return false;
                }
                if (this.upperTerm != null ? !this.upperTerm.equals(that.upperTerm) : that.upperTerm != null) {
                    return false;
                }
                return !(this.timeZone != null ? !this.timeZone.equals((Object)that.timeZone) : that.timeZone != null);
            }

            public int hashCode() {
                int result = super.hashCode();
                result = 31 * result + (this.lowerTerm != null ? this.lowerTerm.hashCode() : 0);
                result = 31 * result + (this.upperTerm != null ? this.upperTerm.hashCode() : 0);
                result = 31 * result + (this.includeLower ? 1 : 0);
                result = 31 * result + (this.includeUpper ? 1 : 0);
                result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
                return result;
            }

            public String toString(String s) {
                StringBuilder sb = new StringBuilder();
                return sb.append(DateFieldType.this.names().indexName()).append(':').append(this.includeLower ? (char)'[' : '{').append(this.lowerTerm == null ? "*" : this.lowerTerm.toString()).append(" TO ").append(this.upperTerm == null ? "*" : this.upperTerm.toString()).append(this.includeUpper ? (char)']' : '}').append(ToStringUtils.boost((float)this.getBoost())).toString();
            }
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.dateField(name);
            TypeParsers.parseNumberField(builder, name, node, parserContext);
            boolean configuredFormat = false;
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    if (propNode == null) {
                        throw new MapperParsingException("Property [null_value] cannot be null.");
                    }
                    builder.nullValue(propNode.toString());
                    iterator.remove();
                    continue;
                }
                if (propName.equals("format")) {
                    builder.dateTimeFormatter(TypeParsers.parseDateTimeFormatter(propNode));
                    configuredFormat = true;
                    iterator.remove();
                    continue;
                }
                if (propName.equals("numeric_resolution")) {
                    builder.timeUnit(TimeUnit.valueOf(propNode.toString().toUpperCase(Locale.ROOT)));
                    iterator.remove();
                    continue;
                }
                if (!propName.equals("locale")) continue;
                builder.locale(LocaleUtils.parse(propNode.toString()));
                iterator.remove();
            }
            if (!configuredFormat) {
                if (parserContext.indexVersionCreated().onOrAfter(Version.V_2_0_0_beta1)) {
                    builder.dateTimeFormatter(Defaults.DATE_TIME_FORMATTER);
                } else {
                    builder.dateTimeFormatter(Defaults.DATE_TIME_FORMATTER_BEFORE_2_0);
                }
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, DateFieldMapper> {
        protected String nullValue = Defaults.NULL_VALUE;
        private Locale locale;

        public Builder(String name) {
            super(name, (MappedFieldType)Defaults.FIELD_TYPE, 16);
            this.builder = this;
            this.locale = Locale.ROOT;
        }

        @Override
        public DateFieldType fieldType() {
            return (DateFieldType)this.fieldType;
        }

        public Builder timeUnit(TimeUnit timeUnit) {
            this.fieldType().setTimeUnit(timeUnit);
            return this;
        }

        public Builder nullValue(String nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        public Builder dateTimeFormatter(FormatDateTimeFormatter dateTimeFormatter) {
            this.fieldType().setDateTimeFormatter(dateTimeFormatter);
            return this;
        }

        @Override
        public DateFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            this.fieldType.setNullValue(this.nullValue);
            DateFieldMapper fieldMapper = new DateFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.ignoreMalformed(context), this.coerce(context), context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
            return (DateFieldMapper)fieldMapper.includeInAll(this.includeInAll);
        }

        @Override
        protected void setupFieldType(Mapper.BuilderContext context) {
            FormatDateTimeFormatter dateTimeFormatter;
            if (Version.indexCreated(context.indexSettings()).before(Version.V_2_0_0_beta1) && !this.fieldType().dateTimeFormatter().format().contains("epoch_")) {
                String format = this.fieldType().timeUnit().equals((Object)TimeUnit.SECONDS) ? "epoch_second" : "epoch_millis";
                this.fieldType().setDateTimeFormatter(Joda.forPattern(format + "||" + this.fieldType().dateTimeFormatter().format()));
            }
            if (!this.locale.equals((dateTimeFormatter = this.fieldType().dateTimeFormatter).locale())) {
                this.fieldType().setDateTimeFormatter(new FormatDateTimeFormatter(dateTimeFormatter.format(), dateTimeFormatter.parser(), dateTimeFormatter.printer(), this.locale));
            }
            super.setupFieldType(context);
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        @Override
        protected NamedAnalyzer makeNumberAnalyzer(int precisionStep) {
            return NumericDateAnalyzer.buildNamedAnalyzer(this.fieldType().dateTimeFormatter, precisionStep);
        }

        @Override
        protected int maxPrecisionStep() {
            return 64;
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final FormatDateTimeFormatter DATE_TIME_FORMATTER = Joda.forPattern("strict_date_optional_time||epoch_millis", Locale.ROOT);
        public static final FormatDateTimeFormatter DATE_TIME_FORMATTER_BEFORE_2_0 = Joda.forPattern("date_optional_time", Locale.ROOT);
        public static final TimeUnit TIME_UNIT = TimeUnit.MILLISECONDS;
        public static final DateFieldType FIELD_TYPE = new DateFieldType();
        public static final String NULL_VALUE;

        static {
            FIELD_TYPE.freeze();
            NULL_VALUE = null;
        }
    }
}

