/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.encryption;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.math.BigInteger;
import java.util.ArrayList;
import org.pentaho.di.core.encryption.TwoWayPasswordEncoderInterface;
import org.springframework.stereotype.Service;

@Service
public class KettleTwoWayPasswordEncoder
implements TwoWayPasswordEncoderInterface {
    private static final KettleTwoWayPasswordEncoder instance = new KettleTwoWayPasswordEncoder();
    private static final int RADIX = 16;
    private String Seed;
    public static final String PASSWORD_ENCRYPTED_PREFIX = "Encrypted ";

    public KettleTwoWayPasswordEncoder() {
        String envSeed;
        this.Seed = envSeed = "0933910847463829827159347601486730416058";
    }

    private static KettleTwoWayPasswordEncoder getInstance() {
        return instance;
    }

    @Override
    public void init() {
    }

    @Override
    public String encode(String rawPassword) {
        return this.encode(rawPassword, true);
    }

    @Override
    public String encode(String rawPassword, boolean includePrefix) {
        if (includePrefix) {
            return this.encryptPasswordIfNotUsingVariablesInternal(rawPassword);
        }
        return this.encryptPasswordInternal(rawPassword);
    }

    @Override
    public String decode(String encodedPassword) {
        if (encodedPassword != null && encodedPassword.startsWith(PASSWORD_ENCRYPTED_PREFIX)) {
            encodedPassword = encodedPassword.substring(PASSWORD_ENCRYPTED_PREFIX.length());
        }
        return this.decryptPasswordInternal(encodedPassword);
    }

    @Override
    public String decode(String encodedPassword, boolean optionallyEncrypted) {
        if (encodedPassword == null) {
            return null;
        }
        if (optionallyEncrypted) {
            if (encodedPassword.startsWith(PASSWORD_ENCRYPTED_PREFIX)) {
                encodedPassword = encodedPassword.substring(PASSWORD_ENCRYPTED_PREFIX.length());
                return this.decryptPasswordInternal(encodedPassword);
            }
            return encodedPassword;
        }
        return this.decryptPasswordInternal(encodedPassword);
    }

    @VisibleForTesting
    protected String encryptPasswordInternal(String password) {
        if (password == null) {
            return "";
        }
        if (password.length() == 0) {
            return "";
        }
        BigInteger bi_passwd = new BigInteger(password.getBytes());
        BigInteger bi_r0 = new BigInteger(this.getSeed());
        BigInteger bi_r1 = bi_r0.xor(bi_passwd);
        return bi_r1.toString(16);
    }

    @VisibleForTesting
    protected String decryptPasswordInternal(String encrypted) {
        if (encrypted == null) {
            return "";
        }
        if (encrypted.length() == 0) {
            return "";
        }
        BigInteger bi_confuse = new BigInteger(this.getSeed());
        try {
            BigInteger bi_r1 = new BigInteger(encrypted, 16);
            BigInteger bi_r0 = bi_r1.xor(bi_confuse);
            return new String(bi_r0.toByteArray());
        }
        catch (Exception e) {
            return "";
        }
    }

    @VisibleForTesting
    protected String getSeed() {
        return this.Seed;
    }

    @Override
    public String[] getPrefixes() {
        return new String[]{PASSWORD_ENCRYPTED_PREFIX};
    }

    protected final String encryptPasswordIfNotUsingVariablesInternal(String password) {
        String encrPassword = "";
        ArrayList varList = new ArrayList();
        encrPassword = varList.isEmpty() ? PASSWORD_ENCRYPTED_PREFIX + KettleTwoWayPasswordEncoder.encryptPassword(password) : password;
        return encrPassword;
    }

    protected final String decryptPasswordOptionallyEncryptedInternal(String password) {
        if (!Strings.isNullOrEmpty((String)password) && password.startsWith(PASSWORD_ENCRYPTED_PREFIX)) {
            return this.decryptPasswordInternal(password.substring(PASSWORD_ENCRYPTED_PREFIX.length()));
        }
        return password;
    }

    public static final String encryptPasswordIfNotUsingVariables(String password) {
        return KettleTwoWayPasswordEncoder.getInstance().encryptPasswordIfNotUsingVariablesInternal(password);
    }

    public static final String decryptPasswordOptionallyEncrypted(String password) {
        return KettleTwoWayPasswordEncoder.getInstance().decryptPasswordOptionallyEncryptedInternal(password);
    }

    public static final String encryptPassword(String password) {
        return KettleTwoWayPasswordEncoder.getInstance().encryptPasswordInternal(password);
    }

    public static final String decryptPassword(String encrypted) {
        return KettleTwoWayPasswordEncoder.getInstance().decryptPasswordInternal(encrypted);
    }
}

