/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.support;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.osgi.extender.OsgiBeanFactoryPostProcessor;

public class OsgiBeanFactoryPostProcessorAdapter
implements BeanFactoryPostProcessor {
    private static final Log log = LogFactory.getLog((Class)OsgiBeanFactoryPostProcessorAdapter.class);
    private final BundleContext bundleContext;
    private List osgiPostProcessors;

    public OsgiBeanFactoryPostProcessorAdapter(BundleContext bundleContext, List postProcessors) {
        this.bundleContext = bundleContext;
        this.osgiPostProcessors = postProcessors;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        boolean trace = log.isTraceEnabled();
        Throwable processingException = null;
        Iterator iterator = this.osgiPostProcessors.iterator();
        while (iterator.hasNext()) {
            OsgiBeanFactoryPostProcessor osgiPostProcessor = (OsgiBeanFactoryPostProcessor)iterator.next();
            if (trace) {
                log.trace((Object)("Calling OsgiBeanFactoryPostProcessor " + osgiPostProcessor + " for bean factory " + beanFactory));
            }
            try {
                osgiPostProcessor.postProcessBeanFactory(this.bundleContext, beanFactory);
            }
            catch (InvalidSyntaxException ex) {
                processingException = ex;
            }
            catch (BundleException ex) {
                processingException = ex;
            }
            if (processingException == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("PostProcessor " + osgiPostProcessor + " threw exception"), processingException);
            }
            throw new FatalBeanException("Error encountered while executing OSGi post processing", processingException);
        }
    }
}

