/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.colorchooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.ExtendedColorModel;

public class RGBColorSelectorPanel
extends JComponent {
    private ColorSelectionHandler colorSelectionHandler;
    private ExtendedColorModel colorSelectionModel;
    private BufferedImage backend = new BufferedImage(256, 256, 1);
    private ColorComponents component = ColorComponents.RED;

    public RGBColorSelectorPanel() {
        this.colorSelectionHandler = new ColorSelectionHandler();
        this.addMouseListener(new MouseHandler());
        this.addMouseMotionListener(new MouseHandler());
        this.updateImage();
    }

    public ColorComponents getComponent() {
        return this.component;
    }

    public void setComponent(ColorComponents component) {
        if (component == null) {
            throw new NullPointerException();
        }
        this.component = component;
        this.updateImage();
        this.repaint();
    }

    private int computeColor(int selectedValue, int x, int y) {
        if (this.component == ColorComponents.RED) {
            return (selectedValue & 0xFF) << 16 | (y & 0xFF) << 8 | x & 0xFF;
        }
        if (this.component == ColorComponents.GREEN) {
            return (x & 0xFF) << 16 | (selectedValue & 0xFF) << 8 | y & 0xFF;
        }
        if (this.component == ColorComponents.BLUE) {
            return (x & 0xFF) << 16 | (y & 0xFF) << 8 | selectedValue & 0xFF;
        }
        throw new IllegalStateException();
    }

    private void updateImage() {
        int selectedComponent = this.getSelectedComponent();
        for (int x = 0; x < 256; ++x) {
            for (int y = 0; y < 256; ++y) {
                this.backend.setRGB(x, y, this.computeColor(selectedComponent, x, y));
            }
        }
    }

    private int getSelectedComponent() {
        int selectedComponent;
        Color selectedValue = this.getSelectedColor();
        if (selectedValue == null) {
            selectedComponent = 128;
        } else {
            switch (this.component) {
                case RED: {
                    selectedComponent = selectedValue.getRed();
                    break;
                }
                case GREEN: {
                    selectedComponent = selectedValue.getGreen();
                    break;
                }
                case BLUE: {
                    selectedComponent = selectedValue.getBlue();
                    break;
                }
                default: {
                    selectedComponent = 128;
                }
            }
        }
        return selectedComponent;
    }

    private Color getSelectedColor() {
        if (this.colorSelectionModel == null) {
            return null;
        }
        return this.colorSelectionModel.getSelectedColor();
    }

    public ExtendedColorModel getColorSelectionModel() {
        return this.colorSelectionModel;
    }

    public void setColorSelectionModel(ExtendedColorModel colorSelectionModel) {
        if (this.colorSelectionModel != null) {
            this.colorSelectionModel.removeChangeListener(this.colorSelectionHandler);
        }
        this.colorSelectionModel = colorSelectionModel;
        if (this.colorSelectionModel != null) {
            this.colorSelectionModel.addChangeListener(this.colorSelectionHandler);
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.drawImage(this.backend, 0, 0, this.getWidth(), this.getHeight(), this);
        Point color = this.computeSelectedPosition();
        if (color != null) {
            Color selectedColor = this.getSelectedColor();
            float[] floats = Color.RGBtoHSB(selectedColor.getRed(), selectedColor.getGreen(), selectedColor.getBlue(), null);
            floats[2] = 1.0f - floats[2];
            floats[1] = 0.0f;
            Graphics graphics = g.create();
            graphics.setColor(Color.getHSBColor(floats[0], floats[1], floats[2]));
            graphics.drawOval(color.x - 2, color.y - 2, 4, 4);
            graphics.dispose();
        }
    }

    private Point computeSelectedPosition() {
        Color selectedColor = this.getSelectedColor();
        if (selectedColor == null) {
            return null;
        }
        float[] floats = selectedColor.getRGBColorComponents(null);
        switch (this.component) {
            case RED: {
                return new Point((int)(floats[1] * (float)this.getWidth()), (int)(floats[2] * (float)this.getHeight()));
            }
            case GREEN: {
                return new Point((int)(floats[0] * (float)this.getWidth()), (int)(floats[2] * (float)this.getHeight()));
            }
            case BLUE: {
                return new Point((int)(floats[0] * (float)this.getWidth()), (int)(floats[1] * (float)this.getHeight()));
            }
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(255, 255);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(255, 255);
    }

    private class ColorSelectionHandler
    implements ChangeListener {
        private ColorSelectionHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            RGBColorSelectorPanel.this.updateImage();
            RGBColorSelectorPanel.this.repaint();
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.handleMouse(e);
        }

        private void handleMouse(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            if (RGBColorSelectorPanel.this.getWidth() == 0 || RGBColorSelectorPanel.this.getHeight() == 0) {
                return;
            }
            if (e.getX() > RGBColorSelectorPanel.this.getWidth()) {
                return;
            }
            if (e.getY() > RGBColorSelectorPanel.this.getHeight()) {
                return;
            }
            if (RGBColorSelectorPanel.this.getWidth() == 0 || RGBColorSelectorPanel.this.getHeight() == 0) {
                return;
            }
            if (RGBColorSelectorPanel.this.colorSelectionModel == null) {
                return;
            }
            float x = (float)e.getX() / (float)RGBColorSelectorPanel.this.getWidth();
            float y = (float)e.getY() / (float)RGBColorSelectorPanel.this.getHeight();
            int color = RGBColorSelectorPanel.this.computeColor(RGBColorSelectorPanel.this.getSelectedComponent(), (int)(x * 255.0f), (int)(y * 255.0f));
            RGBColorSelectorPanel.this.colorSelectionModel.setSelectedColor(new Color(color));
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.handleMouse(e);
        }
    }

    public static enum ColorComponents {
        RED,
        GREEN,
        BLUE;

    }
}

