/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mondrian.olap.OlapElement;
import mondrian.rolap.RolapStar;
import mondrian.rolap.agg.CellRequest;

public class DrillThroughCellRequest
extends CellRequest {
    private final List<RolapStar.Column> drillThroughColumns = new ArrayList<RolapStar.Column>();
    private final List<RolapStar.Measure> drillThroughMeasures = new ArrayList<RolapStar.Measure>();
    private final List<OlapElement> nonApplicableMembers;

    public DrillThroughCellRequest(RolapStar.Measure measure, boolean extendedContext, List<OlapElement> nonApplicableFields) {
        super(measure, extendedContext, true);
        this.nonApplicableMembers = nonApplicableFields;
    }

    public void addDrillThroughColumn(RolapStar.Column column) {
        this.drillThroughColumns.add(column);
    }

    public boolean includeInSelect(RolapStar.Column column) {
        if (this.drillThroughColumns.size() == 0 && this.drillThroughMeasures.size() == 0) {
            return true;
        }
        return this.drillThroughColumns.contains(column);
    }

    public void addDrillThroughMeasure(RolapStar.Measure measure) {
        this.drillThroughMeasures.add(measure);
    }

    public boolean includeInSelect(RolapStar.Measure measure) {
        if (this.drillThroughColumns.size() == 0 && this.drillThroughMeasures.size() == 0) {
            return true;
        }
        return this.drillThroughMeasures.contains(measure);
    }

    public List<RolapStar.Measure> getDrillThroughMeasures() {
        return Collections.unmodifiableList(this.drillThroughMeasures);
    }

    public List<OlapElement> getNonApplicableMembers() {
        return this.nonApplicableMembers;
    }
}

