/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import mondrian.calc.TupleCursor;
import mondrian.calc.TupleIterable;
import mondrian.calc.TupleIterator;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractTupleIterator;
import mondrian.calc.impl.ArrayTupleList;
import mondrian.calc.impl.DelegatingTupleList;
import mondrian.calc.impl.UnaryTupleList;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.Util;

public final class TupleCollections {
    private static final TupleList[] EMPTY_LISTS = new TupleList[]{new DelegatingTupleList(0, Collections.emptyList()), new UnaryTupleList(Collections.emptyList()), new DelegatingTupleList(2, Collections.emptyList()), new DelegatingTupleList(3, Collections.emptyList()), new DelegatingTupleList(4, Collections.emptyList())};

    private TupleCollections() {
    }

    public static TupleList createList(int arity) {
        switch (arity) {
            case 0: {
                return new DelegatingTupleList(0, new ArrayList<List<Member>>());
            }
            case 1: {
                return new UnaryTupleList();
            }
        }
        return new ArrayTupleList(arity);
    }

    public static TupleList createList(int arity, int initialCapacity) {
        switch (arity) {
            case 0: {
                return new DelegatingTupleList(0, new ArrayList<List<Member>>(initialCapacity));
            }
            case 1: {
                return new UnaryTupleList(new ArrayList<Member>(initialCapacity));
            }
        }
        return new ArrayTupleList(arity, initialCapacity);
    }

    public static TupleList emptyList(int arity) {
        return arity < EMPTY_LISTS.length ? EMPTY_LISTS[arity] : new DelegatingTupleList(arity, Collections.emptyList());
    }

    public static TupleList unmodifiableList(TupleList list) {
        return list.getArity() == 1 ? new UnaryTupleList(Collections.unmodifiableList(list.slice(0))) : new DelegatingTupleList(list.getArity(), Collections.unmodifiableList(list));
    }

    public static TupleIterator iterator(final TupleCursor cursor) {
        if (cursor instanceof TupleIterator) {
            return (TupleIterator)cursor;
        }
        return new AbstractTupleIterator(cursor.getArity()){
            private int state;
            private static final int STATE_UNKNOWN = 0;
            private static final int STATE_HASNEXT = 1;
            private static final int STATE_EOD = 2;
            {
                super(arity);
                this.state = 0;
            }

            @Override
            public List<Member> current() {
                return cursor.current();
            }

            @Override
            public boolean hasNext() {
                switch (this.state) {
                    case 0: {
                        if (cursor.forward()) {
                            this.state = 1;
                            return true;
                        }
                        this.state = 2;
                        return false;
                    }
                    case 2: {
                        return false;
                    }
                    case 1: {
                        return true;
                    }
                }
                throw new RuntimeException("unpexected state " + this.state);
            }

            @Override
            public List<Member> next() {
                switch (this.state) {
                    case 0: {
                        if (cursor.forward()) {
                            return cursor.current();
                        }
                        this.state = 2;
                    }
                    case 2: {
                        throw new NoSuchElementException();
                    }
                    case 1: {
                        this.state = 0;
                        return cursor.current();
                    }
                }
                throw new RuntimeException("unpexected state " + this.state);
            }

            @Override
            public boolean forward() {
                switch (this.state) {
                    case 0: {
                        return cursor.forward();
                    }
                    case 1: {
                        this.state = 0;
                        return true;
                    }
                    case 2: {
                        return false;
                    }
                }
                throw new RuntimeException("unpexected state " + this.state);
            }

            @Override
            public void setContext(Evaluator evaluator) {
                cursor.setContext(evaluator);
            }

            @Override
            public void currentToArray(Member[] members, int offset) {
                cursor.currentToArray(members, offset);
            }

            @Override
            public Member member(int column) {
                return cursor.member(column);
            }
        };
    }

    public static Iterable<Member> slice(final TupleIterable tupleIterable, final int column) {
        if (column < 0 || column >= tupleIterable.getArity()) {
            throw new IllegalArgumentException();
        }
        return new Iterable<Member>(){

            @Override
            public Iterator<Member> iterator() {
                final TupleIterator tupleIterator = tupleIterable.tupleIterator();
                return new Iterator<Member>(){

                    @Override
                    public boolean hasNext() {
                        return tupleIterator.hasNext();
                    }

                    @Override
                    public Member next() {
                        if (!tupleIterator.forward()) {
                            throw new NoSuchElementException();
                        }
                        return tupleIterator.member(column);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Iterable<Member[]> asMemberArrayIterable(final TupleIterable tupleIterable) {
        return new Iterable<Member[]>(){

            @Override
            public Iterator<Member[]> iterator() {
                return new Iterator<Member[]>(){
                    final TupleIterator tupleIterator;
                    {
                        this.tupleIterator = tupleIterable.tupleIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.tupleIterator.hasNext();
                    }

                    @Override
                    public Member[] next() {
                        List next = (List)this.tupleIterator.next();
                        return next.toArray(new Member[next.size()]);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static List<Member[]> asMemberArrayList(final TupleList tupleList) {
        return new AbstractList<Member[]>(){

            @Override
            public Member[] get(int index) {
                List tuple = (List)tupleList.get(index);
                return tuple.toArray(new Member[tuple.size()]);
            }

            @Override
            public int size() {
                return tupleList.size();
            }
        };
    }

    public static TupleList asTupleList(List list) {
        if (list instanceof TupleList) {
            return (TupleList)list;
        }
        if (list.isEmpty()) {
            return TupleCollections.emptyList(1);
        }
        Object o = list.get(0);
        if (o instanceof Member) {
            List<Member> memberList = Util.cast(list);
            return new UnaryTupleList(memberList);
        }
        final List memberArrayList = Util.cast(list);
        return new DelegatingTupleList(((Member[])memberArrayList.get(0)).length, (List<List<Member>>)new AbstractList<List<Member>>(){

            @Override
            public List<Member> get(int index) {
                return Arrays.asList((Object[])memberArrayList.get(index));
            }

            @Override
            public int size() {
                return memberArrayList.size();
            }
        });
    }

    public static TupleList materialize(TupleIterable tupleIterable, boolean eager) {
        if (tupleIterable instanceof TupleList) {
            return (TupleList)tupleIterable;
        }
        if (eager) {
            TupleList tupleList = TupleCollections.createList(tupleIterable.getArity());
            TupleCursor tupleCursor = tupleIterable.tupleCursor();
            while (tupleCursor.forward()) {
                tupleList.addCurrent(tupleCursor);
            }
            return tupleList;
        }
        return new MaterializingTupleList(tupleIterable);
    }

    private static class MaterializingTupleList
    implements TupleList {
        private final TupleIterable tupleIterable;
        TupleList tupleList;

        public MaterializingTupleList(TupleIterable tupleIterable) {
            this.tupleIterable = tupleIterable;
        }

        private TupleList materialize() {
            if (this.tupleList == null) {
                this.tupleList = TupleCollections.materialize(this.tupleIterable, true);
            }
            return this.tupleList;
        }

        @Override
        public TupleIterator tupleIterator() {
            if (this.tupleList == null) {
                return this.tupleIterable.tupleIterator();
            }
            return this.tupleList.tupleIterator();
        }

        @Override
        public TupleCursor tupleCursor() {
            if (this.tupleList == null) {
                return this.tupleIterable.tupleCursor();
            }
            return this.tupleList.tupleCursor();
        }

        @Override
        public int getArity() {
            return this.tupleIterable.getArity();
        }

        @Override
        public Iterator<List<Member>> iterator() {
            if (this.tupleList == null) {
                return this.tupleIterable.iterator();
            }
            return this.tupleList.iterator();
        }

        @Override
        public List<Member> slice(int column) {
            return this.materialize().slice(column);
        }

        @Override
        public Member get(int slice, int index) {
            return this.materialize().get(slice, index);
        }

        @Override
        public TupleList cloneList(int capacity) {
            return this.materialize().cloneList(capacity);
        }

        @Override
        public void addTuple(Member ... members) {
            throw new UnsupportedOperationException();
        }

        @Override
        public TupleList project(int[] destIndices) {
            return this.materialize().project(destIndices);
        }

        @Override
        public void addCurrent(TupleCursor tupleIter) {
            this.materialize().addCurrent(tupleIter);
        }

        @Override
        public TupleList subList(int fromIndex, int toIndex) {
            return this.materialize().subList(fromIndex, toIndex);
        }

        @Override
        public TupleList withPositionCallback(TupleList.PositionCallback positionCallback) {
            return this.materialize().withPositionCallback(positionCallback);
        }

        @Override
        public TupleList fix() {
            return this.materialize().fix();
        }

        @Override
        public int size() {
            return this.materialize().size();
        }

        @Override
        public boolean isEmpty() {
            return this.materialize().isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.materialize().contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.materialize().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.materialize().toArray(a);
        }

        @Override
        public boolean add(List<Member> members) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.materialize().containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends List<Member>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends List<Member>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Member> get(int index) {
            return (List)this.materialize().get(index);
        }

        @Override
        public List<Member> set(int index, List<Member> element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, List<Member> element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Member> remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            return this.materialize().indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.materialize().lastIndexOf(o);
        }

        @Override
        public ListIterator<List<Member>> listIterator() {
            return this.materialize().listIterator();
        }

        @Override
        public ListIterator<List<Member>> listIterator(int index) {
            return this.materialize().listIterator(index);
        }
    }
}

