/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataReaderWriter;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonSpillableDataBag
implements DataBag {
    private static final long serialVersionUID = 1L;
    private List<Tuple> mContents;

    public NonSpillableDataBag() {
        this.mContents = new ArrayList<Tuple>();
    }

    public NonSpillableDataBag(int tupleCount) {
        this.mContents = new ArrayList<Tuple>(tupleCount);
    }

    public NonSpillableDataBag(List<Tuple> listOfTuples) {
        this.mContents = listOfTuples;
    }

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public boolean isDistinct() {
        return false;
    }

    @Override
    public Iterator<Tuple> iterator() {
        return new NonSpillableDataBagIterator();
    }

    protected void reportProgress() {
        if (PhysicalOperator.getReporter() != null) {
            PhysicalOperator.getReporter().progress();
        }
    }

    @Override
    public void add(Tuple t) {
        this.mContents.add(t);
    }

    @Override
    public void addAll(DataBag b) {
        for (Tuple t : b) {
            this.mContents.add(t);
        }
    }

    @Override
    public void clear() {
        this.mContents.clear();
    }

    @Override
    public void markStale(boolean stale) {
        throw new RuntimeException("NonSpillableDataBag cannot be marked stale");
    }

    @Override
    public long size() {
        return this.mContents.size();
    }

    @Override
    public long getMemorySize() {
        return 0L;
    }

    @Override
    public long spill() {
        return 0L;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.size());
        for (Tuple item : this) {
            item.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        long size = in.readLong();
        for (long i = 0L; i < size; ++i) {
            Object o = DataReaderWriter.readDatum(in);
            this.add((Tuple)o);
            continue;
        }
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int hashCode() {
        return this.mContents.hashCode();
    }

    public int compareTo(Object other) {
        if (this == other) {
            return 0;
        }
        if (other instanceof DataBag) {
            DataBag otherClone;
            DataBag bOther = (DataBag)other;
            if (this.size() != bOther.size()) {
                if (this.size() > bOther.size()) {
                    return 1;
                }
                return -1;
            }
            BagFactory factory = BagFactory.getInstance();
            DataBag thisClone = factory.newSortedBag(null);
            Iterator<Tuple> i = this.iterator();
            while (i.hasNext()) {
                thisClone.add(i.next());
            }
            if (((DataBag)other).isSorted() || ((DataBag)other).isDistinct()) {
                otherClone = bOther;
            } else {
                otherClone = factory.newSortedBag(null);
                i = bOther.iterator();
                while (i.hasNext()) {
                    otherClone.add(i.next());
                }
            }
            Iterator<Tuple> thisIt = thisClone.iterator();
            Iterator<Tuple> otherIt = otherClone.iterator();
            while (thisIt.hasNext() && otherIt.hasNext()) {
                Tuple otherT;
                Tuple thisT = thisIt.next();
                int c = thisT.compareTo(otherT = otherIt.next());
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
        return DataType.compare(this, other);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        Iterator<Tuple> it = this.iterator();
        while (it.hasNext()) {
            Tuple t = it.next();
            String s = t.toString();
            sb.append(s);
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        sb.append('}');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NonSpillableDataBagIterator
    implements Iterator<Tuple> {
        private int mCntr = 0;

        private NonSpillableDataBagIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.mCntr < NonSpillableDataBag.this.mContents.size();
        }

        @Override
        public Tuple next() {
            if ((this.mCntr & 0x3FF) == 0) {
                NonSpillableDataBag.this.reportProgress();
            }
            return (Tuple)NonSpillableDataBag.this.mContents.get(this.mCntr++);
        }

        @Override
        public void remove() {
            throw new RuntimeException("Cannot remove() from NonSpillableDataBag.iterator()");
        }
    }
}

