/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.JVMReuseManager;

public class JVMReuseImpl {
    private static Log LOG = LogFactory.getLog(JVMReuseImpl.class);

    public void cleanupStaticData() {
        List<Method> staticCleanupMethods = JVMReuseManager.getInstance().getStaticDataCleanupMethods();
        for (Method m : staticCleanupMethods) {
            try {
                String msg = "Invoking method " + m.getName() + " in class " + m.getDeclaringClass().getName() + " for static data cleanup";
                if (m.getDeclaringClass().getName().startsWith("org.apache.pig")) {
                    LOG.debug((Object)msg);
                } else {
                    LOG.info((Object)msg);
                }
                m.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while invoking method " + m.getName() + " in class " + m.getDeclaringClass().getName() + " for static data cleanup", e);
            }
        }
    }
}

