/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.util.List;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class Expression {
    protected OpType opType;

    public OpType getOpType() {
        return this.opType;
    }

    public static class Const
    extends Expression {
        Object value;

        public Object getValue() {
            return this.value;
        }

        public Const(Object value) {
            this.opType = OpType.TERM_CONST;
            this.value = value;
        }

        public String toString() {
            return this.value instanceof String ? "'" + this.value + "'" : this.value.toString();
        }
    }

    public static class Column
    extends Expression {
        private String name;

        public Column(String name) {
            this.opType = OpType.TERM_COL;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class BinaryExpression
    extends Expression {
        Expression lhs;
        Expression rhs;

        public BinaryExpression(Expression lhs, Expression rhs, OpType opType) {
            this.opType = opType;
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public Expression getLhs() {
            return this.lhs;
        }

        public Expression getRhs() {
            return this.rhs;
        }

        public String toString() {
            return "(" + this.lhs.toString() + this.opType.toString() + this.rhs.toString() + ")";
        }
    }

    public static class UnaryExpression
    extends Expression {
        Expression expr;

        public UnaryExpression(Expression expr, OpType opType) {
            this.opType = opType;
            this.expr = expr;
        }

        public Expression getExpression() {
            return this.expr;
        }

        public String toString() {
            return "(" + this.expr.toString() + this.opType.toString() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InExpression
    extends Expression {
        private List<Object> values;

        public InExpression(List<Object> values) {
            this.opType = OpType.OP_IN;
            this.values = values;
        }

        public List<Object> getValues() {
            return this.values;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" in (");
            for (Object value : this.values) {
                if (value instanceof String) {
                    sb.append("'").append(value).append("', ");
                    continue;
                }
                sb.append(value).append(", ");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
            return sb.toString();
        }
    }

    public static class BetweenExpression
    extends Expression {
        private Object lower;
        private Object upper;

        public BetweenExpression(Object lower, Object upper) {
            this.opType = OpType.OP_BETWEEN;
            this.lower = lower;
            this.upper = upper;
        }

        public Object getLower() {
            return this.lower;
        }

        public Object getUpper() {
            return this.upper;
        }

        public String toString() {
            return " between " + this.lower + " and " + this.upper;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OpType {
        OP_PLUS(" + "),
        OP_MINUS(" - "),
        OP_TIMES(" * "),
        OP_DIV(" / "),
        OP_MOD(" % "),
        OP_EQ(" == "),
        OP_NE(" != "),
        OP_GT(" > "),
        OP_GE(" >= "),
        OP_LT(" < "),
        OP_LE(" <= "),
        OP_MATCH(" matches "),
        OP_IN(" in "),
        OP_BETWEEN(" between "),
        OP_NULL(" is null"),
        OP_NOT(" not"),
        OP_AND(" and "),
        OP_OR(" or "),
        TERM_COL(" Column "),
        TERM_CONST(" Constant ");

        private String str = "";

        private OpType(String rep) {
            this.str = rep;
        }

        private OpType() {
        }

        public String toString() {
            return this.str;
        }
    }
}

