/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public final class MultiAction<R> {
    public Map<byte[], List<Action<R>>> actions = new TreeMap<byte[], List<Action<R>>>(Bytes.BYTES_COMPARATOR);
    private long nonceGroup = 0L;

    public int size() {
        int size = 0;
        for (List<Action<R>> l : this.actions.values()) {
            size += l.size();
        }
        return size;
    }

    public void add(byte[] regionName, Action<R> a) {
        this.add(regionName, Arrays.asList(a));
    }

    public void add(byte[] regionName, List<Action<R>> actionList) {
        List<Action<R>> rsActions = this.actions.get(regionName);
        if (rsActions == null) {
            rsActions = new ArrayList<Action<R>>(actionList.size());
            this.actions.put(regionName, rsActions);
        }
        rsActions.addAll(actionList);
    }

    public void setNonceGroup(long nonceGroup) {
        this.nonceGroup = nonceGroup;
    }

    public Set<byte[]> getRegions() {
        return this.actions.keySet();
    }

    public boolean hasNonceGroup() {
        return this.nonceGroup != 0L;
    }

    public long getNonceGroup() {
        return this.nonceGroup;
    }
}

