/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.models.annotations;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroup;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationObjectFactory;
import org.pentaho.agilebi.modeler.models.annotations.SharedDimensionGroup;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.metastore.DatabaseMetaStoreUtil;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.IMetaStoreElement;
import org.pentaho.metastore.api.IMetaStoreElementType;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.persist.IMetaStoreObjectFactory;
import org.pentaho.metastore.persist.MetaStoreFactory;

public class ModelAnnotationManager {
    public static final String DEFAULT_NAMESPACE = "pentaho";
    public static final String SHARED_DIMENSIONS_NAMESPACE = "pentaho.shared.dimensions";
    private boolean sharedDimension;
    private ModelAnnotationObjectFactory modelAnnotationObjectFactory = new ModelAnnotationObjectFactory();

    public ModelAnnotationManager() {
        this(false);
    }

    public ModelAnnotationManager(boolean sharedDimension) {
        this.sharedDimension = sharedDimension;
    }

    @Deprecated
    public ModelAnnotationManager(String type) {
        if (StringUtils.equals((String)SHARED_DIMENSIONS_NAMESPACE, (String)type)) {
            this.sharedDimension = true;
        }
    }

    private MetaStoreFactory<? extends ModelAnnotationGroup> getGroupMetaStoreFactory(IMetaStore metastore) throws MetaStoreException {
        if (this.sharedDimension) {
            return this.getMetaStoreFactory(metastore, SharedDimensionGroup.class);
        }
        return this.getMetaStoreFactory(metastore, ModelAnnotationGroup.class);
    }

    private <T> MetaStoreFactory<T> getMetaStoreFactory(IMetaStore metastore, Class<T> clazz) throws MetaStoreException {
        if (!metastore.namespaceExists(DEFAULT_NAMESPACE)) {
            metastore.createNamespace(DEFAULT_NAMESPACE);
        }
        MetaStoreFactory factory = new MetaStoreFactory(clazz, metastore, DEFAULT_NAMESPACE);
        factory.setObjectFactory((IMetaStoreObjectFactory)this.modelAnnotationObjectFactory);
        return factory;
    }

    private ModelAnnotationGroup augmentGroup(ModelAnnotationGroup modelAnnotationGroup) {
        if (this.sharedDimension) {
            return new SharedDimensionGroup(modelAnnotationGroup);
        }
        return modelAnnotationGroup;
    }

    public void createGroup(ModelAnnotationGroup modelAnnotationGroup, IMetaStore metastore) throws Exception {
        if (metastore == null || modelAnnotationGroup == null) {
            return;
        }
        MetaStoreFactory<? extends ModelAnnotationGroup> factory = this.getGroupMetaStoreFactory(metastore);
        factory.saveElement((Object)this.augmentGroup(modelAnnotationGroup));
    }

    public ModelAnnotationGroup readGroup(String groupName, IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<? extends ModelAnnotationGroup> factory = this.getGroupMetaStoreFactory(metastore);
        return (ModelAnnotationGroup)factory.loadElement(groupName);
    }

    public void updateGroup(ModelAnnotationGroup modelAnnotationGroup, IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<? extends ModelAnnotationGroup> factory = this.getGroupMetaStoreFactory(metastore);
        factory.deleteElement(modelAnnotationGroup.getName());
        factory.saveElement((Object)this.augmentGroup(modelAnnotationGroup));
    }

    public void deleteGroup(String groupName, IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<? extends ModelAnnotationGroup> factory = this.getGroupMetaStoreFactory(metastore);
        factory.deleteElement(groupName);
    }

    public List<ModelAnnotationGroup> listGroups(IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<? extends ModelAnnotationGroup> factory = this.getGroupMetaStoreFactory(metastore);
        return factory.getElements();
    }

    public List<String> listGroupNames(IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<? extends ModelAnnotationGroup> factory = this.getGroupMetaStoreFactory(metastore);
        return factory.getElementNames();
    }

    public boolean containsGroup(String groupName, IMetaStore metastore) throws MetaStoreException {
        if (metastore == null) {
            return false;
        }
        for (String name : this.listGroupNames(metastore)) {
            if (!name.equals(groupName)) continue;
            return true;
        }
        return false;
    }

    public void deleteAllGroups(IMetaStore metastore) throws MetaStoreException {
        if (metastore == null) {
            return;
        }
        for (String name : this.listGroupNames(metastore)) {
            this.deleteGroup(name, metastore);
        }
    }

    public String storeDatabaseMeta(DatabaseMeta dbMeta, IMetaStore mstore) throws MetaStoreException {
        IMetaStoreElementType properType = ModelAnnotationManager.getDatabaseMetaType(mstore);
        IMetaStoreElement dbMetaElement = DatabaseMetaStoreUtil.populateDatabaseElement((IMetaStore)mstore, (DatabaseMeta)dbMeta);
        IMetaStoreElement dbMetaExisting = mstore.getElementByName(properType.getNamespace(), properType, dbMeta.getName());
        if (dbMetaExisting != null) {
            mstore.updateElement(properType.getNamespace(), properType, dbMetaExisting.getId(), dbMetaElement);
        } else {
            mstore.createElement(properType.getNamespace(), properType, dbMetaElement);
        }
        return dbMeta.getName();
    }

    public DatabaseMeta loadDatabaseMeta(String databaseMetaRefName, IMetaStore mstore) throws MetaStoreException, KettlePluginException {
        IMetaStoreElementType dbMetaType = mstore.getElementTypeByName(DEFAULT_NAMESPACE, "Database connection");
        IMetaStoreElement element = mstore.getElementByName(dbMetaType.getNamespace(), dbMetaType, databaseMetaRefName);
        if (element == null) {
            return null;
        }
        return DatabaseMetaStoreUtil.loadDatabaseMetaFromDatabaseElement((IMetaStore)mstore, (IMetaStoreElement)element);
    }

    private static IMetaStoreElementType getDatabaseMetaType(IMetaStore metaStore) throws MetaStoreException {
        IMetaStoreElementType elementType;
        if (!metaStore.namespaceExists(DEFAULT_NAMESPACE)) {
            metaStore.createNamespace(DEFAULT_NAMESPACE);
        }
        if ((elementType = metaStore.getElementTypeByName(DEFAULT_NAMESPACE, "Database connection")) == null) {
            elementType = DatabaseMetaStoreUtil.populateDatabaseElementType((IMetaStore)metaStore);
            metaStore.createElementType(DEFAULT_NAMESPACE, elementType);
        }
        return elementType;
    }
}

