/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.TxnInfo;
import org.apache.hadoop.hive.metastore.api.TxnState;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.TxnHandler;
import org.apache.hadoop.hive.metastore.txn.ValidCompactorTxnList;
import org.apache.hadoop.util.StringUtils;

public class CompactionTxnHandler
extends TxnHandler {
    private static final String CLASS_NAME = CompactionTxnHandler.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);

    public CompactionTxnHandler(HiveConf conf) {
        super(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CompactionInfo> findPotentialCompactions(int maxAborted) throws MetaException {
        Connection dbConn = null;
        HashSet<CompactionInfo> response = new HashSet<CompactionInfo>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                CompactionInfo info;
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                String s = "select distinct ctc_database, ctc_table, ctc_partition from COMPLETED_TXN_COMPONENTS";
                LOG.debug((Object)("Going to execute query <" + s + ">"));
                rs = stmt.executeQuery(s);
                while (rs.next()) {
                    info = new CompactionInfo();
                    info.dbname = rs.getString(1);
                    info.tableName = rs.getString(2);
                    info.partName = rs.getString(3);
                    response.add(info);
                }
                rs.close();
                s = "select tc_database, tc_table, tc_partition from TXNS, TXN_COMPONENTS where txn_id = tc_txnid and txn_state = 'a' group by tc_database, tc_table, tc_partition having count(*) > " + maxAborted;
                LOG.debug((Object)("Going to execute query <" + s + ">"));
                rs = stmt.executeQuery(s);
                while (rs.next()) {
                    info = new CompactionInfo();
                    info.dbname = rs.getString(1);
                    info.tableName = rs.getString(2);
                    info.partName = rs.getString(3);
                    info.tooManyAborts = true;
                    response.add(info);
                }
                LOG.debug((Object)"Going to rollback");
                dbConn.rollback();
            }
            catch (SQLException e) {
                try {
                    LOG.error((Object)("Unable to connect to transaction database " + e.getMessage()));
                    this.checkRetryable(dbConn, e, "findPotentialCompactions(maxAborted:" + maxAborted + ")");
                }
                catch (Throwable throwable) {
                    this.close(rs, stmt, dbConn);
                    throw throwable;
                }
                this.close(rs, stmt, dbConn);
            }
            this.close(rs, stmt, dbConn);
            return response;
        }
        catch (TxnHandler.RetryException e) {
            return this.findPotentialCompactions(maxAborted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunAs(long cq_id, String user) throws MetaException {
        try {
            Connection dbConn = null;
            Statement stmt = null;
            try {
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                String s = "update COMPACTION_QUEUE set cq_run_as = '" + user + "' where cq_id = " + cq_id;
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                int updCnt = stmt.executeUpdate(s);
                if (updCnt != 1) {
                    LOG.error((Object)("Unable to set cq_run_as=" + user + " for compaction record with cq_id=" + cq_id + ".  updCnt=" + updCnt));
                    LOG.debug((Object)"Going to rollback");
                    dbConn.rollback();
                }
                LOG.debug((Object)"Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                LOG.error((Object)("Unable to update compaction queue, " + e.getMessage()));
                LOG.debug((Object)"Going to rollback");
                this.rollbackDBConn(dbConn);
                this.checkRetryable(dbConn, e, "setRunAs(cq_id:" + cq_id + ",user:" + user + ")");
            }
            finally {
                this.closeDbConn(dbConn);
                this.closeStmt(stmt);
            }
        }
        catch (TxnHandler.RetryException e) {
            this.setRunAs(cq_id, user);
        }
    }

    /*
     * Exception decompiling
     */
    public CompactionInfo findNextToCompact(String workerId) throws MetaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[DOLOOP]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void markCompacted(CompactionInfo info) throws MetaException {
        try {
            Connection dbConn = null;
            Statement stmt = null;
            try {
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                String s = "update COMPACTION_QUEUE set cq_state = 'r', cq_worker_id = null where cq_id = " + info.id;
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                int updCnt = stmt.executeUpdate(s);
                if (updCnt != 1) {
                    LOG.error((Object)("Unable to set cq_state=r for compaction record: " + info + ". updCnt=" + updCnt));
                    LOG.debug((Object)"Going to rollback");
                    dbConn.rollback();
                }
                LOG.debug((Object)"Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error((Object)("Unable to update compaction queue " + e.getMessage()));
                    LOG.debug((Object)"Going to rollback");
                    this.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "markCompacted(" + info + ")");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.closeStmt(stmt);
                    this.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            this.closeStmt(stmt);
            this.closeDbConn(dbConn);
        }
        catch (TxnHandler.RetryException e) {
            this.markCompacted(info);
        }
    }

    public List<CompactionInfo> findReadyToClean() throws MetaException {
        ArrayList<CompactionInfo> arrayList;
        Connection dbConn = null;
        ArrayList<CompactionInfo> rc = new ArrayList<CompactionInfo>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            stmt = dbConn.createStatement();
            String s = "select cq_id, cq_database, cq_table, cq_partition, cq_type, cq_run_as from COMPACTION_QUEUE where cq_state = 'r'";
            LOG.debug((Object)("Going to execute query <" + s + ">"));
            rs = stmt.executeQuery(s);
            while (rs.next()) {
                CompactionInfo info = new CompactionInfo();
                info.id = rs.getLong(1);
                info.dbname = rs.getString(2);
                info.tableName = rs.getString(3);
                info.partName = rs.getString(4);
                switch (rs.getString(5).charAt(0)) {
                    case 'a': {
                        info.type = CompactionType.MAJOR;
                        break;
                    }
                    case 'i': {
                        info.type = CompactionType.MINOR;
                        break;
                    }
                    default: {
                        throw new MetaException("Unexpected compaction type " + rs.getString(5));
                    }
                }
                info.runAs = rs.getString(6);
                rc.add(info);
            }
            LOG.debug((Object)"Going to rollback");
            dbConn.rollback();
            arrayList = rc;
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.error((Object)("Unable to select next element for cleaning, " + e.getMessage()));
                    LOG.debug((Object)"Going to rollback");
                    this.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "findReadyToClean");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.close(rs, stmt, dbConn);
                    throw throwable;
                }
            }
            catch (TxnHandler.RetryException e2) {
                return this.findReadyToClean();
            }
        }
        this.close(rs, stmt, dbConn);
        return arrayList;
    }

    public void markCleaned(CompactionInfo info) throws MetaException {
        try {
            Connection dbConn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                dbConn = this.getDbConn(8);
                stmt = dbConn.createStatement();
                String s = "delete from COMPACTION_QUEUE where cq_id = " + info.id;
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                int updCount = stmt.executeUpdate(s);
                if (updCount != 1) {
                    LOG.error((Object)("Unable to delete compaction record: " + info + ".  Update count=" + updCount));
                    LOG.debug((Object)"Going to rollback");
                    dbConn.rollback();
                }
                s = "delete from COMPLETED_TXN_COMPONENTS where ctc_database = '" + info.dbname + "' and " + "ctc_table = '" + info.tableName + "'";
                if (info.partName != null) {
                    s = s + " and ctc_partition = '" + info.partName + "'";
                }
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                if (stmt.executeUpdate(s) < 1) {
                    LOG.error((Object)"Expected to remove at least one row from completed_txn_components when marking compaction entry as clean!");
                }
                s = "select distinct txn_id from TXNS, TXN_COMPONENTS where txn_id = tc_txnid and txn_state = 'a' and tc_database = '" + info.dbname + "' and tc_table = '" + info.tableName + "'";
                if (info.partName != null) {
                    s = s + " and tc_partition = '" + info.partName + "'";
                }
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                rs = stmt.executeQuery(s);
                ArrayList<Long> txnids = new ArrayList<Long>();
                while (rs.next()) {
                    txnids.add(rs.getLong(1));
                }
                if (txnids.size() > 0) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("delete from TXN_COMPONENTS where tc_txnid in (");
                    boolean first = true;
                    Iterator i$ = txnids.iterator();
                    while (i$.hasNext()) {
                        long id = (Long)i$.next();
                        if (first) {
                            first = false;
                        } else {
                            buf.append(", ");
                        }
                        buf.append(id);
                    }
                    buf.append(") and tc_database = '");
                    buf.append(info.dbname);
                    buf.append("' and tc_table = '");
                    buf.append(info.tableName);
                    buf.append("'");
                    if (info.partName != null) {
                        buf.append(" and tc_partition = '");
                        buf.append(info.partName);
                        buf.append("'");
                    }
                    LOG.debug((Object)("Going to execute update <" + buf.toString() + ">"));
                    int rc = stmt.executeUpdate(buf.toString());
                    LOG.debug((Object)("Removed " + rc + " records from txn_components"));
                }
                LOG.debug((Object)"Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error((Object)("Unable to delete from compaction queue " + e.getMessage()));
                    LOG.debug((Object)"Going to rollback");
                    this.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "markCleaned(" + info + ")");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.close(rs, stmt, dbConn);
                    throw throwable;
                }
            }
            this.close(rs, stmt, dbConn);
        }
        catch (TxnHandler.RetryException e) {
            this.markCleaned(info);
        }
    }

    public void cleanEmptyAbortedTxns() throws MetaException {
        try {
            ResultSet rs;
            Statement stmt;
            Connection dbConn;
            block10: {
                ArrayList<Long> txnids;
                block9: {
                    dbConn = null;
                    stmt = null;
                    rs = null;
                    dbConn = this.getDbConn(2);
                    stmt = dbConn.createStatement();
                    String s = "select txn_id from TXNS where txn_id not in (select tc_txnid from TXN_COMPONENTS) and txn_state = 'a'";
                    LOG.debug((Object)("Going to execute query <" + s + ">"));
                    rs = stmt.executeQuery(s);
                    txnids = new ArrayList<Long>();
                    while (rs.next()) {
                        txnids.add(rs.getLong(1));
                    }
                    this.close(rs);
                    if (txnids.size() > 0) break block9;
                    this.close(rs, stmt, dbConn);
                    return;
                }
                try {
                    List<Long> txnIdBatch;
                    for (int i = 0; i < txnids.size() / 1000; ++i) {
                        txnIdBatch = txnids.subList(i * 1000, (i + 1) * 1000);
                        CompactionTxnHandler.deleteTxns(dbConn, stmt, txnIdBatch);
                    }
                    int partialBatchSize = txnids.size() % 1000;
                    if (partialBatchSize <= 0) break block10;
                    txnIdBatch = txnids.subList(txnids.size() - partialBatchSize, txnids.size());
                    CompactionTxnHandler.deleteTxns(dbConn, stmt, txnIdBatch);
                }
                catch (SQLException e) {
                    try {
                        LOG.error((Object)("Unable to delete from txns table " + e.getMessage()));
                        LOG.debug((Object)"Going to rollback");
                        this.rollbackDBConn(dbConn);
                        this.checkRetryable(dbConn, e, "cleanEmptyAbortedTxns");
                        throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                    }
                    catch (Throwable throwable) {
                        this.close(rs, stmt, dbConn);
                        throw throwable;
                    }
                }
            }
            this.close(rs, stmt, dbConn);
        }
        catch (TxnHandler.RetryException e) {
            this.cleanEmptyAbortedTxns();
        }
    }

    private static void deleteTxns(Connection dbConn, Statement stmt, List<Long> txnIdBatch) throws SQLException {
        StringBuilder buf = new StringBuilder("delete from TXNS where txn_id in (");
        for (long txnid : txnIdBatch) {
            buf.append(txnid).append(',');
        }
        buf.setCharAt(buf.length() - 1, ')');
        LOG.debug((Object)("Going to execute update <" + buf + ">"));
        int rc = stmt.executeUpdate(buf.toString());
        LOG.info((Object)("Removed " + rc + "  empty Aborted transactions: " + txnIdBatch + " from TXNS"));
        LOG.debug((Object)"Going to commit");
        dbConn.commit();
    }

    public void revokeFromLocalWorkers(String hostname) throws MetaException {
        try {
            Connection dbConn = null;
            Statement stmt = null;
            try {
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                String s = "update COMPACTION_QUEUE set cq_worker_id = null, cq_start = null, cq_state = 'i' where cq_state = 'w' and cq_worker_id like '" + hostname + "%'";
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                stmt.executeUpdate(s);
                LOG.debug((Object)"Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error((Object)("Unable to change dead worker's records back to initiated state " + e.getMessage()));
                    LOG.debug((Object)"Going to rollback");
                    this.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "revokeFromLocalWorkers(hostname:" + hostname + ")");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.closeStmt(stmt);
                    this.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            this.closeStmt(stmt);
            this.closeDbConn(dbConn);
        }
        catch (TxnHandler.RetryException e) {
            this.revokeFromLocalWorkers(hostname);
        }
    }

    public void revokeTimedoutWorkers(long timeout) throws MetaException {
        try {
            Connection dbConn = null;
            Statement stmt = null;
            try {
                dbConn = this.getDbConn(2);
                long latestValidStart = this.getDbTime(dbConn) - timeout;
                stmt = dbConn.createStatement();
                String s = "update COMPACTION_QUEUE set cq_worker_id = null, cq_start = null, cq_state = 'i' where cq_state = 'w' and cq_start < " + latestValidStart;
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                stmt.executeUpdate(s);
                LOG.debug((Object)"Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error((Object)("Unable to change dead worker's records back to initiated state " + e.getMessage()));
                    LOG.debug((Object)"Going to rollback");
                    this.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "revokeTimedoutWorkers(timeout:" + timeout + ")");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.closeStmt(stmt);
                    this.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            this.closeStmt(stmt);
            this.closeDbConn(dbConn);
        }
        catch (TxnHandler.RetryException e) {
            this.revokeTimedoutWorkers(timeout);
        }
    }

    public List<String> findColumnsWithStats(CompactionInfo ci) throws MetaException {
        ArrayList<String> arrayList;
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            String quote = this.getIdentifierQuoteString(dbConn);
            stmt = dbConn.createStatement();
            StringBuilder bldr = new StringBuilder();
            bldr.append("SELECT ").append(quote).append("COLUMN_NAME").append(quote).append(" FROM ").append(quote).append(ci.partName == null ? "TAB_COL_STATS" : "PART_COL_STATS").append(quote).append(" WHERE ").append(quote).append("DB_NAME").append(quote).append(" = '").append(ci.dbname).append("' AND ").append(quote).append("TABLE_NAME").append(quote).append(" = '").append(ci.tableName).append("'");
            if (ci.partName != null) {
                bldr.append(" AND ").append(quote).append("PARTITION_NAME").append(quote).append(" = '").append(ci.partName).append("'");
            }
            String s = bldr.toString();
            LOG.debug((Object)("Going to execute <" + s + ">"));
            rs = stmt.executeQuery(s);
            ArrayList<String> columns = new ArrayList<String>();
            while (rs.next()) {
                columns.add(rs.getString(1));
            }
            LOG.debug((Object)("Found columns to update stats: " + columns + " on " + ci.tableName + (ci.partName == null ? "" : "/" + ci.partName)));
            dbConn.commit();
            arrayList = columns;
        }
        catch (SQLException e) {
            try {
                try {
                    this.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "findColumnsWithStats(" + ci.tableName + (ci.partName == null ? "" : "/" + ci.partName) + ")");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.close(rs, stmt, dbConn);
                    throw throwable;
                }
            }
            catch (TxnHandler.RetryException ex) {
                return this.findColumnsWithStats(ci);
            }
        }
        this.close(rs, stmt, dbConn);
        return arrayList;
    }

    public static ValidTxnList createValidCompactTxnList(GetOpenTxnsInfoResponse txns) {
        long highWater = txns.getTxn_high_water_mark();
        long minOpenTxn = Long.MAX_VALUE;
        long[] exceptions = new long[txns.getOpen_txnsSize()];
        int i = 0;
        for (TxnInfo txn : txns.getOpen_txns()) {
            if (txn.getState() == TxnState.OPEN) {
                minOpenTxn = Math.min(minOpenTxn, txn.getId());
            }
            exceptions[i++] = txn.getId();
        }
        return new ValidCompactorTxnList(exceptions, minOpenTxn, highWater);
    }
}

