/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.transport.TTransportException;

public class RetryingMetaStoreClient
implements InvocationHandler {
    private static final Log LOG = LogFactory.getLog((String)RetryingMetaStoreClient.class.getName());
    private final IMetaStoreClient base;
    private final int retryLimit;
    private final long retryDelaySeconds;
    private final Map<String, Long> metaCallTimeMap;

    protected RetryingMetaStoreClient(HiveConf hiveConf, HiveMetaHookLoader hookLoader, Map<String, Long> metaCallTimeMap, Class<? extends IMetaStoreClient> msClientClass) throws MetaException {
        this.retryLimit = hiveConf.getIntVar(HiveConf.ConfVars.METASTORETHRIFTFAILURERETRIES);
        this.retryDelaySeconds = hiveConf.getTimeVar(HiveConf.ConfVars.METASTORE_CLIENT_CONNECT_RETRY_DELAY, TimeUnit.SECONDS);
        this.metaCallTimeMap = metaCallTimeMap;
        this.reloginExpiringKeytabUser();
        this.base = MetaStoreUtils.newInstance(msClientClass, new Class[]{HiveConf.class, HiveMetaHookLoader.class}, new Object[]{hiveConf, hookLoader});
    }

    public static IMetaStoreClient getProxy(HiveConf hiveConf, HiveMetaHookLoader hookLoader, String mscClassName) throws MetaException {
        return RetryingMetaStoreClient.getProxy(hiveConf, hookLoader, null, mscClassName);
    }

    public static IMetaStoreClient getProxy(HiveConf hiveConf, HiveMetaHookLoader hookLoader, Map<String, Long> metaCallTimeMap, String mscClassName) throws MetaException {
        Class<?> baseClass = MetaStoreUtils.getClass(mscClassName);
        RetryingMetaStoreClient handler = new RetryingMetaStoreClient(hiveConf, hookLoader, metaCallTimeMap, baseClass);
        return (IMetaStoreClient)Proxy.newProxyInstance(RetryingMetaStoreClient.class.getClassLoader(), baseClass.getInterfaces(), (InvocationHandler)handler);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret = null;
        int retriesMade = 0;
        TException caughtException = null;
        while (true) {
            try {
                this.reloginExpiringKeytabUser();
                if (retriesMade > 0) {
                    this.base.reconnect();
                }
                if (this.metaCallTimeMap == null) {
                    ret = method.invoke((Object)this.base, args);
                    break;
                }
                long startTime = System.currentTimeMillis();
                ret = method.invoke((Object)this.base, args);
                long timeTaken = System.currentTimeMillis() - startTime;
                this.addMethodTime(method, timeTaken);
            }
            catch (UndeclaredThrowableException e) {
                throw e.getCause();
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                if (t instanceof TApplicationException) {
                    TApplicationException tae = (TApplicationException)t;
                    switch (tae.getType()) {
                        case 1: 
                        case 3: 
                        case 9: 
                        case 10: {
                            throw t;
                        }
                    }
                    caughtException = tae;
                } else if (t instanceof TProtocolException || t instanceof TTransportException) {
                    caughtException = (TException)t;
                } else if (t instanceof MetaException && t.getMessage().matches("(?s).*(JDO[a-zA-Z]*|TProtocol|TTransport)Exception.*")) {
                    caughtException = (MetaException)((Object)t);
                } else {
                    throw t;
                }
                if (retriesMade >= this.retryLimit) {
                    throw caughtException;
                }
                ++retriesMade;
                LOG.warn((Object)"MetaStoreClient lost connection. Attempting to reconnect.", (Throwable)caughtException);
                Thread.sleep(this.retryDelaySeconds * 1000L);
                continue;
            }
            break;
        }
        return ret;
    }

    private void addMethodTime(Method method, long timeTaken) {
        String methodStr = this.getMethodString(method);
        Long curTime = this.metaCallTimeMap.get(methodStr);
        if (curTime != null) {
            timeTaken += curTime.longValue();
        }
        this.metaCallTimeMap.put(methodStr, timeTaken);
    }

    private String getMethodString(Method method) {
        StringBuilder methodSb = new StringBuilder(method.getName());
        methodSb.append("_(");
        for (Class<?> paramClass : method.getParameterTypes()) {
            methodSb.append(paramClass.getSimpleName());
            methodSb.append(", ");
        }
        methodSb.append(")");
        return methodSb.toString();
    }

    private void reloginExpiringKeytabUser() throws MetaException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        try {
            UserGroupInformation ugi = UserGroupInformation.getLoginUser();
            if (ugi.isFromKeytab()) {
                ugi.checkTGTAndReloginFromKeytab();
            }
        }
        catch (IOException e) {
            String msg = "Error doing relogin using keytab " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new MetaException(msg);
        }
    }
}

