/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.raw.extender.intern;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.ops4j.pax.exam.ProbeInvoker;
import org.ops4j.pax.exam.ProbeInvokerFactory;
import org.ops4j.pax.exam.raw.extender.intern.Probe;
import org.ops4j.pax.exam.raw.extender.intern.ProbeInvokerImpl;
import org.ops4j.pax.swissbox.extender.ManifestEntry;
import org.ops4j.pax.swissbox.tracker.ServiceLookup;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    private static final Logger LOG = LoggerFactory.getLogger(Probe.class);
    private final Probe[] probes;

    public Parser(BundleContext ctx, String sigs, List<ManifestEntry> manifestEntries) {
        ArrayList<String> signatures = new ArrayList<String>();
        ArrayList<Probe> probeList = new ArrayList<Probe>();
        signatures.addAll(Arrays.asList(sigs.split(",")));
        for (ManifestEntry manifestEntry : manifestEntries) {
            LOG.debug("Test " + manifestEntry.getKey() + " to be in " + sigs);
            if (!signatures.contains(manifestEntry.getKey())) continue;
            probeList.add(this.make(ctx, manifestEntry.getKey(), manifestEntry.getValue()));
        }
        this.probes = probeList.toArray(new Probe[probeList.size()]);
    }

    private Probe make(BundleContext ctx, String sig, String expr) {
        LOG.debug("Registering Service: " + ProbeInvoker.class.getName() + " with Probe-Signature=\"" + sig + "\" and expression=\"" + expr + "\"");
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("Probe-Signature", sig);
        return new Probe(ProbeInvoker.class.getName(), this.createInvoker(ctx, expr), props);
    }

    private ProbeInvoker createInvoker(BundleContext ctx, String expr) {
        String invokerType = System.getProperty("pax.exam.invoker");
        if (invokerType == null) {
            return new ProbeInvokerImpl(expr, ctx);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("driver", invokerType);
        ProbeInvokerFactory factory = (ProbeInvokerFactory)ServiceLookup.getService((BundleContext)ctx, ProbeInvokerFactory.class, props);
        return factory.createProbeInvoker((Object)ctx, expr);
    }

    public Probe[] getProbes() {
        return this.probes;
    }
}

