/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofPackage;
import javax.jmi.model.Tag;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.XmiReader;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.lib.jmi.util.Logger;
import org.openide.util.Lookup;

public class MetamodelManager {
    protected final MDRepository repository;
    private final Class cls;
    private Map cache;
    private ModelPackage extent;
    private String extentName;
    private String version;
    private String fileName;

    public MetamodelManager(MDRepository repository, Class cls) {
        this.repository = repository;
        this.cls = cls;
    }

    public synchronized MofPackage findRootPackage(String packageName) {
        if (this.extent == null) {
            this.update();
        }
        if (this.cache == null) {
            this.cache = new HashMap();
            Iterator it = this.extent.getMofPackage().refAllOfClass().iterator();
            while (it.hasNext()) {
                MofPackage pkg = (MofPackage)it.next();
                if (pkg.getContainer() != null) continue;
                this.cache.put(pkg.getName(), pkg);
            }
        }
        return (MofPackage)this.cache.get(packageName);
    }

    protected synchronized String getVersion() {
        this.initCheck();
        return this.version;
    }

    protected synchronized String getExtentName() {
        this.initCheck();
        return this.extentName;
    }

    private void initCheck() {
        if (this.fileName == null) {
            try {
                Manifest mf = new Manifest(this.cls.getResourceAsStream("/META-INF/MANIFEST.MF"));
                Attributes attrs = mf.getMainAttributes();
                this.extentName = attrs.getValue("NBMDR-Metamodel");
                if (this.extentName == null) {
                    Enumeration<URL> e = this.cls.getClassLoader().getResources("META-INF/MANIFEST.MF");
                    while (e.hasMoreElements() && this.extentName == null) {
                        URL u = e.nextElement();
                        InputStream is = u.openStream();
                        mf = new Manifest(is);
                        attrs = mf.getMainAttributes();
                        this.extentName = attrs.getValue("NBMDR-Metamodel");
                    }
                }
                this.fileName = "/" + attrs.getValue("NBMDR-Metamodel-File");
                this.version = attrs.getValue("NBMDR-Metamodel-Version");
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    private void update() {
        this.initCheck();
        boolean fail = true;
        this.repository.beginTrans(true);
        try {
            Logger.getDefault().log("Looking for extent " + this.extentName + " in repository " + this.repository);
            this.extent = (ModelPackage)this.repository.getExtent(this.extentName);
            if (this.extent != null) {
                Tag tag = null;
                Iterator it = this.extent.getTag().refAllOfClass().iterator();
                while (it.hasNext()) {
                    Tag temp = (Tag)it.next();
                    if (!"org.netbeans.version".equals(temp.getTagId())) continue;
                    tag = temp;
                    break;
                }
                if (tag == null || tag.getValues().isEmpty() || !tag.getValues().iterator().next().equals(this.version)) {
                    Logger.getDefault().log("Metamodel version is outdated - it needs to be reloaded.");
                    String[] names = this.repository.getExtentNames();
                    for (int i = 0; i < names.length; ++i) {
                        RefPackage tmp = this.repository.getExtent(names[i]);
                        if (tmp instanceof ModelPackage) continue;
                        tmp.refDelete();
                    }
                    this.extent.refDelete();
                    this.extent = null;
                }
            } else {
                Logger.getDefault().log("Extent not found.");
            }
            if (this.extent == null) {
                this.extent = (ModelPackage)this.repository.createExtent(this.extentName);
                XmiReader xmr = (XmiReader)Lookup.getDefault().lookup(XmiReader.class);
                Collection outermostElements = xmr.read(this.cls.getResource(this.fileName).toString(), (RefPackage)this.extent);
                this.extent.getTag().createTag("org.netbeans.version", "", "org.netbeans.version", Arrays.asList(this.version));
                this.cache = new HashMap();
                Iterator it = outermostElements.iterator();
                while (it.hasNext()) {
                    Object temp = it.next();
                    if (!(temp instanceof MofPackage)) continue;
                    this.cache.put(((MofPackage)temp).getName(), temp);
                }
            }
            fail = false;
        }
        catch (Exception ex) {
            throw (IllegalStateException)Logger.getDefault().annotate((Throwable)new IllegalStateException("Metamodel XMI malformed."), (Throwable)ex);
        }
        finally {
            this.repository.endTrans(fail);
        }
    }
}

