/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;

public class PentahoPathDecodingFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        EncodingAwareHttpServletRequestWrapper wrapper = new EncodingAwareHttpServletRequestWrapper((HttpServletRequest)servletRequest);
        filterChain.doFilter((ServletRequest)wrapper, servletResponse);
    }

    public void destroy() {
    }

    private static final class EncodingAwareHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private EncodingAwareHttpServletRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public String getPathInfo() {
            String pathInfo = super.getPathInfo();
            if (StringUtils.isEmpty((String)pathInfo)) {
                return pathInfo;
            }
            return pathInfo.replaceAll("%5C", "\\\\").replaceAll("%2F", "/");
        }

        public String getRequestURI() {
            String requestURI = super.getRequestURI();
            return requestURI.replaceAll("%255C", "%5C").replaceAll("%252F", "%2F");
        }
    }
}

