/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.webservices;

import com.ibm.wsdl.factory.WSDLFactoryImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.wsdl.Definition;
import javax.wsdl.xml.WSDLReader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.util.Loader;
import org.apache.ws.java2wsdl.Java2WSDLBuilder;
import org.pentaho.platform.api.engine.IServiceConfig;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.webservices.SystemSolutionAxisConfigurator;
import org.xml.sax.InputSource;

public class AxisUtil {
    public static String WS_EXECUTE_SERVICE_ID = "ws-run";
    public static String WSDL_SERVICE_ID = "ws-wsdl";

    public static Definition getWsdlDefinition(AxisConfiguration axisConfig, IServiceConfig webservice) throws Exception {
        String wsdlStr = AxisUtil.getWsdl(axisConfig, webservice);
        ByteArrayInputStream in = new ByteArrayInputStream(wsdlStr.getBytes());
        InputSource source = new InputSource(in);
        WSDLFactoryImpl factory = new WSDLFactoryImpl();
        WSDLReader reader = factory.newWSDLReader();
        Definition def = reader.readWSDL("", source);
        return def;
    }

    public static String getWsdl(AxisConfiguration axisConfig, IServiceConfig webservice) throws Exception {
        Class serviceClass = webservice.getServiceClass();
        String name = serviceClass.getSimpleName();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Java2WSDLBuilder java2WsdlBuilder = new Java2WSDLBuilder((OutputStream)out, serviceClass.getName(), serviceClass.getClassLoader());
        Collection extraClasses = webservice.getExtraClasses();
        if (extraClasses != null) {
            ArrayList<String> extraClassNames = new ArrayList<String>();
            for (Class extraClass : extraClasses) {
                extraClassNames.add(extraClass.getName());
            }
            java2WsdlBuilder.setExtraClasses(extraClassNames);
        }
        java2WsdlBuilder.setSchemaTargetNamespace("http://webservice.pentaho.com");
        java2WsdlBuilder.setLocationUri(AxisUtil.getWebServiceExecuteUrl() + name);
        java2WsdlBuilder.setTargetNamespacePrefix("pho");
        java2WsdlBuilder.setServiceName(name);
        java2WsdlBuilder.setAttrFormDefault("unqualified");
        java2WsdlBuilder.setElementFormDefault("unqualified");
        java2WsdlBuilder.setGenerateDocLitBare(false);
        java2WsdlBuilder.generateWSDL();
        return new String(out.toByteArray());
    }

    public static AxisService createService(IServiceConfig ws, AxisConfiguration axisConfig) throws AxisFault {
        Class serviceClass = ws.getServiceClass();
        String serviceName = ws.getId();
        if (axisConfig.getService(serviceName) != null) {
            axisConfig.removeService(serviceName);
        }
        AxisService axisService = AxisUtil.createService(serviceClass.getName(), axisConfig, serviceClass.getClassLoader());
        axisService.setName(serviceName);
        axisService.setDocumentation(ws.getDescription());
        return axisService;
    }

    private static AxisService createService(String implClass, AxisConfiguration axisConfig, ClassLoader loader) throws AxisFault {
        try {
            HashMap<String, MessageReceiver> messageReciverMap = new HashMap<String, MessageReceiver>();
            Class inOnlyMessageReceiver = Loader.loadClass((String)"org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver");
            MessageReceiver messageReceiver = (MessageReceiver)inOnlyMessageReceiver.newInstance();
            messageReciverMap.put("http://www.w3.org/ns/wsdl/in-only", messageReceiver);
            Class inoutMessageReceiver = Loader.loadClass((String)"org.apache.axis2.rpc.receivers.RPCMessageReceiver");
            MessageReceiver inOutmessageReceiver = (MessageReceiver)inoutMessageReceiver.newInstance();
            messageReciverMap.put("http://www.w3.org/ns/wsdl/in-out", inOutmessageReceiver);
            messageReciverMap.put("http://www.w3.org/ns/wsdl/robust-in-only", inOutmessageReceiver);
            return AxisService.createService((String)implClass, (AxisConfiguration)axisConfig, messageReciverMap, null, null, (ClassLoader)loader);
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    public static void createServiceWsdl(AxisService axisService, IServiceConfig wsDef, AxisConfiguration axisConfig) throws Exception {
        Parameter useOriginalwsdl = new Parameter();
        useOriginalwsdl.setName("useOriginalwsdl");
        useOriginalwsdl.setValue((Object)"true");
        axisService.addParameter(useOriginalwsdl);
        Definition wsdlDefn = AxisUtil.getWsdlDefinition(axisConfig, wsDef);
        Parameter wsdl = new Parameter();
        wsdl.setName("wsdl4jDefinition");
        wsdl.setValue((Object)wsdlDefn);
        axisService.addParameter(wsdl);
    }

    public static IServiceConfig getSourceDefinition(AxisService axisService, SystemSolutionAxisConfigurator axisConfigurator) {
        return axisConfigurator.getWebServiceDefinition(axisService.getName());
    }

    public static String getWebServiceExecuteUrl() {
        String url = PentahoSystem.getApplicationContext().getFullyQualifiedServerURL() + "content/" + WS_EXECUTE_SERVICE_ID + "/";
        return url;
    }

    public static String getWebServiceWsdlUrl() {
        String url = PentahoSystem.getApplicationContext().getFullyQualifiedServerURL() + "content/" + WSDL_SERVICE_ID + "/";
        return url;
    }
}

