/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.exporter;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.pentaho.platform.api.scheduler2.ComplexJobTrigger;
import org.pentaho.platform.api.scheduler2.CronJobTrigger;
import org.pentaho.platform.api.scheduler2.Job;
import org.pentaho.platform.api.scheduler2.SimpleJobTrigger;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.pentaho.platform.web.http.api.resources.JobScheduleParam;
import org.pentaho.platform.web.http.api.resources.JobScheduleRequest;
import org.pentaho.platform.web.http.api.resources.RepositoryFileStreamProvider;

public class ScheduleExportUtil {
    public static JobScheduleRequest createJobScheduleRequest(Job job) {
        SimpleJobTrigger jobTrigger;
        if (job == null) {
            throw new IllegalArgumentException(Messages.getInstance().getString("ScheduleExportUtil.JOB_MUST_NOT_BE_NULL"));
        }
        JobScheduleRequest schedule = new JobScheduleRequest();
        schedule.setJobName(job.getJobName());
        schedule.setDuration(job.getJobTrigger().getDuration());
        schedule.setJobState(job.getState());
        Map jobParams = job.getJobParams();
        Object streamProviderObj = jobParams.get("ActionAdapterQuartzJob-StreamProvider");
        RepositoryFileStreamProvider streamProvider = null;
        if (streamProviderObj instanceof RepositoryFileStreamProvider) {
            streamProvider = (RepositoryFileStreamProvider)streamProviderObj;
        } else if (streamProviderObj instanceof String) {
            String inputFilePath = null;
            String outputFilePath = null;
            String inputOutputString = (String)streamProviderObj;
            Object[] tokens = inputOutputString.split(":");
            if (!ArrayUtils.isEmpty((Object[])tokens) && tokens.length == 2) {
                inputFilePath = ((String)tokens[0]).split("=")[1].trim();
                outputFilePath = ((String)tokens[1]).split("=")[1].trim();
                streamProvider = new RepositoryFileStreamProvider(inputFilePath, outputFilePath, true);
            }
        }
        if (streamProvider != null) {
            schedule.setInputFile(streamProvider.getInputFilePath());
            schedule.setOutputFile(streamProvider.getOutputFilePath());
        } else {
            String artifact;
            String directory = (String)jobParams.get("directory");
            String transName = (String)jobParams.get("transformation");
            String jobName = (String)jobParams.get("job");
            String string = artifact = transName == null ? jobName : transName;
            if (directory != null && artifact != null) {
                String outputFile = RepositoryFilenameUtils.concat((String)directory, (String)artifact);
                outputFile = outputFile + "*";
                artifact = artifact.equals(jobName) ? artifact + ".kjb" : artifact + ".ktr";
                String inputFile = RepositoryFilenameUtils.concat((String)directory, (String)artifact);
                schedule.setInputFile(inputFile);
                schedule.setOutputFile(outputFile);
            }
        }
        for (String key : jobParams.keySet()) {
            Serializable serializable = (Serializable)jobParams.get(key);
            JobScheduleParam param = null;
            if (serializable instanceof String) {
                String value = (String)((Object)serializable);
                if ("ActionAdapterQuartzJob-ActionClass".equals(key)) {
                    schedule.setActionClass(value);
                } else if ("TIME_ZONE_PARAM".equals(key)) {
                    schedule.setTimeZone(value);
                }
                param = new JobScheduleParam(key, (String)((Object)serializable));
            } else if (serializable instanceof Number) {
                param = new JobScheduleParam(key, (Number)serializable);
            } else if (serializable instanceof Date) {
                param = new JobScheduleParam(key, (Date)serializable);
            } else if (serializable instanceof Boolean) {
                param = new JobScheduleParam(key, (Boolean)serializable);
            }
            if (param == null) continue;
            schedule.getJobParameters().add(param);
        }
        if (job.getJobTrigger() instanceof SimpleJobTrigger) {
            jobTrigger = (SimpleJobTrigger)job.getJobTrigger();
            schedule.setSimpleJobTrigger(jobTrigger);
        } else if (job.getJobTrigger() instanceof ComplexJobTrigger) {
            jobTrigger = (ComplexJobTrigger)job.getJobTrigger();
            CronJobTrigger cron = new CronJobTrigger();
            cron.setCronString(jobTrigger.getCronString());
            cron.setStartTime(jobTrigger.getStartTime());
            cron.setEndTime(jobTrigger.getEndTime());
            cron.setDuration(jobTrigger.getDuration());
            cron.setUiPassParam(jobTrigger.getUiPassParam());
            schedule.setCronJobTrigger(cron);
        } else if (job.getJobTrigger() instanceof CronJobTrigger) {
            jobTrigger = (CronJobTrigger)job.getJobTrigger();
            schedule.setCronJobTrigger((CronJobTrigger)jobTrigger);
        } else {
            throw new IllegalArgumentException(Messages.getInstance().getString("PentahoPlatformExporter.UNSUPPORTED_JobTrigger", new Object[]{job.getJobTrigger().getClass().getName()}));
        }
        return schedule;
    }
}

